/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.view;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.lang.reflect.Method;

public class SimpleWebView
extends WebView {
    public SimpleWebView(Context context) {
        super(context);
        this.restrictDeviceContentAccess();
        SimpleWebView.configSafeWebView(this);
        SimpleWebView.initializeWebView(this, context);
        this.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (TextUtils.isEmpty((CharSequence)url) || "about:blank".equals(url)) {
                    return false;
                }
                view.loadUrl(url);
                return true;
            }
        });
        this.setWebChromeClient(new WebChromeClient());
    }

    private void restrictDeviceContentAccess() {
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setAllowContentAccess(false);
        if (Build.VERSION.SDK_INT >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(false);
            this.getSettings().setAllowUniversalAccessFromFileURLs(false);
        }
    }

    public static void configSafeWebView(WebView webView) {
        if (webView == null) {
            return;
        }
        webView.removeJavascriptInterface("searchBoxjavaBridge_");
        webView.removeJavascriptInterface("accessibility");
        webView.removeJavascriptInterface("accessibilityTraversal");
        webView.getSettings().setAllowFileAccess(false);
        if (Build.VERSION.SDK_INT >= 16) {
            webView.getSettings().setAllowFileAccessFromFileURLs(false);
            webView.getSettings().setAllowUniversalAccessFromFileURLs(false);
        }
        webView.getSettings().setSavePassword(false);
    }

    public static void initializeWebView(WebView mWebView, Context context) {
        WebSettings webSettings = mWebView.getSettings();
        mWebView.setHorizontalScrollBarEnabled(false);
        mWebView.setVerticalScrollBarEnabled(false);
        mWebView.setVerticalScrollBarEnabled(false);
        mWebView.requestFocus();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setAllowFileAccess(false);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setSavePassword(false);
        webSettings.setDatabaseEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                webSettings.setMixedContentMode(1);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Method var7 = WebSettings.class.getDeclaredMethod("setDisplayZoomControls", Boolean.TYPE);
                var7.setAccessible(true);
                var7.invoke((Object)webSettings, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        webSettings.setDatabaseEnabled(false);
        webSettings.setGeolocationEnabled(false);
    }
}

