/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.videoad;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdSourceStatusListener;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.ATEventInterface;
import com.anythink.core.api.ATNetworkConfirmInfo;
import com.anythink.core.api.ATSDK;
import com.anythink.core.api.AdError;
import com.anythink.rewardvideo.api.ATRewardVideoAd;
import com.anythink.rewardvideo.api.ATRewardVideoExListener;
import com.anythink.rewardvideo.api.ATRewardVideoListener;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.download.DownloadHelper;
import com.anythink.unitybridge.utils.Const;
import com.anythink.unitybridge.utils.TaskManager;
import com.anythink.unitybridge.videoad.VideoListener;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class VideoHelper {
    public static final String TAG = "AT_android_unity3d";
    VideoListener mListener;
    Activity mActivity;
    ATRewardVideoAd mRewardVideoAd;
    String mPlacementId;
    boolean isReady = false;
    boolean isReward = false;

    public VideoHelper(VideoListener pListener) {
        MsgTools.printMsg("VideoHelper: " + this);
        if (pListener == null) {
            MsgTools.printMsg("Listener == null: ");
        }
        this.mListener = pListener;
        this.mActivity = UnityPluginUtils.getActivity("VideoHelper");
    }

    public void initVideo(String placementId) {
        MsgTools.printMsg("initVideo 1: " + placementId);
        this.mRewardVideoAd = new ATRewardVideoAd((Context)this.mActivity, placementId);
        this.mPlacementId = placementId;
        MsgTools.printMsg("initVideo 2: " + placementId);
        this.mRewardVideoAd.setAdListener((ATRewardVideoListener)new ATRewardVideoExListener(){

            public void onRewardFailed(ATAdInfo atAdInfo) {
            }

            public void onDeeplinkCallback(ATAdInfo atAdInfo, boolean b) {
            }

            public void onDownloadConfirm(Context context, ATAdInfo atAdInfo, ATNetworkConfirmInfo atNetworkConfirmInfo) {
            }

            public void onRewardedVideoAdAgainPlayStart(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onRewardedVideoAdAgainPlayStart: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdAgainPlayStart(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdAgainPlayEnd(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onRewardedVideoAdAgainPlayEnd: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdAgainPlayEnd(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdAgainPlayFailed(final AdError adError, ATAdInfo atAdInfo) {
                MsgTools.printMsg("onRewardedVideoAdAgainPlayFailed: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdAgainPlayFailed(VideoHelper.this.mPlacementId, adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdAgainPlayClicked(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onRewardedVideoAdAgainPlayClicked: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdAgainPlayClicked(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAgainReward(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAgainReward: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onAgainReward(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAgainRewardFailed(ATAdInfo atAdInfo) {
            }

            public void onRewardedVideoAdLoaded() {
                MsgTools.printMsg("onRewardedVideoAdLoaded: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        VideoHelper.this.isReady = true;
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdLoaded(VideoHelper.this.mPlacementId);
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdFailed(final AdError pAdError) {
                MsgTools.printMsg("onRewardedVideoAdFailed: " + VideoHelper.this.mPlacementId + ", " + pAdError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdFailed(VideoHelper.this.mPlacementId, pAdError.getCode(), pAdError.getFullErrorInfo());
                            }
                        } else {
                            MsgTools.printMsg("onRewardedVideoAdFailed callnoback: " + pAdError.getFullErrorInfo());
                        }
                    }
                });
            }

            public void onRewardedVideoAdPlayStart(final ATAdInfo adInfo) {
                MsgTools.printMsg("onRewardedVideoAdPlayStart: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdPlayStart(VideoHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdPlayEnd(final ATAdInfo adInfo) {
                MsgTools.printMsg("onRewardedVideoAdPlayEnd: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdPlayEnd(VideoHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdPlayFailed(final AdError pAdError, ATAdInfo adInfo) {
                MsgTools.printMsg("onRewardedVideoAdPlayFailed: " + VideoHelper.this.mPlacementId + ", " + pAdError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdPlayFailed(VideoHelper.this.mPlacementId, pAdError.getCode(), pAdError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdClosed(final ATAdInfo adInfo) {
                MsgTools.printMsg("onRewardedVideoAdClosed: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdClosed(VideoHelper.this.mPlacementId, VideoHelper.this.isReward, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onRewardedVideoAdPlayClicked(final ATAdInfo adInfo) {
                MsgTools.printMsg("onRewardedVideoAdPlayClicked: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onRewardedVideoAdPlayClicked(VideoHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onReward(final ATAdInfo adInfo) {
                MsgTools.printMsg("onReward: " + VideoHelper.this.mPlacementId);
                VideoHelper.this.isReward = true;
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onReward(VideoHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }
        });
        this.mRewardVideoAd.setAdSourceStatusListener(new ATAdSourceStatusListener(){

            public void onAdSourceBiddingAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingAttempt: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onAdSourceBiddingAttempt(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingFilled: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onAdSourceBiddingFilled(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceBiddingFail: " + VideoHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onAdSourceBiddingFail(VideoHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onAdSourceAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceAttemp: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onAdSourceAttempt(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceLoadFilled: " + VideoHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onAdSourceLoadFilled(VideoHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceLoadFail: " + VideoHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoHelper.this.mListener != null) {
                            VideoHelper videoHelper = VideoHelper.this;
                            synchronized (videoHelper) {
                                VideoHelper.this.mListener.onAdSourceLoadFail(VideoHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }
        });
        MsgTools.printMsg("initVideo 3: " + this.mPlacementId);
        try {
            if (ATSDK.isCnSDK()) {
                this.mRewardVideoAd.setAdDownloadListener((ATEventInterface)DownloadHelper.getDownloadListener(this.mPlacementId));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void fillVideo(final String jsonMap) {
        MsgTools.printMsg("fillVideo start: " + this.mPlacementId + ", jsonMap: " + jsonMap);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String userId = "";
                String userExtraData = "";
                HashMap<String, Object> localExtra = new HashMap<String, Object>();
                try {
                    if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
                        JSONObject jsonObject = new JSONObject(jsonMap);
                        Const.fillMapFromJsonObject(localExtra, jsonObject);
                        if (jsonObject.has("UserId")) {
                            userId = jsonObject.optString("UserId");
                        }
                        if (jsonObject.has("UserExtraData")) {
                            userExtraData = jsonObject.optString("UserExtraData");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (VideoHelper.this.mRewardVideoAd != null) {
                    if (!TextUtils.isEmpty((CharSequence)userId) || !TextUtils.isEmpty((CharSequence)userExtraData)) {
                        localExtra.put("user_id", userId);
                        localExtra.put("user_custom_data", userExtraData);
                        MsgTools.printMsg("fillVideo: " + VideoHelper.this.mPlacementId + ", userId:" + userId + ", userExtraData:" + userExtraData);
                    }
                    VideoHelper.this.mRewardVideoAd.setLocalExtra(localExtra);
                    VideoHelper.this.mRewardVideoAd.load();
                } else {
                    MsgTools.printMsg("fillVideo error, you must call initVideo first " + VideoHelper.this.mPlacementId);
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (VideoHelper.this.mListener != null) {
                                VideoHelper videoHelper = VideoHelper.this;
                                synchronized (videoHelper) {
                                    VideoHelper.this.mListener.onRewardedVideoAdFailed(VideoHelper.this.mPlacementId, "-1", "you must call initVideo first");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void showVideo(final String jsonMap) {
        MsgTools.printMsg("showVideo: " + this.mPlacementId + ", jsonMap: " + jsonMap);
        this.isReward = false;
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoHelper.this.mRewardVideoAd != null) {
                    VideoHelper.this.isReady = false;
                    String scenario = "";
                    if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
                        try {
                            JSONObject _jsonObject = new JSONObject(jsonMap);
                            if (_jsonObject.has("Scenario")) {
                                scenario = _jsonObject.optString("Scenario");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    MsgTools.printMsg("showVideo: " + VideoHelper.this.mPlacementId + ", scenario: " + scenario);
                    if (!TextUtils.isEmpty((CharSequence)scenario)) {
                        VideoHelper.this.mRewardVideoAd.show(VideoHelper.this.mActivity, scenario);
                    } else {
                        VideoHelper.this.mRewardVideoAd.show(VideoHelper.this.mActivity);
                    }
                } else {
                    MsgTools.printMsg("showVideo error, you must call initVideo first " + VideoHelper.this.mPlacementId);
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (VideoHelper.this.mListener != null) {
                                VideoHelper videoHelper = VideoHelper.this;
                                synchronized (videoHelper) {
                                    VideoHelper.this.mListener.onRewardedVideoAdFailed(VideoHelper.this.mPlacementId, "-1", "you must call initVideo first");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public boolean isAdReady() {
        MsgTools.printMsg("isAdReady start: " + this.mPlacementId);
        try {
            if (this.mRewardVideoAd != null) {
                boolean isAdReady = this.mRewardVideoAd.isAdReady();
                MsgTools.printMsg("isAdReady: " + this.mPlacementId + isAdReady);
                return isAdReady;
            }
            MsgTools.printMsg("isAdReady error, you must call initVideo first ");
            MsgTools.printMsg("isAdReady end: " + this.mPlacementId);
        }
        catch (Exception e) {
            MsgTools.printMsg("isAdReady Exception: " + e.getMessage());
            return this.isReady;
        }
        catch (Throwable e) {
            MsgTools.printMsg("isAdReady Throwable:" + e.getMessage());
            return this.isReady;
        }
        return this.isReady;
    }

    public String checkAdStatus() {
        MsgTools.printMsg("checkAdStatus: " + this.mPlacementId);
        if (this.mRewardVideoAd != null) {
            ATAdStatusInfo atAdStatusInfo = this.mRewardVideoAd.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                try {
                    if (atTopAdInfo != null) {
                        jsonObject.put("adInfo", (Object)new JSONObject(atTopAdInfo.toString()));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                MsgTools.printMsg("checkAdStatus: result = " + jsonObject);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String getValidAdCaches() {
        MsgTools.printMsg("getValidAdCaches:" + this.mPlacementId);
        if (this.mRewardVideoAd != null) {
            JSONArray jsonArray = new JSONArray();
            List vaildAds = this.mRewardVideoAd.checkValidAdCaches();
            if (vaildAds == null) {
                return "";
            }
            int size = vaildAds.size();
            for (int i = 0; i < size; ++i) {
                try {
                    jsonArray.put((Object)new JSONObject(((ATAdInfo)vaildAds.get(i)).toString()));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return jsonArray.toString();
        }
        return "";
    }

    public void entryAdScenario(final String scenarioId) {
        MsgTools.printMsg("entryAdScenario start: " + this.mPlacementId + ", scenarioId: " + scenarioId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)VideoHelper.this.mPlacementId)) {
                    ATRewardVideoAd.entryAdScenario((String)VideoHelper.this.mPlacementId, (String)scenarioId);
                } else {
                    MsgTools.printMsg("entryAdScenario error, you must call initVideo first " + VideoHelper.this.mPlacementId);
                }
            }
        });
    }
}

