/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.sdkinit;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.text.TextUtils;
import android.util.Log;
import com.anythink.core.api.ATAreaCallback;
import com.anythink.core.api.ATGDPRConsentDismissListener;
import com.anythink.core.api.ATSDK;
import com.anythink.core.api.NetTrafficeCallback;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.sdkinit.AreaCallbackListener;
import com.anythink.unitybridge.sdkinit.SDKConsentDismissListener;
import com.anythink.unitybridge.sdkinit.SDKEUCallbackListener;
import com.anythink.unitybridge.sdkinit.SDKInitListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class SDKInitHelper {
    SDKInitListener mSDKInitListener;
    Activity mActivity;
    public static final String TAG = "AT_android_unity3d";
    private static final String SP_KEY_FIRST_RUN = "SP_KEY_FIRST_RUN";

    public SDKInitHelper(SDKInitListener pSDKInitListener) {
        if (pSDKInitListener == null) {
            MsgTools.printMsg("pSDKInitListener == null ..");
        }
        this.mSDKInitListener = pSDKInitListener;
        this.mActivity = UnityPluginUtils.getActivity("SDKInitHelper");
    }

    public void initAppliction(String appid, String appkey) {
        if (this.mActivity == null || TextUtils.isEmpty((CharSequence)appid) || TextUtils.isEmpty((CharSequence)appkey)) {
            MsgTools.printMsg("initAppliction--> sActivity == null || appid == null || appkey == null");
            if (this.mSDKInitListener != null) {
                this.mSDKInitListener.initSDKError(appid, "activity can not be null ");
            }
            return;
        }
        MsgTools.printMsg("initAppliction--> appid:" + appid);
        ATSDK.setSystemDevFragmentType((String)"2");
        ATSDK.init((Context)this.mActivity, (String)appid, (String)appkey);
        if (this.mSDKInitListener != null) {
            this.mSDKInitListener.initSDKSuccess(appid);
        }
    }

    public void showDebuggerUI() {
        this.showDebuggerUI("");
    }

    public void showDebuggerUI(String debugKey) {
        try {
            Class<?> debuggerUI = Class.forName("com.anythink.debug.api.ATDebuggerUITest");
            Method showDebuggerUIMethod = debuggerUI.getMethod("showDebuggerUI", Context.class, String.class);
            showDebuggerUIMethod.invoke(null, this.mActivity, debugKey);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("showDebuggerUI() >>> failed: " + e.getMessage()));
        }
    }

    public void setDebugLogOpen(boolean isOpen) {
        MsgTools.printMsg("setDebugLogOpen--> :" + isOpen);
        ATSDK.setNetworkLogDebug((boolean)isOpen);
        MsgTools.isDebug = isOpen;
    }

    public void setChannel(String channel) {
        MsgTools.printMsg("setChannel--> :" + channel);
        ATSDK.setChannel((String)channel);
    }

    public void setSubChannel(String subChannel) {
        MsgTools.printMsg("setSubChannel--> :" + subChannel);
        ATSDK.setSubChannel((String)subChannel);
    }

    public void initCustomMap(String jsonMap) {
        MsgTools.printMsg("initCustomMap--> :" + jsonMap != null ? jsonMap : "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            try {
                JSONObject jsonObject = new JSONObject(jsonMap);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    map.put(key, jsonObject.opt(key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ATSDK.initCustomMap(map);
    }

    public void initPlacementCustomMap(String placementId, String jsonMap) {
        MsgTools.printMsg("initPlacementCustomMap-->" + placementId + ":" + jsonMap != null ? jsonMap : "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            try {
                JSONObject jsonObject = new JSONObject(jsonMap);
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    map.put(key, jsonObject.opt(key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ATSDK.initPlacementCustomMap((String)placementId, map);
    }

    public int getGDPRLevel() {
        MsgTools.printMsg("getGDPRLevel");
        return ATSDK.getGDPRDataLevel((Context)this.mActivity);
    }

    public boolean isEUTraffic() {
        MsgTools.printMsg("isEUTraffic");
        return ATSDK.isEUTraffic((Context)this.mActivity);
    }

    public void setGDPRLevel(int level) {
        MsgTools.printMsg("setGDPRLevel--> level:" + level);
        ATSDK.setGDPRUploadDataLevel((Context)this.mActivity, (int)level);
    }

    public void checkIsEuTraffic(final SDKEUCallbackListener callbackListener) {
        MsgTools.printMsg("checkIsEuTraffic");
        ATSDK.checkIsEuTraffic((Context)this.mActivity, (NetTrafficeCallback)new NetTrafficeCallback(){

            public void onResultCallback(boolean b) {
                MsgTools.printMsg("check EU:" + b);
                if (callbackListener != null) {
                    callbackListener.onResultCallback(b);
                }
            }

            public void onErrorCallback(String s) {
                MsgTools.printMsg("check EU error:" + s);
                if (callbackListener != null) {
                    callbackListener.onErrorCallback(s);
                }
            }
        });
    }

    public void showGDPRAuth() {
        MsgTools.printMsg("showGDPRAuth ");
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ATSDK.showGdprAuth((Context)SDKInitHelper.this.mActivity);
            }
        });
    }

    public void showGDPRConsentDialog(final SDKConsentDismissListener listener) {
        MsgTools.printMsg("showGDPRConsentDialog ");
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ATSDK.showGDPRConsentDialog((Activity)SDKInitHelper.this.mActivity, (ATGDPRConsentDismissListener)new ATGDPRConsentDismissListener(){

                    public void onDismiss(ATGDPRConsentDismissListener.ConsentDismissInfo consentDismissInfo) {
                        MsgTools.printMsg("showGDPRConsentDialog onDismiss: " + consentDismissInfo);
                        if (listener != null) {
                            listener.onConsentDismiss();
                        }
                    }
                });
            }
        });
    }

    @Deprecated
    public void addNetworkGDPRInfo(int networkType, String mapJson) {
    }

    public void deniedUploadDeviceInfo(String arrayString) {
        MsgTools.printMsg("deniedUploadDeviceInfo: " + arrayString);
        if (!TextUtils.isEmpty((CharSequence)arrayString)) {
            try {
                JSONArray jsonArray = new JSONArray(arrayString);
                int length = jsonArray.length();
                if (length > 0) {
                    String[] infos = new String[length];
                    for (int i = 0; i < length; ++i) {
                        infos[i] = jsonArray.getString(i);
                    }
                    ATSDK.deniedUploadDeviceInfo((String[])infos);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void setExcludeBundleIdArray(String arrayString) {
        MsgTools.printMsg("setExcludeBundleIdArray: " + arrayString);
        if (!TextUtils.isEmpty((CharSequence)arrayString)) {
            try {
                JSONArray jsonArray = new JSONArray(arrayString);
                int length = jsonArray.length();
                if (length > 0) {
                    ArrayList<String> list = new ArrayList<String>(length);
                    for (int i = 0; i < length; ++i) {
                        list.add(jsonArray.getString(i));
                    }
                    ATSDK.setExcludePackageList(list);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void setExcludeAdSourceIdArrayForPlacementID(String placementID, String arrayString) {
        MsgTools.printMsg("setExcludeAdSourceIdArrayForPlacementID: " + placementID + ", " + arrayString);
        if (!TextUtils.isEmpty((CharSequence)arrayString)) {
            try {
                JSONArray jsonArray = new JSONArray(arrayString);
                int length = jsonArray.length();
                if (length > 0) {
                    ArrayList<String> list = new ArrayList<String>(length);
                    for (int i = 0; i < length; ++i) {
                        list.add(jsonArray.getString(i));
                    }
                    ATSDK.setFilterAdSourceIdList((String)placementID, list);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public void setSDKArea(int area) {
        MsgTools.printMsg("\uff08Deprecated\uff09setSDKArea: " + area);
    }

    public void getArea(final AreaCallbackListener listener) {
        MsgTools.printMsg("getArea");
        ATSDK.getArea((ATAreaCallback)new ATAreaCallback(){

            public void onResultCallback(String s) {
                MsgTools.printMsg("getArea:" + s);
                if (listener != null) {
                    listener.onResultCallback(s);
                }
            }

            public void onErrorCallback(String s) {
                MsgTools.printMsg("getArea:" + s);
                if (listener != null) {
                    listener.onErrorCallback(s);
                }
            }
        });
    }

    public void setWXStatus(boolean install) {
        MsgTools.printMsg("setWXStatus: " + install);
        ATSDK.setWXStatus((boolean)install);
    }

    public void setLocation(double longitude, double latitude) {
        MsgTools.printMsg("setLocation: " + longitude + ", " + latitude);
        Location location = new Location("");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        ATSDK.setLocation((Location)location);
    }
}

