/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.interstitial;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdSourceStatusListener;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.ATEventInterface;
import com.anythink.core.api.ATSDK;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.interstitial.api.ATInterstitialListener;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.download.DownloadHelper;
import com.anythink.unitybridge.interstitial.InterstitialListener;
import com.anythink.unitybridge.utils.Const;
import com.anythink.unitybridge.utils.TaskManager;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class InterstitialHelper {
    public static final String TAG = "AT_android_unity3d";
    InterstitialListener mListener;
    Activity mActivity;
    ATInterstitial mInterstitialAd;
    String mPlacementId;
    boolean isReady = false;

    public InterstitialHelper(InterstitialListener listener) {
        MsgTools.printMsg("InterstitialHelper: " + this);
        if (listener == null) {
            Log.e((String)TAG, (String)"Listener == null ..");
        }
        this.mListener = listener;
        this.mActivity = UnityPluginUtils.getActivity("InterstitialHelper");
    }

    public void initInterstitial(String placementId) {
        MsgTools.printMsg("initInterstitial 1: " + placementId);
        this.mInterstitialAd = new ATInterstitial((Context)this.mActivity, placementId);
        this.mPlacementId = placementId;
        MsgTools.printMsg("initInterstitial 2: " + placementId);
        this.mInterstitialAd.setAdListener(new ATInterstitialListener(){

            public void onInterstitialAdLoaded() {
                MsgTools.printMsg("onInterstitialAdLoaded: " + InterstitialHelper.this.mPlacementId);
                InterstitialHelper.this.isReady = true;
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdLoaded(InterstitialHelper.this.mPlacementId);
                            }
                        }
                    }
                });
            }

            public void onInterstitialAdLoadFail(final AdError adError) {
                MsgTools.printMsg("onInterstitialAdLoadFail: " + InterstitialHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdLoadFail(InterstitialHelper.this.mPlacementId, adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onInterstitialAdClicked(final ATAdInfo adInfo) {
                MsgTools.printMsg("onInterstitialAdClicked: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdClicked(InterstitialHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onInterstitialAdShow(final ATAdInfo adInfo) {
                MsgTools.printMsg("onInterstitialAdShow: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdShow(InterstitialHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onInterstitialAdClose(final ATAdInfo adInfo) {
                MsgTools.printMsg("onInterstitialAdClose: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdClose(InterstitialHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onInterstitialAdVideoStart(final ATAdInfo adInfo) {
                MsgTools.printMsg("onInterstitialAdVideoStart: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdVideoStart(InterstitialHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onInterstitialAdVideoEnd(final ATAdInfo adInfo) {
                MsgTools.printMsg("onInterstitialAdVideoEnd: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdVideoEnd(InterstitialHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onInterstitialAdVideoError(final AdError adError) {
                MsgTools.printMsg("onInterstitialAdVideoError: " + InterstitialHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onInterstitialAdVideoError(InterstitialHelper.this.mPlacementId, adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }
        });
        this.mInterstitialAd.setAdSourceStatusListener(new ATAdSourceStatusListener(){

            public void onAdSourceBiddingAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingAttempt: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onAdSourceBiddingAttempt(InterstitialHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingFilled: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onAdSourceBiddingFilled(InterstitialHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceBiddingFail: " + InterstitialHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onAdSourceBiddingFail(InterstitialHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onAdSourceAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceAttemp: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onAdSourceAttempt(InterstitialHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceLoadFilled: " + InterstitialHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onAdSourceLoadFilled(InterstitialHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceLoadFail: " + InterstitialHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialHelper.this.mListener != null) {
                            InterstitialHelper interstitialHelper = InterstitialHelper.this;
                            synchronized (interstitialHelper) {
                                InterstitialHelper.this.mListener.onAdSourceLoadFail(InterstitialHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }
        });
        MsgTools.printMsg("initInterstitial 3: " + placementId);
        try {
            if (ATSDK.isCnSDK()) {
                this.mInterstitialAd.setAdDownloadListener((ATEventInterface)DownloadHelper.getDownloadListener(this.mPlacementId));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadInterstitialAd(String jsonMap) {
        MsgTools.printMsg("loadInterstitialAd: " + this.mPlacementId + ", jsonMap: " + jsonMap);
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            HashMap<String, Object> localExtra = new HashMap<String, Object>();
            try {
                JSONObject jsonObject = new JSONObject(jsonMap);
                try {
                    String useRewardedVideoAsInterstitial = (String)jsonObject.get("UseRewardedVideoAsInterstitial");
                    if (useRewardedVideoAsInterstitial != null && TextUtils.equals((CharSequence)"1", (CharSequence)useRewardedVideoAsInterstitial)) {
                        localExtra.put("is_use_rewarded_video_as_interstitial", true);
                    }
                }
                catch (Throwable useRewardedVideoAsInterstitial) {
                    // empty catch block
                }
                try {
                    String inter_ad_size = (String)jsonObject.get("interstitial_ad_size");
                    if (!TextUtils.isEmpty((CharSequence)inter_ad_size)) {
                        String[] sizes = inter_ad_size.split("x");
                        MsgTools.printMsg("loadInterstitialAd, inter_ad_size" + inter_ad_size);
                        localExtra.put("key_width", sizes[0]);
                        localExtra.put("key_height", sizes[1]);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Const.fillMapFromJsonObject(localExtra, jsonObject);
                if (this.mInterstitialAd != null) {
                    this.mInterstitialAd.setLocalExtra(localExtra);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (InterstitialHelper.this.mInterstitialAd != null) {
                    InterstitialHelper.this.mInterstitialAd.load();
                } else {
                    Log.e((String)InterstitialHelper.TAG, (String)("loadInterstitialAd error, you must call initInterstitial first " + this));
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (InterstitialHelper.this.mListener != null) {
                                InterstitialHelper interstitialHelper = InterstitialHelper.this;
                                synchronized (interstitialHelper) {
                                    InterstitialHelper.this.mListener.onInterstitialAdLoadFail(InterstitialHelper.this.mPlacementId, "-1", "you must call initInterstitial first ..");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void showInterstitialAd(final String jsonMap) {
        MsgTools.printMsg("showInterstitial: " + this + ", jsonMap: " + jsonMap);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (InterstitialHelper.this.mInterstitialAd != null) {
                    InterstitialHelper.this.isReady = false;
                    String scenario = "";
                    if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
                        try {
                            JSONObject _jsonObject = new JSONObject(jsonMap);
                            if (_jsonObject.has("Scenario")) {
                                scenario = _jsonObject.optString("Scenario");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    MsgTools.printMsg("showInterstitialAd: " + this + ", scenario: " + scenario);
                    if (!TextUtils.isEmpty((CharSequence)scenario)) {
                        InterstitialHelper.this.mInterstitialAd.show(InterstitialHelper.this.mActivity, scenario);
                    } else {
                        InterstitialHelper.this.mInterstitialAd.show(InterstitialHelper.this.mActivity);
                    }
                } else {
                    Log.e((String)InterstitialHelper.TAG, (String)("showInterstitial error, you must call initInterstitial first " + this));
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (InterstitialHelper.this.mListener != null) {
                                InterstitialHelper interstitialHelper = InterstitialHelper.this;
                                synchronized (interstitialHelper) {
                                    InterstitialHelper.this.mListener.onInterstitialAdLoadFail(InterstitialHelper.this.mPlacementId, "-1", "you must call initInterstitial first ..");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public boolean isAdReady() {
        MsgTools.printMsg("isAdReady start: " + this.mPlacementId);
        try {
            if (this.mInterstitialAd != null) {
                boolean isAdReady = this.mInterstitialAd.isAdReady();
                MsgTools.printMsg("isAdReady: " + isAdReady);
                return isAdReady;
            }
            Log.e((String)TAG, (String)"isAdReady error, you must call initInterstitial first ");
            MsgTools.printMsg("isAdReady end: " + this.mPlacementId);
        }
        catch (Exception e) {
            MsgTools.printMsg("isAdReady Exception: " + e.getMessage());
            return this.isReady;
        }
        catch (Throwable e) {
            MsgTools.printMsg("isAdReady Throwable: " + e.getMessage());
            return this.isReady;
        }
        return this.isReady;
    }

    public String checkAdStatus() {
        MsgTools.printMsg("checkAdStatus: " + this.mPlacementId);
        if (this.mInterstitialAd != null) {
            ATAdStatusInfo atAdStatusInfo = this.mInterstitialAd.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                try {
                    if (atTopAdInfo != null) {
                        jsonObject.put("adInfo", (Object)new JSONObject(atTopAdInfo.toString()));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                MsgTools.printMsg("checkAdStatus: result = " + jsonObject);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String getValidAdCaches() {
        MsgTools.printMsg("getValidAdCaches:" + this.mPlacementId);
        if (this.mInterstitialAd != null) {
            JSONArray jsonArray = new JSONArray();
            List vaildAds = this.mInterstitialAd.checkValidAdCaches();
            if (vaildAds == null) {
                return "";
            }
            int size = vaildAds.size();
            for (int i = 0; i < size; ++i) {
                try {
                    jsonArray.put((Object)new JSONObject(((ATAdInfo)vaildAds.get(i)).toString()));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return jsonArray.toString();
        }
        return "";
    }

    public void entryAdScenario(final String scenarioId) {
        MsgTools.printMsg("entryAdScenario start: " + this.mPlacementId + ", scenarioId: " + scenarioId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)InterstitialHelper.this.mPlacementId)) {
                    ATInterstitial.entryAdScenario((String)InterstitialHelper.this.mPlacementId, (String)scenarioId);
                } else {
                    MsgTools.printMsg("entryAdScenario error, you must call initInterstitial first " + InterstitialHelper.this.mPlacementId);
                }
            }
        });
    }
}

