/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.interstitial;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitialAutoAd;
import com.anythink.interstitial.api.ATInterstitialAutoEventListener;
import com.anythink.interstitial.api.ATInterstitialAutoLoadListener;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.interstitial.InterstitialListener;
import com.anythink.unitybridge.utils.Const;
import com.anythink.unitybridge.utils.TaskManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class InterstitialAutoAdHelper {
    public final String LOG_PRE = "interstitial_autoad ";
    InterstitialListener mListener;
    Activity mActivity;
    List<String> mAddedPlacementIds;

    public InterstitialAutoAdHelper(InterstitialListener pListener) {
        MsgTools.printMsg("interstitial_autoad ", "InterstitialAutoAdHelper: " + this);
        if (pListener == null) {
            MsgTools.printMsg("interstitial_autoad ", "Listener == null: ");
        }
        this.mListener = pListener;
        this.mActivity = UnityPluginUtils.getActivity("InterstitialAutoAdHelper");
        this.mAddedPlacementIds = new ArrayList<String>();
        ATInterstitialAutoAd.init((Context)this.mActivity, null, (ATInterstitialAutoLoadListener)new ATInterstitialAutoLoadListener(){

            public void onInterstitialAutoLoaded(final String placementId) {
                MsgTools.printMsg("interstitial_autoad ", "onInterstitialAutoLoaded: " + placementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialAutoAdHelper.this.mListener != null) {
                            InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                            synchronized (interstitialAutoAdHelper) {
                                InterstitialAutoAdHelper.this.mListener.onInterstitialAdLoaded(placementId);
                            }
                        }
                    }
                });
            }

            public void onInterstitialAutoLoadFail(final String placementId, final AdError adError) {
                MsgTools.printMsg("interstitial_autoad ", "onRewardVideoAutoLoadFail: " + placementId + ", " + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (InterstitialAutoAdHelper.this.mListener != null) {
                            InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                            synchronized (interstitialAutoAdHelper) {
                                InterstitialAutoAdHelper.this.mListener.onInterstitialAdLoadFail(placementId, adError.getCode(), adError.getFullErrorInfo());
                            }
                        } else {
                            MsgTools.printMsg("interstitial_autoad ", "onRewardVideoAutoLoadFail callnoback: " + adError.getFullErrorInfo());
                        }
                    }
                });
            }
        });
        MsgTools.printMsg("interstitial_autoad ", "InterstitialAutoAdHelper: init success");
    }

    public void addPlacementIds(String placementIds) {
        if (TextUtils.isEmpty((CharSequence)placementIds)) {
            MsgTools.printMsg("interstitial_autoad ", "addPlacementIds warn: not set placementIds");
            return;
        }
        try {
            MsgTools.printMsg("interstitial_autoad ", "addPlacementIds: " + placementIds);
            JSONArray jsonArray = new JSONArray(placementIds);
            final String[] placementIdArr = new String[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                placementIdArr[i] = jsonArray.getString(i);
            }
            this.mAddedPlacementIds.addAll(Arrays.asList(placementIdArr));
            UnityPluginUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ATInterstitialAutoAd.addPlacementId((String[])placementIdArr);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgTools.printMsg("interstitial_autoad ", "addPlacementIds error,please check your placementIds:\"" + placementIds + "\"");
        }
    }

    public void removePlacementIds(String placementIds) {
        if (TextUtils.isEmpty((CharSequence)placementIds)) {
            MsgTools.printMsg("interstitial_autoad ", "removePlacementIds warn: not set placementId");
            return;
        }
        try {
            JSONArray jsonArray = new JSONArray(placementIds);
            final String[] placementIdArr = new String[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                placementIdArr[i] = jsonArray.getString(i);
            }
            this.mAddedPlacementIds.removeAll(Arrays.asList(placementIdArr));
            MsgTools.printMsg("interstitial_autoad ", "removePlacementIds: " + placementIds);
            UnityPluginUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ATInterstitialAutoAd.removePlacementId((String[])placementIdArr);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgTools.printMsg("interstitial_autoad ", "removePlacementIds error,please check your placementIds:\"" + placementIds + "\"");
        }
    }

    public void show(final String placementId, String jsonMap) {
        if (this.mListener == null) {
            MsgTools.printMsg("interstitial_autoad ", "show warn:please init before show");
        }
        if (!this.mAddedPlacementIds.contains(placementId)) {
            MsgTools.printMsg("interstitial_autoad ", "show warn:please addPlacementIds first: " + placementId);
        }
        if (!ATInterstitialAutoAd.isAdReady((String)placementId)) {
            MsgTools.printMsg("interstitial_autoad ", "show fail:this placementId(" + placementId + ") is not ready to show");
            return;
        }
        String scenario = "";
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            try {
                JSONObject _jsonObject = new JSONObject(jsonMap);
                if (_jsonObject.has("Scenario")) {
                    scenario = _jsonObject.optString("Scenario");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MsgTools.printMsg("interstitial_autoad ", "show placementId:" + placementId + ", scenario:" + scenario);
        final String finalScenario = scenario;
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ATInterstitialAutoAd.show((Activity)InterstitialAutoAdHelper.this.mActivity, (String)placementId, (String)finalScenario, (ATInterstitialAutoEventListener)new ATInterstitialAutoEventListener(){

                    public void onInterstitialAdClicked(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onInterstitialAdClicked: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (InterstitialAutoAdHelper.this.mListener != null) {
                                    InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                                    synchronized (interstitialAutoAdHelper) {
                                        InterstitialAutoAdHelper.this.mListener.onInterstitialAdClicked(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onInterstitialAdShow(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onInterstitialAdShow: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (InterstitialAutoAdHelper.this.mListener != null) {
                                    InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                                    synchronized (interstitialAutoAdHelper) {
                                        InterstitialAutoAdHelper.this.mListener.onInterstitialAdShow(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onInterstitialAdClose(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onInterstitialAdClose: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (InterstitialAutoAdHelper.this.mListener != null) {
                                    InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                                    synchronized (interstitialAutoAdHelper) {
                                        InterstitialAutoAdHelper.this.mListener.onInterstitialAdClose(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onInterstitialAdVideoStart(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onInterstitialAdVideoStart: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (InterstitialAutoAdHelper.this.mListener != null) {
                                    InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                                    synchronized (interstitialAutoAdHelper) {
                                        InterstitialAutoAdHelper.this.mListener.onInterstitialAdVideoStart(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onInterstitialAdVideoEnd(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onInterstitialAdVideoEnd: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (InterstitialAutoAdHelper.this.mListener != null) {
                                    InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                                    synchronized (interstitialAutoAdHelper) {
                                        InterstitialAutoAdHelper.this.mListener.onInterstitialAdVideoEnd(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onInterstitialAdVideoError(final AdError adError) {
                        MsgTools.printMsg("onInterstitialAdVideoError: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (InterstitialAutoAdHelper.this.mListener != null) {
                                    InterstitialAutoAdHelper interstitialAutoAdHelper = InterstitialAutoAdHelper.this;
                                    synchronized (interstitialAutoAdHelper) {
                                        InterstitialAutoAdHelper.this.mListener.onInterstitialAdVideoError(placementId, adError.getCode(), adError.getFullErrorInfo());
                                    }
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public void setAdExtraData(String placementId, String jsonMap) {
        MsgTools.printMsg("interstitial_autoad ", "setAdExtraData start: " + placementId + ", jsonMap: " + jsonMap);
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            HashMap<String, Object> localExtra = new HashMap<String, Object>();
            try {
                JSONObject jsonObject = new JSONObject(jsonMap);
                try {
                    String useRewardedVideoAsInterstitial = (String)jsonObject.get("UseRewardedVideoAsInterstitial");
                    if (useRewardedVideoAsInterstitial != null && TextUtils.equals((CharSequence)"1", (CharSequence)useRewardedVideoAsInterstitial)) {
                        localExtra.put("is_use_rewarded_video_as_interstitial", true);
                    }
                }
                catch (Throwable useRewardedVideoAsInterstitial) {
                    // empty catch block
                }
                try {
                    String inter_ad_size = (String)jsonObject.get("interstitial_ad_size");
                    if (!TextUtils.isEmpty((CharSequence)inter_ad_size)) {
                        String[] sizes = inter_ad_size.split("x");
                        MsgTools.printMsg("loadInterstitialAd, inter_ad_size" + inter_ad_size);
                        localExtra.put("key_width", sizes[0]);
                        localExtra.put("key_height", sizes[1]);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Const.fillMapFromJsonObject(localExtra, jsonObject);
                ATInterstitialAutoAd.setLocalExtra((String)placementId, localExtra);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isAdReady(String placementId) {
        if (!this.mAddedPlacementIds.contains(placementId)) {
            MsgTools.printMsg("interstitial_autoad ", "isAdReady please addPlacementIds first: " + placementId);
        }
        boolean isReady = ATInterstitialAutoAd.isAdReady((String)placementId);
        MsgTools.printMsg("interstitial_autoad ", "isAdReady: " + placementId + ", " + isReady);
        return isReady;
    }

    public String checkAdStatus(String placementId) {
        if (!this.mAddedPlacementIds.contains(placementId)) {
            MsgTools.printMsg("interstitial_autoad ", "checkAdStatus please addPlacementIds first: " + placementId);
        }
        ATAdStatusInfo atAdStatusInfo = ATInterstitialAutoAd.checkAdStatus((String)placementId);
        boolean loading = atAdStatusInfo.isLoading();
        boolean ready = atAdStatusInfo.isReady();
        ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isLoading", loading);
            jsonObject.put("isReady", ready);
            try {
                if (atTopAdInfo != null) {
                    jsonObject.put("adInfo", (Object)new JSONObject(atTopAdInfo.toString()));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            MsgTools.printMsg("checkAdStatus: result = " + jsonObject);
            return jsonObject.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getValidAdCaches(String placementId) {
        MsgTools.printMsg("interstitial_autoad ", "getValidAdCaches:" + placementId);
        JSONArray jsonArray = new JSONArray();
        List vaildAds = ATInterstitialAutoAd.checkValidAdCaches((String)placementId);
        if (vaildAds == null) {
            return "";
        }
        int size = vaildAds.size();
        for (int i = 0; i < size; ++i) {
            try {
                jsonArray.put((Object)new JSONObject(((ATAdInfo)vaildAds.get(i)).toString()));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return jsonArray.toString();
    }

    public void entryAdScenario(String placementId, String scenario) {
        MsgTools.printMsg("interstitial_autoad ", "entryAdScenario... " + placementId + "," + scenario);
        ATInterstitialAutoAd.entryAdScenario((String)placementId, (String)scenario);
    }
}

