/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.notification.local.workers;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.youloft.R;
import com.youloft.notification.local.entities.LocalNotification;
import com.youloft.notification.local.util.LocalNotificationHelper;

public class TriggerNotificationWorker
extends Worker {
    public static final String TAG = "TriggerNotificationWorker";
    private NotificationManager notificationManager;

    public TriggerNotificationWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        try {
            for (String tag : this.getTags()) {
                long newTriggerDelay;
                long missedTime;
                LocalNotification notification = LocalNotification.fromTag(tag);
                if (notification == null) continue;
                if (System.currentTimeMillis() >= notification.triggerTime) {
                    this.triggerNotification(notification);
                }
                if (notification.repeatDelay <= 0L) continue;
                for (missedTime = System.currentTimeMillis() - notification.triggerTime; missedTime > notification.repeatDelay; missedTime -= notification.repeatDelay) {
                }
                notification.triggerDelay = newTriggerDelay = notification.repeatDelay - missedTime;
                notification.triggerTime = System.currentTimeMillis() + newTriggerDelay;
                LocalNotificationHelper.scheduleNotificationJob(notification);
            }
            return ListenableWorker.Result.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ListenableWorker.Result.failure();
        }
    }

    private void triggerNotification(LocalNotification notification) {
        this.createNotificationChannel(notification.channelId);
        this.notificationManager.notify(notification.notificationId, TriggerNotificationWorker.buildNotification(this.getApplicationContext(), notification));
    }

    private boolean isChannelCreated(String channelId) {
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        NotificationChannel channel = this.notificationManager.getNotificationChannel(channelId);
        return channel != null;
    }

    private void createNotificationChannel(String channelId) {
        if (Build.VERSION.SDK_INT >= 26) {
            boolean isChannelCreated = this.isChannelCreated(channelId);
            if (this.notificationManager != null && !isChannelCreated) {
                int importance = 3;
                NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelId, importance);
                this.notificationManager.createNotificationChannel(notificationChannel);
            }
        }
    }

    private static Notification buildNotification(Context context, LocalNotification notification) {
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, notification.channelId);
        if (!TextUtils.isEmpty((CharSequence)notification.textTitle)) {
            mBuilder.setContentTitle((CharSequence)notification.textTitle);
        } else {
            mBuilder.setContentTitle(TriggerNotificationWorker.getDefaultAppName(context));
        }
        mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notification.textContent));
        mBuilder.setContentText((CharSequence)notification.textContent);
        mBuilder.setPriority(0);
        if (notification.smallIcon != -1) {
            mBuilder.setSmallIcon(notification.smallIcon);
        } else {
            mBuilder.setSmallIcon(R.drawable.inh_ic_stat_default);
        }
        if (notification.largeIcon != -1) {
            mBuilder.setLargeIcon(((BitmapDrawable)context.getResources().getDrawable(notification.largeIcon)).getBitmap());
        } else {
            PackageInfo packageInfo = null;
            try {
                packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 1);
                mBuilder.setLargeIcon(TriggerNotificationWorker.getIconBitmap(context, packageInfo.applicationInfo.icon));
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        Uri soundUri = RingtoneManager.getDefaultUri((int)2);
        if (soundUri != null) {
            mBuilder.setSound(soundUri);
        }
        mBuilder.setDefaults(-1);
        mBuilder.setAutoCancel(true);
        Intent mainIntent = null;
        boolean activityReserved = false;
        if (!TextUtils.isEmpty((CharSequence)notification.activity)) {
            try {
                Class<?> c = Class.forName(notification.activity);
                mainIntent = new Intent(context, c);
                activityReserved = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!activityReserved) {
            mainIntent = TriggerNotificationWorker.getLauncherActivityIntent(context);
        }
        if (!TextUtils.isEmpty((CharSequence)notification.data)) {
            mainIntent.putExtra("LNH_DATA", notification.data);
        }
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)mainIntent, (int)0x8000000);
        mBuilder.setContentIntent(contentIntent);
        Notification androidNotification = mBuilder.build();
        androidNotification.flags |= 0x10;
        return androidNotification;
    }

    public static Intent getLauncherActivityIntent(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = Build.VERSION.SDK_INT >= 3 ? packageManager.getLaunchIntentForPackage(context.getPackageName()) : new Intent(context, null);
        return intent;
    }

    private static CharSequence getDefaultAppName(Context context) {
        if (Build.VERSION.SDK_INT >= 4) {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        }
        return "";
    }

    private static Bitmap getIconBitmap(Context context, int iconId) {
        try {
            Drawable icon = ContextCompat.getDrawable((Context)context, (int)iconId);
            if (icon == null) {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 26 && icon instanceof AdaptiveIconDrawable) {
                Bitmap bitmap = Bitmap.createBitmap((int)icon.getIntrinsicWidth(), (int)icon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                icon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                icon.draw(canvas);
                return bitmap;
            }
            return ((BitmapDrawable)icon).getBitmap();
        }
        catch (Exception e) {
            return null;
        }
    }
}

