/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.google;

import android.content.Intent;
import android.os.AsyncTask;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.SnapshotsClient;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.youloft.core.utils.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class SnapshotCoordinator {
    private static final SnapshotCoordinator theInstance = new SnapshotCoordinator();
    private static final String TAG = "SnapshotCoordinator";
    private final Map<String, CountDownLatch> opened = new HashMap<String, CountDownLatch>();
    private final Set<String> closing = new HashSet<String>();

    public static SnapshotCoordinator getInstance() {
        return theInstance;
    }

    private SnapshotCoordinator() {
    }

    public synchronized boolean isAlreadyOpen(String filename) {
        return this.opened.containsKey(filename);
    }

    public synchronized boolean isAlreadyClosing(String filename) {
        return this.closing.contains(filename);
    }

    private synchronized void setIsClosing(String filename) {
        this.closing.add(filename);
    }

    private synchronized void setClosed(String filename) {
        this.closing.remove(filename);
        CountDownLatch l = this.opened.remove(filename);
        if (l != null) {
            l.countDown();
        }
    }

    private synchronized void setIsOpening(String filename) {
        this.opened.put(filename, new CountDownLatch(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Result> waitForClosed(String filename) {
        CountDownLatch latch;
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        SnapshotCoordinator snapshotCoordinator = this;
        synchronized (snapshotCoordinator) {
            latch = this.opened.get(filename);
        }
        if (latch == null) {
            taskCompletionSource.setResult(null);
            return taskCompletionSource.getTask();
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... voids) {
                Result result = new CountDownTask(latch).await();
                taskCompletionSource.setResult((Object)result);
                return null;
            }
        }.execute((Object[])new Void[0]);
        return taskCompletionSource.getTask();
    }

    public Task<Integer> getMaxDataSize(SnapshotsClient snapshotsClient) {
        return snapshotsClient.getMaxDataSize();
    }

    public Task<Integer> getMaxCoverImageSize(SnapshotsClient snapshotsClient) {
        return snapshotsClient.getMaxCoverImageSize();
    }

    public Task<Intent> getSelectSnapshotIntent(SnapshotsClient snapshotsClient, String title, boolean allowAddButton, boolean allowDelete, int maxSnapshots) {
        return snapshotsClient.getSelectSnapshotIntent(title, allowAddButton, allowDelete, maxSnapshots);
    }

    public Task<AnnotatedData<SnapshotMetadataBuffer>> load(SnapshotsClient snapshotsClient, boolean forceReload) {
        return snapshotsClient.load(forceReload);
    }

    public Task<SnapshotsClient.DataOrConflict<Snapshot>> resolveConflict(SnapshotsClient snapshotsClient, String conflictId, String snapshotId, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) {
        throw new IllegalStateException("resolving conflicts with ids is not supported.");
    }

    public Task<Void> discardAndClose(final SnapshotsClient snapshotsClient, final Snapshot snapshot) {
        String filename = snapshot.getMetadata().getUniqueName();
        return this.setIsClosingTask(filename).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.discardAndClose(snapshot).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                    public void onComplete(@NonNull Task<Void> task) {
                        LogUtils.d(SnapshotCoordinator.TAG, "Closed " + snapshot.getMetadata().getUniqueName());
                        SnapshotCoordinator.this.setClosed(snapshot.getMetadata().getUniqueName());
                    }
                });
            }
        });
    }

    @NonNull
    private OnCompleteListener<SnapshotsClient.DataOrConflict<Snapshot>> createOpenListener(final String filename) {
        return new OnCompleteListener<SnapshotsClient.DataOrConflict<Snapshot>>(){

            public void onComplete(@NonNull Task<SnapshotsClient.DataOrConflict<Snapshot>> task) {
                if (!task.isSuccessful()) {
                    Exception e = task.getException();
                    LogUtils.e(SnapshotCoordinator.TAG, "Open was not a success for filename " + filename, e);
                    SnapshotCoordinator.this.setClosed(filename);
                } else {
                    SnapshotsClient.DataOrConflict result = (SnapshotsClient.DataOrConflict)task.getResult();
                    if (result.isConflict()) {
                        LogUtils.d(SnapshotCoordinator.TAG, "Open successful: " + filename + ", but with a conflict");
                    } else {
                        LogUtils.d(SnapshotCoordinator.TAG, "Open successful: " + filename);
                    }
                }
            }
        };
    }

    @NonNull
    private Task<Void> setIsOpeningTask(String filename) {
        TaskCompletionSource source = new TaskCompletionSource();
        if (this.isAlreadyOpen(filename)) {
            source.setException((Exception)new IllegalStateException(filename + " is already open!"));
        } else if (this.isAlreadyClosing(filename)) {
            source.setException((Exception)new IllegalStateException(filename + " is current closing!"));
        } else {
            this.setIsOpening(filename);
            source.setResult(null);
        }
        return source.getTask();
    }

    @NonNull
    private Task<Void> setIsClosingTask(String filename) {
        TaskCompletionSource source = new TaskCompletionSource();
        if (!this.isAlreadyOpen(filename)) {
            source.setException((Exception)new IllegalStateException(filename + " is already closed!"));
        } else if (this.isAlreadyClosing(filename)) {
            source.setException((Exception)new IllegalStateException(filename + " is current closing!"));
        } else {
            this.setIsClosing(filename);
            source.setResult(null);
        }
        return source.getTask();
    }

    public Task<SnapshotsClient.DataOrConflict<Snapshot>> open(final SnapshotsClient snapshotsClient, final String filename, final boolean createIfNotFound) {
        return this.setIsOpeningTask(filename).continueWithTask((Continuation)new Continuation<Void, Task<SnapshotsClient.DataOrConflict<Snapshot>>>(){

            public Task<SnapshotsClient.DataOrConflict<Snapshot>> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.open(filename, createIfNotFound).addOnCompleteListener(SnapshotCoordinator.this.createOpenListener(filename));
            }
        });
    }

    public Task<SnapshotsClient.DataOrConflict<Snapshot>> open(final SnapshotsClient snapshotsClient, final String filename, final boolean createIfNotFound, final int conflictPolicy) {
        return this.setIsOpeningTask(filename).continueWithTask((Continuation)new Continuation<Void, Task<SnapshotsClient.DataOrConflict<Snapshot>>>(){

            public Task<SnapshotsClient.DataOrConflict<Snapshot>> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.open(filename, createIfNotFound, conflictPolicy).addOnCompleteListener(SnapshotCoordinator.this.createOpenListener(filename));
            }
        });
    }

    public Task<SnapshotsClient.DataOrConflict<Snapshot>> open(final SnapshotsClient snapshotsClient, final SnapshotMetadata snapshotMetadata) {
        final String filename = snapshotMetadata.getUniqueName();
        return this.setIsOpeningTask(filename).continueWithTask((Continuation)new Continuation<Void, Task<SnapshotsClient.DataOrConflict<Snapshot>>>(){

            public Task<SnapshotsClient.DataOrConflict<Snapshot>> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.open(snapshotMetadata).addOnCompleteListener(SnapshotCoordinator.this.createOpenListener(filename));
            }
        });
    }

    public Task<SnapshotsClient.DataOrConflict<Snapshot>> open(final SnapshotsClient snapshotsClient, final SnapshotMetadata snapshotMetadata, final int conflictPolicy) {
        final String filename = snapshotMetadata.getUniqueName();
        return this.setIsOpeningTask(filename).continueWithTask((Continuation)new Continuation<Void, Task<SnapshotsClient.DataOrConflict<Snapshot>>>(){

            public Task<SnapshotsClient.DataOrConflict<Snapshot>> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.open(snapshotMetadata, conflictPolicy).addOnCompleteListener(SnapshotCoordinator.this.createOpenListener(filename));
            }
        });
    }

    public Task<SnapshotMetadata> commitAndClose(final SnapshotsClient snapshotsClient, final Snapshot snapshot, final SnapshotMetadataChange snapshotMetadataChange) {
        final String filename = snapshot.getMetadata().getUniqueName();
        return this.setIsClosingTask(filename).continueWithTask((Continuation)new Continuation<Void, Task<SnapshotMetadata>>(){

            public Task<SnapshotMetadata> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.commitAndClose(snapshot, snapshotMetadataChange).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<SnapshotMetadata>(){

                    public void onComplete(@NonNull Task<SnapshotMetadata> task) {
                        LogUtils.d(SnapshotCoordinator.TAG, "CommitAndClose complete, closing " + filename);
                        SnapshotCoordinator.this.setClosed(filename);
                    }
                });
            }
        });
    }

    public Task<String> delete(final SnapshotsClient snapshotsClient, final SnapshotMetadata snapshotMetadata) {
        final String filename = snapshotMetadata.getUniqueName();
        TaskCompletionSource source = new TaskCompletionSource();
        if (this.isAlreadyOpen(filename)) {
            source.setException((Exception)new IllegalStateException(filename + " is still open!"));
        } else if (this.isAlreadyClosing(filename)) {
            source.setException((Exception)new IllegalStateException(filename + " is current closing!"));
        } else {
            this.setIsClosing(filename);
            source.setResult(null);
        }
        return source.getTask().continueWithTask((Continuation)new Continuation<Void, Task<String>>(){

            public Task<String> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.delete(snapshotMetadata).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                    public void onComplete(@NonNull Task<String> task) {
                        SnapshotCoordinator.this.setClosed(filename);
                    }
                });
            }
        });
    }

    public Task<SnapshotsClient.DataOrConflict<Snapshot>> resolveConflict(final SnapshotsClient snapshotsClient, final String conflictId, final Snapshot snapshot) {
        final String filename = snapshot.getMetadata().getUniqueName();
        return this.setIsOpeningTask(filename).continueWithTask((Continuation)new Continuation<Void, Task<SnapshotsClient.DataOrConflict<Snapshot>>>(){

            public Task<SnapshotsClient.DataOrConflict<Snapshot>> then(@NonNull Task<Void> task) throws Exception {
                return snapshotsClient.resolveConflict(conflictId, snapshot).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<SnapshotsClient.DataOrConflict<Snapshot>>(){

                    public void onComplete(@NonNull Task<SnapshotsClient.DataOrConflict<Snapshot>> task) {
                        if (!task.isSuccessful()) {
                            SnapshotCoordinator.this.setClosed(filename);
                        }
                    }
                });
            }
        });
    }

    private class CountDownTask {
        private final CountDownLatch latch;
        private boolean canceled;
        private final Status Success = new Status(0);
        private final Status Canceled = new Status(16);

        public CountDownTask(CountDownLatch latch) {
            this.latch = latch;
            this.canceled = false;
        }

        @NonNull
        public Result await() {
            if (!this.canceled && this.latch != null) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    return new Result(){

                        public Status getStatus() {
                            return CountDownTask.this.Canceled;
                        }
                    };
                }
            }
            return new Result(){

                public Status getStatus() {
                    return CountDownTask.this.canceled ? CountDownTask.this.Canceled : CountDownTask.this.Success;
                }
            };
        }
    }
}

