/*
 * Decompiled with CFR 0.152.
 */
package com.code.advert;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.alibaba.fastjson.JSONObject;
import com.appsflyer.adrevenue.AppsFlyerAdRevenue;
import com.appsflyer.adrevenue.adnetworks.AppsFlyerAdNetworkEventType;
import com.appsflyer.adrevenue.adnetworks.generic.MediationNetwork;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.youloft.api.ApiManager;
import com.youloft.core.UnityPlayerBridge;
import com.youloft.core.utils.LogUtils;
import com.youloft.statistics.StatisticsManager;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;

public class AppOpenManager
implements LifecycleObserver,
Application.ActivityLifecycleCallbacks {
    private static final String LOG_TAG = "AppOpenManager";
    private static String AD_UNIT_ID = "";
    private AppOpenAd appOpenAd = null;
    private AppOpenAd.AppOpenAdLoadCallback loadCallback;
    private final Application myApplication;
    private Activity currentActivity;
    private static boolean isShowingAd = false;
    private long loadTime = 0L;
    private final int orientation;

    public AppOpenManager(Application application) {
        this.myApplication = application;
        this.myApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
        Configuration config = application.getResources().getConfiguration();
        this.orientation = config.orientation;
    }

    public void fetchAd(String id) {
        AD_UNIT_ID = id;
        if (this.isAdAvailable()) {
            return;
        }
        this.loadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void onAdLoaded(AppOpenAd ad) {
                AppOpenManager.this.appOpenAd = ad;
                AppOpenManager.this.loadTime = new Date().getTime();
                UnityPlayerBridge.sendMsg((String)"PottingMobile", (String)"appOpenAdDidLoad", (String)AD_UNIT_ID);
                LogUtils.d((String)"appOpenAdDidLoad");
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                LogUtils.e((String)(loadAdError.getCode() + ""));
                LogUtils.e((String)loadAdError.getMessage());
                UnityPlayerBridge.sendMsg((String)"PottingMobile", (String)"appOpenAdDidFailToLoad", (String)loadAdError.getMessage());
            }
        };
        AdRequest request = this.getAdRequest();
        AppOpenAd.load((Context)this.myApplication, (String)AD_UNIT_ID, (AdRequest)request, (int)this.orientation, (AppOpenAd.AppOpenAdLoadCallback)this.loadCallback);
    }

    public void showAdIfAvailable() {
        if (!isShowingAd && this.isAdAvailable()) {
            Log.d((String)LOG_TAG, (String)"Will show ad.");
            FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    AppOpenManager.this.appOpenAd = null;
                    isShowingAd = false;
                    AppOpenManager.this.fetchAd(AD_UNIT_ID);
                    UnityPlayerBridge.sendMsg((String)"PottingMobile", (String)"appOpenAdDidDisappear", (String)AD_UNIT_ID);
                }

                public void onAdFailedToShowFullScreenContent(AdError adError) {
                }

                public void onAdShowedFullScreenContent() {
                    isShowingAd = true;
                    UnityPlayerBridge.sendMsg((String)"PottingMobile", (String)"appOpenAdDidAppear", (String)AD_UNIT_ID);
                }
            };
            this.appOpenAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    Bundle bundle = new Bundle();
                    bundle.putDouble("value", (double)adValue.getValueMicros() / 1000000.0);
                    bundle.putString("currency", "USD");
                    bundle.putInt("precisionType", adValue.getPrecisionType());
                    bundle.putString("adNetwork", AppOpenManager.this.appOpenAd.getResponseInfo().getMediationAdapterClassName());
                    StatisticsManager.fireBaseCustomEvent((String)"Ad_Impression_Revenue", (Bundle)bundle);
                    String currencyCode = adValue.getCurrencyCode();
                    int precision = adValue.getPrecisionType();
                    String adUnitId = AppOpenManager.this.appOpenAd.getAdUnitId();
                    AdapterResponseInfo loadedAdapterResponseInfo = AppOpenManager.this.appOpenAd.getResponseInfo().getLoadedAdapterResponseInfo();
                    String adSourceName = loadedAdapterResponseInfo.getAdSourceName();
                    Bundle extras = AppOpenManager.this.appOpenAd.getResponseInfo().getResponseExtras();
                    String mediationGroupName = extras.getString("mediation_group_name");
                    HashMap<String, String> customParams = new HashMap<String, String>();
                    customParams.put("country", "US");
                    customParams.put("event_revenue_currency", currencyCode);
                    customParams.put("ad_unit", adUnitId);
                    customParams.put("ad_type", AppsFlyerAdNetworkEventType.APP_OPEN.toString());
                    customParams.put("placement", "place");
                    customParams.put("ecpm_payload", "encrypt");
                    customParams.put("precision", String.valueOf(precision));
                    AppsFlyerAdRevenue.logAdRevenue((String)adSourceName, (MediationNetwork)MediationNetwork.googleadmob, (Currency)Currency.getInstance(currencyCode), (Double)((double)adValue.getValueMicros() / 1000000.0), customParams);
                    JSONObject labels = new JSONObject();
                    labels.put("adtype", (Object)3);
                    labels.put("revenue", (Object)((double)adValue.getValueMicros() / 1000000.0));
                    ApiManager.dataReport((String)"adshow", (String)AppOpenManager.this.appOpenAd.getAdUnitId(), (String)"\u5e7f\u544a\u5c55\u73b0", (JSONObject)labels);
                }
            });
            this.appOpenAd.setFullScreenContentCallback(fullScreenContentCallback);
            this.appOpenAd.show(this.currentActivity);
        } else {
            Log.d((String)LOG_TAG, (String)"Can not show ad.");
            this.fetchAd(AD_UNIT_ID);
        }
    }

    private AdRequest getAdRequest() {
        return new AdRequest.Builder().build();
    }

    private boolean wasLoadTimeLessThanNHoursAgo(long numHours) {
        long numMilliSecondsPerHour;
        long dateDifference = new Date().getTime() - this.loadTime;
        return dateDifference < (numMilliSecondsPerHour = 3600000L) * numHours;
    }

    public boolean isAdAvailable() {
        return this.appOpenAd != null && this.wasLoadTimeLessThanNHoursAgo(4L);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        this.currentActivity = activity;
    }

    public void onActivityResumed(Activity activity) {
        this.currentActivity = activity;
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.currentActivity = null;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        Log.d((String)LOG_TAG, (String)"onStart");
    }
}

