/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import android.content.SharedPreferences;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.util.Utils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

class UidManager {
    private static final String UID_PREFERENCES = "UIDPREFERENCES";
    private static final String UID_FIELD = "UID_FIELD";
    private static final int UID_CORRECT_LENTH = 32;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    UidManager() {
    }

    protected static final String getUid(Context ctx) {
        SharedPreferences sharedPrefs;
        if (Properties.UID != null && Properties.UID.length() == 32) {
            return Properties.UID;
        }
        String uid = null;
        if (ctx != null && (sharedPrefs = ctx.getSharedPreferences(UID_PREFERENCES, 0)) != null) {
            uid = Utils.decryptString(sharedPrefs.getString(UID_FIELD, null));
        }
        if (uid == null) {
            uid = UidManager.generateUid();
            UidManager.saveUid(ctx, uid);
        }
        return uid;
    }

    private static boolean saveUid(Context ctx, String uid) {
        if (uid != null && uid.length() == 32) {
            Properties.UID = uid;
            SharedPreferences sharedPrefs = ctx.getSharedPreferences(UID_PREFERENCES, 0);
            if (sharedPrefs != null) {
                return sharedPrefs.edit().putString(UID_FIELD, Utils.encryptString(uid)).commit();
            }
            return false;
        }
        return false;
    }

    private static final String generateUid() {
        try {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        catch (Throwable e) {
            e.printStackTrace();
            String s1 = Long.valueOf(new Date().getTime()).toString();
            String s2 = new Object().toString();
            long dat1 = System.nanoTime();
            String s3 = String.valueOf(dat1);
            String s4 = Integer.toString((int)(new Random(System.currentTimeMillis()).nextDouble() * 65535.0));
            String s5 = "android_id";
            String sall = s1 + s2 + s3 + s4 + s5;
            byte[] thedigest = null;
            try {
                byte[] bytesOfMessage = sall.getBytes("UTF-8");
                MessageDigest md = MessageDigest.getInstance("MD5");
                thedigest = md.digest(bytesOfMessage);
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
            catch (NoSuchAlgorithmException e3) {
                e3.printStackTrace();
            }
            return new String(UidManager.encodeHex(thedigest));
        }
    }

    private static final char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

