/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StacktraceHash {
    private static String guidRegex = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[34][0-9a-fA-F]{3}-[89ab][0-9a-fA-F]{3}-[0-9a-fA-F]{12}";
    private static String hexRegex = "0[xX][0-9a-fA-F]+";

    StacktraceHash() {
    }

    public static final HashMap<String, String> manipulateStacktrace(String packageName, String stacktrace) {
        String firstline;
        if (packageName == null || stacktrace == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String klass = null;
        String where = null;
        String library = null;
        String errorHash = null;
        String message = null;
        String[] stackArray = stacktrace.split("\n\t");
        if (stackArray.length == 1) {
            stackArray = stacktrace.split("\n");
        }
        message = StacktraceHash.removeFirstDate(stackArray[0]);
        try {
            klass = message.substring(0, message.indexOf(":"));
        }
        catch (Exception e) {
            klass = message;
        }
        message = message.replaceAll("\n", " ");
        message = message.replaceAll("Caused by:", "");
        map.put("message", message);
        map.put("klass", klass);
        if (packageName.contains(".")) {
            String[] packageParts = packageName.split("\\.");
            packageName = packageParts[0].length() > 3 ? packageParts[0] : packageParts[1];
        }
        StringBuilder stringForHash = new StringBuilder();
        for (String line : stackArray) {
            if (line.indexOf(packageName) == -1 || line.indexOf(packageName) > 20) continue;
            stringForHash.append(line);
            stringForHash.append("\n");
        }
        if (stringForHash.length() == 0) {
            for (String line : stackArray) {
                if (line.length() <= 10 || !line.trim().startsWith("at ") || line.contains("...") || line.contains(".java.") || line.substring(0, 10).contains("android") || line.contains("org.apache") || line.contains("org.acra") || line.contains("dalvik") || line.contains(".acra.")) continue;
                stringForHash.append(line);
                stringForHash.append("\n");
            }
        }
        if (stringForHash.length() == 0) {
            for (String line : stackArray) {
                if (line.length() <= 10 || !line.trim().startsWith("at ") || !line.contains(".java") && !line.contains("Unknown")) continue;
                stringForHash.append(line);
                stringForHash.append("\n");
            }
        }
        if (!(firstline = stringForHash.toString().split("\n")[0]).contains(packageName)) {
            library = firstline.split("\\.")[1];
        }
        map.put("library", library);
        where = firstline;
        where = where.contains("(") ? where.substring(where.indexOf("(") + 1, where.indexOf(")")) : "Unknown";
        map.put("where", where);
        String stringToHash = stringForHash.toString().replaceAll("@\\w+", "").replaceAll(hexRegex, "").replaceAll(guidRegex, "").replaceAll("$\\w+", "");
        if (!firstline.contains(".java:")) {
            String escapedFirstLine = firstline.replaceAll("\\d+", "");
            stringToHash = stringToHash.replace(firstline, escapedFirstLine);
        }
        errorHash = StacktraceHash.md5(stringToHash);
        map.put("errorHash", errorHash);
        return map;
    }

    public static String getMD5ForJavascriptError(String stacktrace) {
        String stringToHash = stacktrace.replaceAll("@\\w+", "").replaceAll(hexRegex, "").replaceAll(guidRegex, "").replaceAll("$\\w+", "");
        return StacktraceHash.md5(stringToHash);
    }

    private static String md5(String stringToHash) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(stringToHash.getBytes());
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            String hashtext = bigInt.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String removeFirstDate(String message) {
        if (message.contains("\n")) {
            String[] parts = message.split("\\n");
            Pattern regex = Pattern.compile("[\\d]{2}:[\\d]{2}:[\\d]{2}");
            Matcher regexMatcher = regex.matcher(message);
            if (regexMatcher.find()) {
                message = parts[1];
            }
        }
        return message;
    }
}

