/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import com.xsj.crasheye.AsyncDataSaver;
import com.xsj.crasheye.BaseExecutor;
import com.xsj.crasheye.Crasheye;
import com.xsj.crasheye.CrasheyeFileFilter;
import com.xsj.crasheye.CrasheyeUrls;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.NetSenderResponse;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.http.HttpResponse;
import com.xsj.crasheye.http.HttpStack;
import com.xsj.crasheye.http.MultipartBody;
import com.xsj.crasheye.http.impl.HurlStack;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.util.SignedInfoUtils;
import com.xsj.crasheye.util.TaskManager;
import com.xsj.crasheye.util.Utils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class NetSender
extends BaseExecutor {
    private static HttpStack httpClient = new HurlStack();

    public synchronized void send(final String url, final String data, final boolean saveOnFail) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                NetSender.this.sendBlocking(url, data, saveOnFail);
            }
        };
        TaskManager.getInstance().postImmediately(t);
    }

    public void HandleExceptionalResponse(NetSenderResponse mNetSenderResponse, String ResponseBody) {
        mNetSenderResponse.setException(new Exception(ResponseBody));
        if (Crasheye.crasheyeCallback != null) {
            Crasheye.crasheyeCallback.netSenderResponse(mNetSenderResponse);
        }
    }

    public synchronized NetSenderResponse sendBlocking(String url, String data, boolean saveOnFail) {
        NetSenderResponse mNetSenderResponse = new NetSenderResponse(url, data);
        if (data == null) {
            mNetSenderResponse.setException(new IllegalArgumentException("null data!"));
            if (Crasheye.crasheyeCallback != null) {
                Crasheye.crasheyeCallback.netSenderResponse(mNetSenderResponse);
            }
            Logger.logInfo(mNetSenderResponse.toString());
            return mNetSenderResponse;
        }
        String sendData = Properties.actionTypeRegx.matcher(data).replaceAll("");
        String file = null;
        boolean needSplit = "ndkerror".equals(Properties.findActionType(data).toString()) && Properties.domainConfig.equals("internal_oversea");
        boolean fileRemoved = false;
        if (needSplit) {
            try {
                JSONObject crashjo;
                JSONObject jo = new JSONObject(sendData);
                if (jo.has("crash") && (crashjo = jo.getJSONObject("crash")).has("file")) {
                    file = crashjo.getString("file");
                    crashjo.put("file", JSONObject.NULL);
                    sendData = jo.toString();
                    fileRemoved = true;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        long startTime = System.currentTimeMillis();
        byte[] gzipString = Utils.getGZipString(sendData);
        Logger.logInfo("[Network] local gzip cost " + (System.currentTimeMillis() - startTime) + " ms");
        if (url == null) {
            EnumActionType action = Properties.findActionType(data);
            url = gzipString == null ? CrasheyeUrls.getURL(action, sendData) : CrasheyeUrls.getURL(action, gzipString);
        }
        Logger.logInfo("[Network] Request Url: " + url);
        Logger.logInfo("[Network] Request body: " + sendData);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (gzipString != null) {
            headers.put("Content-Type", "application/x-gzip");
            headers.put("gzip", "true");
        }
        HttpResponse response = null;
        try {
            startTime = System.currentTimeMillis();
            response = httpClient.post(url, headers, gzipString != null ? gzipString : data.getBytes());
            Logger.logInfo("[Network] http cost " + (System.currentTimeMillis() - startTime) + " ms");
            mNetSenderResponse.setResponseCode(response.getStatusCode());
            mNetSenderResponse.setServerResponse(response.getResponseBody());
            if (response.getStatusCode() >= 400) {
                this.HandleExceptionalResponse(mNetSenderResponse, response.getResponseBody());
            } else if (fileRemoved) {
                SignedInfoUtils.PresignedUploadInfo signedInfo = SignedInfoUtils.parseSignedInfo(response.getResponseBody());
                if (signedInfo == null) {
                    this.HandleExceptionalResponse(mNetSenderResponse, response.getResponseBody());
                } else {
                    MultipartBody body = SignedInfoUtils.buildMultipartBody(signedInfo.fields, file);
                    String contentType = body.getContentType();
                    System.out.println("actual: " + new String(body.toByteArray(), "UTF-8"));
                    String new_url = signedInfo.url;
                    Logger.logInfo("S3_new_url: " + new_url);
                    startTime = System.currentTimeMillis();
                    response = httpClient.post(new_url, SignedInfoUtils.getNewHeader(contentType), body.toByteArray());
                    Logger.logInfo("[S3_Network] http cost " + (System.currentTimeMillis() - startTime) + " ms");
                    mNetSenderResponse.setResponseCode(response.getStatusCode());
                    mNetSenderResponse.setServerResponse(response.getResponseBody());
                    if (response.getStatusCode() >= 400) {
                        this.HandleExceptionalResponse(mNetSenderResponse, response.getResponseBody());
                    } else {
                        mNetSenderResponse.setSentSuccessfully(true);
                    }
                }
            } else {
                mNetSenderResponse.setSentSuccessfully(true);
            }
            if (Crasheye.crasheyeCallback == null) {
                return mNetSenderResponse;
            }
        }
        catch (Throwable er) {
            Logger.logError("[Network] Transmitting Error " + er.getMessage());
            if (Crasheye.DEBUG) {
                er.printStackTrace();
            }
            mNetSenderResponse.setException(new Exception(er));
            if (Crasheye.crasheyeCallback != null) {
                Crasheye.crasheyeCallback.netSenderResponse(mNetSenderResponse);
            }
            if (saveOnFail) {
                Logger.logWarning("[Network] Couldn't send data, saving...");
                new AsyncDataSaver().save(data, CrasheyeFileFilter.createNewFile());
            }
            return mNetSenderResponse;
        }
        if (Crasheye.crasheyeCallback != null) {
            Crasheye.crasheyeCallback.netSenderResponse(mNetSenderResponse);
        }
        return mNetSenderResponse;
    }
}

