/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import android.util.Log;
import com.xsj.crasheye.ActionError;
import com.xsj.crasheye.ActionEvent;
import com.xsj.crasheye.ActionView;
import com.xsj.crasheye.AsyncDataSaver;
import com.xsj.crasheye.CrasheyeCallback;
import com.xsj.crasheye.CrasheyeLogLevel;
import com.xsj.crasheye.DataFlusher;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.EnumExceptionType;
import com.xsj.crasheye.ExtraData;
import com.xsj.crasheye.NativeExceptionHandler;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.ScriptExceptionHanler;
import com.xsj.crasheye.exception.ExceptionHandler;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.session.SessionManager;
import com.xsj.crasheye.util.TaskManager;
import com.xsj.crasheye.util.Utils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import org.json.JSONObject;

public final class Crasheye {
    public static boolean DEBUG = false;
    private static boolean initialize = false;
    private static boolean isSessionActive = false;
    public static CrasheyeCallback crasheyeCallback = null;

    public static void setURL(String domain) {
        Logger.logInfo("[Setting] domain: " + domain);
        Properties.domainConfig = domain;
    }

    public static void setRegion(String region) {
        Logger.logInfo("[Setting] region: " + region);
        Properties.region = region;
    }

    public static void init(Context context, String appKey) {
        if (context == null) {
            Logger.logWarning("Context is null!");
            return;
        }
        if (appKey == null) {
            Logger.logWarning("appKey is null!");
            return;
        }
        boolean initValue = Crasheye.init(context, appKey, null);
        if (!initValue) {
            return;
        }
    }

    public static void initWithNativeHandle(Context context, String appKey) {
        if (context == null) {
            Logger.logWarning("Context is null!");
            return;
        }
        if (appKey == null) {
            Logger.logWarning("appKey is null!");
            return;
        }
        boolean initValue = Crasheye.init(context, appKey, null);
        if (!initValue) {
            return;
        }
        NativeExceptionHandler.getInstance().init();
    }

    public static void initWithMonoNativeHandle(Context context, String appKey) {
        if (context == null) {
            Logger.logWarning("Context is null!");
            return;
        }
        if (appKey == null) {
            Logger.logWarning("appKey is null!");
            return;
        }
        boolean initValue = Crasheye.init(context, appKey, null);
        if (!initValue) {
            return;
        }
        NativeExceptionHandler.getInstance().initWithMono();
        Properties.crasheyeInitType = "unity";
    }

    public static void initWithNativeHandleUserspaceSig(Context context, String appKey) {
        if (context == null) {
            Logger.logWarning("Context is null!");
            return;
        }
        if (appKey == null) {
            Logger.logWarning("appKey is null!");
            return;
        }
        boolean initValue = Crasheye.init(context, appKey, null);
        if (!initValue) {
            return;
        }
        NativeExceptionHandler.getInstance().initWithHandleUserspaceSig();
        Properties.crasheyeInitType = "unity";
    }

    private static boolean init(final Context context, String appKey, String url) {
        if (context == null) {
            Logger.logWarning("[Init] Context is null!");
            return false;
        }
        if (appKey == null || appKey.length() != 8 || appKey.length() > 14) {
            throw new IllegalArgumentException("[Init] Your API Key is invalid!");
        }
        if (initialize) {
            Logger.logWarning("[Init] Crasheye has already inited...");
            return true;
        }
        Log.i((String)"Crasheye", (String)("Crasheye Version=2.3.8, AppKey=" + appKey + ", URL=" + Properties.domainConfig));
        Properties.APP_KEY = appKey;
        Properties.TIMESTAMP = System.currentTimeMillis();
        try {
            DEBUG = new File(context.getExternalFilesDir(null), "crasheye_debug.json").exists();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean initIsTrue = Properties.initialize(context);
        if (!initIsTrue) {
            Logger.logError("[Init] Crasheye initialize fail, Could not initialize Crasheye!");
            return false;
        }
        Log.i((String)"Crasheye", (String)("Device UUID=" + Properties.UID));
        Crasheye.installExceptionHandler();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Crasheye.startSession(context);
                Crasheye.flush();
            }
        };
        TaskManager.getInstance().postImmediately(task);
        Logger.logInfo("[Init] Crasheye SDK init success!");
        initialize = true;
        return true;
    }

    public static void setChannelID(String YourChannelID) {
        Logger.logInfo("[Setting] ChannelID: " + YourChannelID);
        if (YourChannelID == null) {
            Logger.logError("Set channel id is null!");
            return;
        }
        Properties.APP_CHANNELID = YourChannelID;
    }

    public static void setAppVersion(String YourAppVersion) {
        Logger.logInfo("[Setting] AppVersion: " + YourAppVersion);
        Properties.setAppVersion(YourAppVersion);
    }

    public static void setIsBetaVersion(boolean isBeta) {
        Logger.logInfo("[Setting] IsBetaVersion: " + isBeta);
        Properties.APP_ISBETAVERSION = isBeta;
    }

    public static String getSDKVersion() {
        return "2.3.8";
    }

    public static void startSession(Context context) {
        if (context == null) {
            Logger.logWarning("Context is null!");
            return;
        }
        if (!isSessionActive) {
            isSessionActive = true;
            Properties.initialize(context);
        }
        if (!Utils.shouldSendPing(context)) {
            return;
        }
        if (!Utils.isRunningService(context)) {
            Logger.logWarning("[Init] is running in service, don't send session to server.");
            return;
        }
        SessionManager.getInstance().startSession(context);
    }

    public static void closeSession(Context context) {
        if (context == null) {
            Logger.logWarning("Context is null!");
            return;
        }
        if (!Properties.isPluginInitialized()) {
            return;
        }
        if (!isSessionActive) {
            return;
        }
        isSessionActive = false;
        ActionEvent event = ActionEvent.createGnip();
        event.save(new AsyncDataSaver());
    }

    public static void flush() {
        if (Properties.isPluginInitialized()) {
            if (!Utils.isRunningService(Properties.AppContent)) {
                Logger.logInfo("[Init] is running in service, don't start data flusher send.");
                return;
            }
            new DataFlusher().send();
        }
    }

    public static final void setCrasheyeCallback(CrasheyeCallback mintCallback) {
        if (mintCallback == null) {
            Logger.logWarning("CrasheyeCallback is null!");
            return;
        }
        crasheyeCallback = mintCallback;
    }

    public static final void setNDKExceptionCallback(NDKExceptionCallback ndkExceiptn) {
        if (ndkExceiptn == null) {
            Logger.logWarning("NDKExceptionCallback is null!");
            return;
        }
        NativeExceptionHandler.ndkExceptionCallback = ndkExceiptn;
    }

    public static void leaveBreadcrumb(String breadcrumb) {
        if (Properties.isPluginInitialized() && breadcrumb != null) {
            Properties.breadcrumbs.addToList(breadcrumb);
        }
    }

    public static void logView(String view) {
        if (Properties.isPluginInitialized() && view != null) {
            ActionView.logView(view).save(new AsyncDataSaver());
        }
    }

    public static void logEvent(String eventName) {
        if (Properties.isPluginInitialized() && eventName != null) {
            ActionEvent event = ActionEvent.createEvent(eventName);
            event.save(new AsyncDataSaver());
        }
    }

    public static void logEvent(String eventName, CrasheyeLogLevel logLevel) {
        if (Properties.isPluginInitialized() && eventName != null && logLevel != null) {
            ActionEvent event = ActionEvent.createEvent(eventName, logLevel, null);
            event.save(new AsyncDataSaver());
        }
    }

    public static void logEvent(String eventName, CrasheyeLogLevel logLevel, HashMap<String, Object> customData) {
        if (eventName == null) {
            Logger.logWarning("eventName is null!");
            return;
        }
        if (logLevel == null) {
            Logger.logWarning("logLevel is null!");
            return;
        }
        if (customData == null) {
            Logger.logWarning("customData is null!");
            return;
        }
        if (Properties.isPluginInitialized()) {
            ActionEvent event = ActionEvent.createEvent(eventName, logLevel, customData);
            event.save(new AsyncDataSaver());
        }
    }

    public static void logEvent(String eventName, CrasheyeLogLevel logLevel, String keyName, String keyValue) {
        if (eventName == null) {
            Logger.logWarning("eventName is null!");
            return;
        }
        if (logLevel == null) {
            Logger.logWarning("logLevel is null!");
            return;
        }
        if (keyName == null) {
            Logger.logWarning("keyName is null!");
            return;
        }
        if (keyValue == null) {
            Logger.logWarning("keyValue is null!");
            return;
        }
        if (Properties.isPluginInitialized()) {
            HashMap<String, Object> customData = new HashMap<String, Object>(1);
            customData.put(keyName, keyValue);
            Crasheye.logEvent(eventName, logLevel, customData);
        }
    }

    public static void setUserIdentifier(String userIdentifier) {
        Properties.setUserIdentifier(userIdentifier);
    }

    public static void setInternalExtraData(String extraData) {
        Properties.setInternalExtraData(extraData);
    }

    public static void enableDebug() {
        DEBUG = true;
    }

    public static void setFlushOnlyOverWiFi(boolean enabled) {
        Logger.logInfo("[Setting] FlushOnlyOverWifi: " + enabled);
        Properties.flushOnlyOverWiFi = enabled;
    }

    public static HashMap<String, Object> getExtraData() {
        if (Properties.extraData == null) {
            return null;
        }
        return Properties.extraData.getExtraData();
    }

    public static void addExtraData(String key, String value) {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        if (key != null) {
            if (value == null) {
                value = "null";
            }
            Properties.extraData.addExtraData(key, value);
        }
    }

    public static void addExtraDataMap(HashMap<String, Object> extras) {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        if (extras != null) {
            Properties.extraData.addExtraDataMap(extras);
        }
    }

    public static void removeExtraData(String key) {
        if (Properties.extraData == null) {
            return;
        }
        if (key != null) {
            Properties.extraData.removeKey(key);
        }
    }

    public static void clearExtraData() {
        if (Properties.extraData == null) {
            return;
        }
        Properties.extraData.clearData();
    }

    public static void logException(Exception ex) {
        if (ex == null) {
            Logger.logWarning("Exception is null!");
            return;
        }
        HashMap<String, Object> extraData = new HashMap<String, Object>(0);
        Crasheye.logExceptionMap(extraData, ex);
    }

    public static void logExceptionMap(HashMap<String, Object> customData, Exception exception) {
        if (!Properties.isPluginInitialized()) {
            return;
        }
        StringWriter stacktrace = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stacktrace);
        exception.printStackTrace(printWriter);
        ActionError mCrashData = new ActionError(EnumActionType.error, ((Object)stacktrace).toString(), EnumExceptionType.HANDLED, customData);
        mCrashData.send(new NetSender(), true);
    }

    public static void sendScriptException(String errorTitle, String stacktrace) {
        if (!Properties.isPluginInitialized()) {
            return;
        }
        Crasheye.sendScriptException(errorTitle, stacktrace, "NA");
    }

    public static void sendScriptException(String errorTitle, String stacktrace, String language) {
        if (!Properties.isPluginInitialized()) {
            return;
        }
        if (errorTitle == null) {
            Logger.logWarning("errorTitle is null!");
            return;
        }
        if (stacktrace == null) {
            Logger.logWarning("stacktrace is null!");
            return;
        }
        String strLanguage = "NA";
        if (language != null) {
            strLanguage = language;
        }
        ScriptExceptionHanler.logScriptException(errorTitle, stacktrace, strLanguage);
    }

    public static void logExceptionMessage(String key, String value, Exception exception) {
        if (!Properties.isPluginInitialized()) {
            return;
        }
        if (exception == null) {
            Logger.logWarning("exception is null!");
            return;
        }
        HashMap<String, Object> extraData = new HashMap<String, Object>(1);
        if (key != null && value != null) {
            extraData.put(key, value);
        }
        Crasheye.logExceptionMap(extraData, exception);
    }

    public static void enableLogging(boolean enable) {
        Logger.logInfo("[Setting] EnableLogging: " + enable);
        Properties.SEND_LOG = enable;
        NativeExceptionHandler.getInstance().updateSystemLogConfigs();
    }

    public static void setLogging(int lines) {
        Logger.logInfo("[Setting] SetLogging: lines=" + lines);
        if (lines <= 0) {
            return;
        }
        if (lines > 1000) {
            lines = 1000;
        }
        Properties.SEND_LOG = true;
        Properties.LOG_MAX_LINES = lines;
        NativeExceptionHandler.getInstance().updateSystemLogConfigs();
    }

    public static void setLogging(String filter) {
        Logger.logInfo("[Setting] SetLogging: filter=" + filter);
        if (filter == null) {
            return;
        }
        Properties.SEND_LOG = true;
        Properties.LOG_FILTER = filter;
        NativeExceptionHandler.getInstance().updateSystemLogConfigs();
    }

    public static void setLogging(int lines, String filter) {
        Logger.logInfo("[Setting] SetLogging: filter=" + filter + " lines=" + lines);
        if (filter == null || lines < 0) {
            return;
        }
        if (lines > 1000) {
            lines = 1000;
        }
        Properties.SEND_LOG = true;
        Properties.LOG_MAX_LINES = lines;
        Properties.LOG_FILTER = filter;
        NativeExceptionHandler.getInstance().updateSystemLogConfigs();
    }

    public static JSONObject getDevSettings() {
        return Properties.RemoteSettingsProps.devSettings;
    }

    private static void installExceptionHandler() {
        Logger.logInfo("[Handler] Registering the Java exception handler");
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(currentHandler instanceof ExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(currentHandler));
        }
    }

    public static final String getSessionId() {
        if (ActionEvent.savedSessionID != null || ActionEvent.savedSessionID.length() > 0) {
            return ActionEvent.savedSessionID;
        }
        return "NA";
    }

    public static final String getCrasheyeUUID() {
        if (Properties.UID != null || Properties.UID.length() > 0) {
            return Properties.UID;
        }
        return "NA";
    }

    public static void setLocalStackAnalyze(boolean enabled) {
        Properties.libcrasheye_stack_analyze = enabled;
    }

    public static interface NDKExceptionCallback {
        public void execute();
    }
}

