/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.ExtraData;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class BaseDTO {
    protected static final String UNKNOWN = "NA";
    protected String appStartTime;
    protected String appVersionName;
    protected boolean appIsBetaVersion;
    protected Long crashTime;
    protected String screenSize;
    protected String sdkVersion = "2.3.8";
    protected String platform = "Android";
    protected EnumActionType type;
    protected String appKey;
    protected String channelId;
    protected String device;
    protected String osVersion;
    protected String locale;
    protected String uuid;
    protected String uniteDeviceId;
    protected String region;
    protected String imei;
    protected String imsi;
    protected String android_id;
    protected String cpu_arch;
    protected String os_rom;
    protected String virtual_check;
    protected String userIdentifier;
    protected String internalExtraData;
    protected String carrier;
    protected String remoteIP;
    protected String connection;
    protected String state;
    protected ExtraData extraData;
    protected String screenOrientation;
    protected HashMap<String, Object> customData;
    protected Boolean rooted;
    protected String appVersionCode;
    protected String packageName;
    protected Long timestampMilis = System.currentTimeMillis();
    protected Boolean isRunningService;
    protected int sessionCount;

    public BaseDTO(EnumActionType dataType, HashMap<String, Object> customData_) {
        this.appStartTime = Utils.getTime();
        this.type = dataType;
        this.appKey = Properties.APP_KEY;
        this.device = (Properties.PHONE_BRAND != null ? Properties.PHONE_BRAND + " " : "") + Properties.PHONE_MODEL;
        this.osVersion = Properties.OS_VERSION;
        this.appVersionCode = Properties.APP_VERSIONCODE;
        this.appVersionName = Properties.getAppVersion();
        this.appIsBetaVersion = Properties.APP_ISBETAVERSION;
        this.packageName = Properties.APP_PACKAGE;
        this.locale = Properties.LOCALE;
        this.rooted = Properties.HAS_ROOT;
        this.uuid = Properties.UID;
        this.uniteDeviceId = Properties.UNITE_DEVICE_ID;
        this.region = Properties.region;
        this.imei = Properties.IMEI;
        this.imsi = Properties.IMSI;
        this.android_id = Properties.ANDROID_ID;
        this.cpu_arch = Properties.CPU_ARCH;
        this.os_rom = Properties.OS_ROM;
        this.virtual_check = Properties.VIRTUAL_CHECK;
        this.userIdentifier = Properties.getUserIdentifier();
        this.internalExtraData = Properties.getInternalExtraData();
        this.connection = Properties.CONNECTION;
        this.state = Properties.STATE;
        this.extraData = Properties.extraData;
        this.screenOrientation = Properties.SCREEN_ORIENTATION;
        this.screenSize = Properties.SCREEN_SIZE;
        this.customData = customData_;
        this.channelId = Properties.APP_CHANNELID;
        this.sessionCount = Properties.sessionCount;
        this.isRunningService = !Utils.isRunningService(Properties.AppContent);
    }

    public JSONObject getBasicDataFixtureJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("appstarttime", (Object)this.appStartTime);
            json.put("crashtime", (Object)this.crashTime);
            json.put("sdkversion", (Object)this.sdkVersion);
            json.put("appkey", (Object)this.appKey);
            json.put("platform", (Object)this.platform);
            json.put("device", (Object)this.device);
            json.put("osversion", (Object)this.osVersion);
            json.put("locale", (Object)this.locale);
            json.put("uuid", (Object)this.uuid);
            json.put("unite_device_id", (Object)this.uniteDeviceId);
            json.put("imei", (Object)this.imei);
            json.put("imsi", (Object)this.imsi);
            json.put("android_id", (Object)this.android_id);
            json.put("cpu_arch", (Object)this.cpu_arch);
            json.put("os_rom", (Object)this.os_rom);
            json.put("virtual_check", (Object)this.virtual_check);
            json.put("useridentifier", (Object)this.userIdentifier);
            json.put("internalextradata", (Object)this.internalExtraData);
            json.put("carrier", (Object)this.carrier);
            json.put("appversioncode", (Object)this.appVersionCode);
            json.put("appversionname", (Object)this.appVersionName);
            json.put("is_beta_version", (Object)(this.appIsBetaVersion ? "1" : "0"));
            json.put("packagename", (Object)this.packageName);
            json.put("netstatus", (Object)this.connection);
            json.put("connection", (Object)this.state);
            json.put("screenorientation", (Object)this.screenOrientation);
            json.put("screensize", (Object)this.screenSize);
            json.put("channel", (Object)this.channelId);
            json.put("sessioncount", this.sessionCount);
            json.put("isservice", (Object)this.isRunningService);
            JSONObject extraDataJson = new JSONObject();
            if (this.extraData != null && !this.extraData.isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.extraData.entrySet()) {
                    if (entry.getValue() == null) {
                        extraDataJson.put((String)entry.getKey(), (Object)"null");
                        continue;
                    }
                    extraDataJson.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (this.customData != null && !this.customData.isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.customData.entrySet()) {
                    if (entry.getValue() == null) {
                        extraDataJson.put((String)entry.getKey(), (Object)"null");
                        continue;
                    }
                    extraDataJson.put((String)entry.getKey(), entry.getValue());
                }
            }
            json.put("extradata", (Object)extraDataJson);
            JSONArray transactions = new JSONArray();
            if (Properties.transactions != null) {
                for (String trans : Properties.transactions) {
                    transactions.put((Object)trans);
                }
            }
            json.put("transactions", (Object)transactions);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }
}

