/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import com.xsj.crasheye.ActionTransaction;
import com.xsj.crasheye.AsyncDataSaver;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.EnumTransactionStatus;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.TransactionsDatabase;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionTransactionStop
extends ActionTransaction
implements InterfaceDataType {
    protected long duration = 0L;
    protected EnumTransactionStatus status = EnumTransactionStatus.FAIL;
    protected String reason = "";

    private ActionTransactionStop(String name, EnumTransactionStatus status, String reason, HashMap<String, Object> customData) {
        super(name, EnumActionType.trstop, customData);
        TransactionsDatabase.Container container;
        this.status = status;
        this.reason = reason;
        if (reason == null || reason.length() == 0) {
            this.reason = "NA";
        }
        if ((container = Properties.transactionsDatabase.getStartedTransactionContainer(name)) != null) {
            this.transaction_id = container.transid;
            long timestampStart = container.timestamp;
            if (timestampStart != -1L) {
                this.duration = this.timestampMilis - timestampStart;
            }
        } else {
            this.transaction_id = null;
        }
        Properties.transactionsDatabase.closeStartedTransaction(name);
    }

    protected static final ActionTransactionStop createTransactionStop(String name, HashMap<String, Object> customData) {
        ActionTransactionStop mTransactionStop = new ActionTransactionStop(name, EnumTransactionStatus.SUCCESS, null, customData);
        return mTransactionStop;
    }

    protected static final ActionTransactionStop createTransactionCancel(String name, String reason, HashMap<String, Object> customData) {
        ActionTransactionStop mTransactionStop = new ActionTransactionStop(name, EnumTransactionStatus.CANCEL, reason, customData);
        return mTransactionStop;
    }

    public static final ActionTransactionStop createTransactionFail(String name, String errorHash, HashMap<String, Object> customData) {
        ActionTransactionStop mTransactionStop = new ActionTransactionStop(name, EnumTransactionStatus.FAIL, errorHash, customData);
        return mTransactionStop;
    }

    @Override
    public String toJsonLine() {
        if (this.transaction_id == null) {
            return null;
        }
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            json.put("tr_name", (Object)this.name);
            json.put("status", (Object)this.status.toString());
            json.put("reason", (Object)this.reason);
            json.put("transaction_id", (Object)this.transaction_id);
            json.put("tr_duration", (Object)String.valueOf(this.duration));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (Properties.transactions.contains(this.transaction_id)) {
            Properties.transactions.remove(this.transaction_id);
        }
        return json.toString() + Properties.getSeparator(EnumActionType.trstop);
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        String trData = this.toJsonLine();
        if (trData != null) {
            netSender.send(null, trData, saveOnFail);
        }
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        String trData = this.toJsonLine();
        if (trData != null) {
            new AsyncDataSaver().save(trData);
        }
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        String trData = this.toJsonLine();
        if (trData != null) {
            netSender.send(null, trData, saveOnFail);
        }
    }
}

