/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import com.xsj.crasheye.AsyncDataSaver;
import com.xsj.crasheye.BaseDTO;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionNetwork
extends BaseDTO
implements InterfaceDataType {
    private String url = "";
    private Long latency = 0L;
    private Integer statusCode = 0;
    private Long responseLength = 0L;
    private Long requestLength = 0L;
    private Boolean failed = true;
    private String exception = "NA";
    private String protocol = "NA";

    public ActionNetwork(EnumActionType type, String url, HashMap<String, Object> customData) {
        super(type, customData);
        this.url = url;
    }

    public static final void logNetwork(String url, long startT, long endT, String protocol, int statusCode, long requestLength, long responseLength, String exception, HashMap<String, Object> customData) {
        ActionNetwork mActionNetwork = new ActionNetwork(EnumActionType.network, url, customData);
        mActionNetwork.latency = endT - startT;
        mActionNetwork.statusCode = statusCode;
        mActionNetwork.responseLength = responseLength;
        mActionNetwork.requestLength = requestLength;
        mActionNetwork.failed = mActionNetwork.statusCode >= 200 && mActionNetwork.statusCode < 400 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        mActionNetwork.exception = exception;
        mActionNetwork.protocol = protocol;
        mActionNetwork.save(new AsyncDataSaver());
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            json.put("url", (Object)ActionNetwork.stripHttpFromUrl(this.url));
            json.put("latency", (Object)this.latency);
            json.put("statusCode", (Object)this.statusCode);
            json.put("responseLength", (Object)this.responseLength);
            json.put("requestLength", (Object)this.requestLength);
            json.put("failed", (Object)this.failed);
            json.put("protocol", (Object)this.protocol);
            if (this.exception != null && this.exception.length() > 0) {
                json.put("exception", (Object)this.exception);
            } else {
                json.put("exception", (Object)"NA");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator(EnumActionType.network);
    }

    private static final String stripHttpFromUrl(String originalUrl) {
        if (originalUrl != null) {
            if (originalUrl.toLowerCase().startsWith("http://")) {
                return originalUrl.replaceFirst("(?i)http://", "");
            }
            if (originalUrl.toLowerCase().startsWith("https://")) {
                return originalUrl.replaceFirst("(?i)https://", "");
            }
        }
        return originalUrl;
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        dataSaver.save(this.toJsonLine());
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }
}

