/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import com.xsj.crasheye.BaseDTO;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.log.Logger;
import org.json.JSONException;
import org.json.JSONObject;

class ActionLog
extends BaseDTO
implements InterfaceDataType {
    public String eventName = "";
    public Integer eventLevel = 2;

    public ActionLog(EnumActionType type, String eventName, Integer level) {
        super(type, null);
        this.eventName = eventName;
        this.eventLevel = level;
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            json.put("log_name", (Object)this.eventName);
            json.put("level", (Object)this.eventLevel);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator(this.type);
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        if (this.eventLevel != null) {
            if (this.eventLevel >= Properties.RemoteSettingsProps.logLevel) {
                dataSaver.save(this.toJsonLine());
            } else {
                Logger.logInfo("Logs's level is lower than the minimum level from Remote Settings, log will not be saved");
            }
        } else {
            dataSaver.save(this.toJsonLine());
        }
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }
}

