/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.webview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.ProgressBar;
import com.youloft.webview.UIUtils;

public class ProgressWebView
extends WebView {
    private ProgressBar progressbar;

    public ProgressWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.progressbar = new ProgressBar(context, null, 16842872);
        this.progressbar.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-1, UIUtils.px2dip(context, 6.0f), 0, 0));
        int style = context.getResources().getIdentifier("progressbar_style", "drawable", context.getPackageName());
        this.progressbar.setProgressDrawable(context.getResources().getDrawable(style));
        this.addView((View)this.progressbar);
        this.setWebChromeClient(new WebChromeClient());
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.progressbar.getLayoutParams();
        lp.x = l;
        lp.y = t;
        this.progressbar.setLayoutParams((ViewGroup.LayoutParams)lp);
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public class WebChromeClient
    extends android.webkit.WebChromeClient {
        public void onProgressChanged(WebView view, int newProgress) {
            if (newProgress == 100) {
                ProgressWebView.this.progressbar.setVisibility(8);
            } else {
                if (ProgressWebView.this.progressbar.getVisibility() == 8) {
                    ProgressWebView.this.progressbar.setVisibility(0);
                }
                ProgressWebView.this.progressbar.setProgress(newProgress);
            }
            super.onProgressChanged(view, newProgress);
        }
    }
}

