/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.BidiFormatter;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.core.app.ActivityCompat;
import com.youloft.api.ApiManager;
import com.youloft.core.utils.MD5Util;
import com.youloft.core.utils.Utils;
import com.youloft.webview.UIUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;

public final class PhoneUtils {
    private PhoneUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isPhone() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getPhoneType() != 0;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getDeviceId(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return PhoneUtils.getAndroidID();
        }
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return PhoneUtils.getAndroidID();
        }
        String deviceId = tm.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String imei = tm.getImei();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                return imei;
            }
            String meid = tm.getMeid();
            return TextUtils.isEmpty((CharSequence)meid) ? "" : meid;
        }
        return "";
    }

    public static String getMd5Id(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return MD5Util.getMD5String(PhoneUtils.getDeviceId(context));
        }
        String serialNum = PhoneUtils.getSerial(context);
        return MD5Util.getMD5String(PhoneUtils.getAndroidID() + PhoneUtils.getDeviceId(context) + serialNum);
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getSerial(Context context) {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return "";
        }
        return Build.VERSION.SDK_INT >= 26 ? Build.getSerial() : Build.SERIAL;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMEI() {
        return PhoneUtils.getImeiOrMeid(true);
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getMEID() {
        return PhoneUtils.getImeiOrMeid(false);
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getImeiOrMeid(boolean isImei) {
        if (Build.VERSION.SDK_INT >= 29) {
            return "";
        }
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        if (Build.VERSION.SDK_INT >= 26) {
            if (isImei) {
                return PhoneUtils.getMinOne(tm.getImei(0), tm.getImei(1));
            }
            return PhoneUtils.getMinOne(tm.getMeid(0), tm.getMeid(1));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            String ids = PhoneUtils.getSystemPropertyByReflect(isImei ? "ril.gsm.imei" : "ril.cdma.meid");
            if (!TextUtils.isEmpty((CharSequence)ids)) {
                String[] idArr = ids.split(",");
                if (idArr.length == 2) {
                    return PhoneUtils.getMinOne(idArr[0], idArr[1]);
                }
                return idArr[0];
            }
            String id0 = tm.getDeviceId();
            String id1 = "";
            try {
                Method method = tm.getClass().getMethod("getDeviceId", Integer.TYPE);
                id1 = (String)method.invoke((Object)tm, isImei ? 1 : 2);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (isImei) {
                if (id0 != null && id0.length() < 15) {
                    id0 = "";
                }
                if (id1 != null && id1.length() < 15) {
                    id1 = "";
                }
            } else {
                if (id0 != null && id0.length() == 14) {
                    id0 = "";
                }
                if (id1 != null && id1.length() == 14) {
                    id1 = "";
                }
            }
            return PhoneUtils.getMinOne(id0, id1);
        }
        String deviceId = tm.getDeviceId();
        if (isImei ? deviceId != null && deviceId.length() >= 15 : deviceId != null && deviceId.length() == 14) {
            return deviceId;
        }
        return "";
    }

    private static String getMinOne(String s0, String s1) {
        boolean empty0 = TextUtils.isEmpty((CharSequence)s0);
        boolean empty1 = TextUtils.isEmpty((CharSequence)s1);
        if (empty0 && empty1) {
            return "";
        }
        if (!empty0 && !empty1) {
            if (s0.compareTo(s1) <= 0) {
                return s0;
            }
            return s1;
        }
        if (!empty0) {
            return s0;
        }
        return s1;
    }

    private static String getSystemPropertyByReflect(String key) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method getMethod = clz.getMethod("get", String.class, String.class);
            return (String)getMethod.invoke(clz, key, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static String getIMSI() {
        return PhoneUtils.getTelephonyManager().getSubscriberId();
    }

    public static int getPhoneType() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getPhoneType();
    }

    public static boolean isSimCardReady() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getSimState() == 5;
    }

    public static String getSimOperatorName() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        return tm.getSimOperatorName();
    }

    public static String getSimOperatorByMnc() {
        TelephonyManager tm = PhoneUtils.getTelephonyManager();
        String operator = tm.getSimOperator();
        if (operator == null) {
            return "";
        }
        switch (operator) {
            case "46000": 
            case "46002": 
            case "46007": 
            case "46020": {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            case "46001": 
            case "46006": 
            case "46009": {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            case "46003": 
            case "46005": 
            case "46011": {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return operator;
    }

    private static TelephonyManager getTelephonyManager() {
        return (TelephonyManager)ApiManager.getContext().getSystemService("phone");
    }

    public static String getAppVersionName() {
        if (ApiManager.getContext() == null) {
            return "";
        }
        PackageManager pm = ApiManager.getContext().getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(ApiManager.getContext().getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getAppVersionCode() {
        if (ApiManager.getContext() == null) {
            return 0;
        }
        PackageManager pm = ApiManager.getContext().getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(ApiManager.getContext().getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getAppName() {
        if (ApiManager.getContext() == null) {
            return "";
        }
        PackageManager pm = ApiManager.getContext().getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(ApiManager.getContext().getPackageName(), 0);
            ApplicationInfo applicationInfo = packageInfo.applicationInfo;
            int labelRes = applicationInfo.labelRes;
            return ApiManager.getContext().getResources().getString(labelRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getCountryZipCode(Context context) {
        String CountryID = "";
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        CountryID = manager.getSimCountryIso().toUpperCase();
        Log.d((String)"ss", (String)("CountryID--->>>" + CountryID));
        return CountryID;
    }

    public static boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/", "/system/sbin/", "/usr/bin/", "/vendor/bin/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(api=17)
    public static boolean isAdbEnabled() {
        return Settings.Secure.getInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"adb_enabled", (int)0) > 0;
    }

    public static String getSDKVersionName() {
        return Build.VERSION.RELEASE;
    }

    public static int getSDKVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID() {
        String id2 = Settings.Secure.getString((ContentResolver)Utils.getApp().getContentResolver(), (String)"android_id");
        if ("9774d56d682e549c".equals(id2)) {
            return "";
        }
        return id2 == null ? "" : id2;
    }

    private static boolean getWifiEnabled() {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return false;
        }
        return manager.isWifiEnabled();
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    private static void setWifiEnabled(boolean enabled) {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return;
        }
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    private static boolean isAddressNotInExcepts(String address, String ... excepts) {
        if (excepts == null || excepts.length == 0) {
            return !"02:00:00:00:00:00".equals(address);
        }
        for (String filter : excepts) {
            if (!address.equals(filter)) continue;
            return false;
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    private static String getMacAddressByWifiInfo() {
        try {
            WifiInfo info;
            WifiManager wifi = (WifiManager)Utils.getApp().getApplicationContext().getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                return info.getMacAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                byte[] macBytes;
                NetworkInterface ni = nis.nextElement();
                if (ni == null || !ni.getName().equalsIgnoreCase("wlan0") || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(String.format("%02x:", b));
                }
                return sb.substring(0, sb.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByInetAddress() {
        try {
            byte[] macBytes;
            NetworkInterface ni;
            InetAddress inetAddress = PhoneUtils.getInetAddress();
            if (inetAddress != null && (ni = NetworkInterface.getByInetAddress(inetAddress)) != null && (macBytes = ni.getHardwareAddress()) != null && macBytes.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(String.format("%02x:", b));
                }
                return sb.substring(0, sb.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static InetAddress getInetAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String hostAddress;
                    InetAddress inetAddress = addresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || (hostAddress = inetAddress.getHostAddress()).indexOf(58) >= 0) continue;
                    return inetAddress;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        String model = Build.MODEL;
        model = model != null ? model.trim().replaceAll("\\s*", "") : "";
        return model;
    }

    public static String[] getABIs() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }

    public static boolean isTablet() {
        return (Utils.getApp().getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean isEmulator() {
        boolean checkDial;
        boolean checkOperatorName;
        String name;
        boolean checkProperty;
        boolean bl = checkProperty = Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.toLowerCase().contains("vbox") || Build.FINGERPRINT.toLowerCase().contains("test-keys") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
        if (checkProperty) {
            return true;
        }
        String operatorName = "";
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (tm != null && (name = tm.getNetworkOperatorName()) != null) {
            operatorName = name;
        }
        if (checkOperatorName = operatorName.toLowerCase().equals("android")) {
            return true;
        }
        String url = "tel:123456";
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)url));
        intent.setAction("android.intent.action.DIAL");
        boolean bl2 = checkDial = intent.resolveActivity(Utils.getApp().getPackageManager()) == null;
        return checkDial;
    }

    public static boolean hasNotchScreen() {
        if (ApiManager.getContext() == null) {
            return false;
        }
        return UIUtils.hasNotchScreen(ApiManager.getContext());
    }

    public static float getNotchHeight() {
        if (ApiManager.getContext() == null) {
            return 0.0f;
        }
        return UIUtils.getStatusBarHeight((Context)ApiManager.getContext());
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected() {
        NetworkInfo info = PhoneUtils.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return null;
        }
        return cm.getActiveNetworkInfo();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static boolean isEthernet() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo info = cm.getNetworkInfo(9);
        if (info == null) {
            return false;
        }
        NetworkInfo.State state = info.getState();
        if (null == state) {
            return false;
        }
        return state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static String getNetworkType() {
        if (PhoneUtils.isEthernet()) {
            return "ETHERNET";
        }
        NetworkInfo info = PhoneUtils.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                return "WIFI";
            }
            if (info.getType() == 0) {
                return "MOBILE_NETWORK";
            }
            return "UNKNOWN";
        }
        return "NO_NETWORK";
    }

    public static String getANDROID(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId;
    }

    public static Integer[] getScreenWH(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(dm);
        return new Integer[]{dm.widthPixels, dm.heightPixels};
    }

    public static String getResolution(Context context) {
        Integer[] screenWH = PhoneUtils.getScreenWH(context);
        if (screenWH == null || screenWH.length < 2) {
            return "";
        }
        return screenWH[0] + "*" + screenWH[1];
    }

    public static String getTimeZone() {
        Calendar mDummyDate = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        mDummyDate.setTimeZone(now.getTimeZone());
        mDummyDate.set(now.get(1), 11, 31, 13, 0, 0);
        return PhoneUtils.getTimeZoneText(now.getTimeZone(), true);
    }

    public static String getTimeZoneText(TimeZone tz, boolean includeName) {
        Date now = new Date();
        SimpleDateFormat gmtFormatter = new SimpleDateFormat("ZZZZ");
        gmtFormatter.setTimeZone(tz);
        String gmtString = gmtFormatter.format(now);
        BidiFormatter bidiFormatter = BidiFormatter.getInstance();
        Locale l = Locale.getDefault();
        boolean isRtl = TextUtils.getLayoutDirectionFromLocale((Locale)l) == 1;
        gmtString = bidiFormatter.unicodeWrap(gmtString, isRtl ? TextDirectionHeuristics.RTL : TextDirectionHeuristics.LTR);
        if (!includeName) {
            return gmtString;
        }
        return gmtString;
    }

    public static String getOperatorName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getSimOperatorName();
    }

    public static String getLanguage(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        String language = locale.getLanguage();
        return language;
    }

    public static String getCountry(Context context) {
        String country = context.getResources().getConfiguration().locale.getCountry();
        return country;
    }

    public static String getNetworkState(Context context) {
        String strNetworkType = "";
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            if (networkInfo.getType() == 1) {
                strNetworkType = "WIFI";
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        strNetworkType = "2G";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        strNetworkType = "3G";
                        break;
                    }
                    case 13: {
                        strNetworkType = "4G";
                        break;
                    }
                    case 20: {
                        strNetworkType = "5G";
                        break;
                    }
                    default: {
                        strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3G" : _strSubTypeName;
                    }
                }
            }
        }
        return strNetworkType;
    }

    private static String getMacFromHardware() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            Log.d((String)"Utils", (String)("all:" + all.size()));
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) {
                    return null;
                }
                Log.d((String)"Utils", (String)("macBytes:" + macBytes.length + "," + nif.getName()));
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getMacDefault(Context context) {
        String mac = null;
        if (context == null) {
            return mac;
        }
        WifiManager wifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifi == null) {
            return mac;
        }
        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (info == null) {
            return null;
        }
        mac = info.getMacAddress();
        if (!TextUtils.isEmpty((CharSequence)mac)) {
            mac = mac.toUpperCase(Locale.ENGLISH);
        }
        return mac;
    }

    private static String getMacAddress() {
        String WifiAddress = null;
        try {
            WifiAddress = new BufferedReader(new FileReader(new File("/sys/class/net/wlan0/address"))).readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return WifiAddress;
    }

    public static String getMacFromHardware(Context context) {
        String macAddress = null;
        if (Build.VERSION.SDK_INT < 23) {
            macAddress = PhoneUtils.getMacDefault(context);
            if (macAddress != null) {
                Log.d((String)"Utils", (String)("android 5.0\u4ee5\u524d\u7684\u65b9\u5f0f\u83b7\u53d6mac" + macAddress));
                if (!macAddress.equalsIgnoreCase("020000000000")) {
                    return macAddress;
                }
            }
        } else if (Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 24) {
            macAddress = PhoneUtils.getMacAddress();
            if (macAddress != null) {
                Log.d((String)"Utils", (String)("android 6~7 \u7684\u65b9\u5f0f\u83b7\u53d6\u7684mac" + macAddress));
                if (!macAddress.equalsIgnoreCase("020000000000")) {
                    return macAddress;
                }
            }
        } else if (Build.VERSION.SDK_INT >= 24 && (macAddress = PhoneUtils.getMacFromHardware()) != null) {
            Log.d((String)"Utils", (String)("android 7\u4ee5\u540e \u7684\u65b9\u5f0f\u83b7\u53d6\u7684mac" + macAddress));
            if (!macAddress.equalsIgnoreCase("020000000000")) {
                return macAddress;
            }
        }
        Log.d((String)"Utils", (String)"\u6ca1\u6709\u83b7\u53d6\u5230MAC");
        return null;
    }

    public static void restartApplication(final Activity context) {
        final Intent launchIntent = context.getApplicationContext().getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (launchIntent != null) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    launchIntent.addFlags(0x10008000);
                    context.startActivity(launchIntent);
                    context.overridePendingTransition(0, 0);
                    ActivityManager am = (ActivityManager)context.getSystemService("activity");
                    Process.killProcess((int)Process.myPid());
                    System.exit(0);
                    context.finish();
                }
            }, 400L);
        }
    }

    public static enum NetworkType {
        NETWORK_ETHERNET,
        NETWORK_WIFI,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

