/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.core.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Environment;
import java.io.File;

public class FileUtils {
    public static File getAppRootPath(Context context) {
        if (FileUtils.sdCardIsAvailable()) {
            return Environment.getExternalStorageDirectory();
        }
        return context.getFilesDir();
    }

    public static boolean sdCardIsAvailable() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File sd = new File(Environment.getExternalStorageDirectory().getAbsolutePath());
            return sd.canWrite();
        }
        return false;
    }

    public static boolean copyTextToClipboard(Context context, CharSequence content) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        if (clipboardManager != null) {
            ClipData clipData = ClipData.newPlainText((CharSequence)content, (CharSequence)content);
            clipboardManager.setPrimaryClip(clipData);
            return true;
        }
        return false;
    }
}

