/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.videoad;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import com.anythink.rewardvideo.api.ATRewardVideoAutoAd;
import com.anythink.rewardvideo.api.ATRewardVideoAutoEventListener;
import com.anythink.rewardvideo.api.ATRewardVideoAutoLoadListener;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.utils.Const;
import com.anythink.unitybridge.utils.TaskManager;
import com.anythink.unitybridge.videoad.VideoListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class VideoAutoAdHelper {
    public final String LOG_PRE = "video_autoad ";
    VideoListener mListener;
    Activity mActivity;
    List<String> mAddedPlacementIds;

    public VideoAutoAdHelper(VideoListener pListener) {
        MsgTools.printMsg("video_autoad ", "VideoAutoAdHelper: " + this);
        if (pListener == null) {
            MsgTools.printMsg("video_autoad ", "Listener == null: ");
        }
        this.mListener = pListener;
        this.mActivity = UnityPluginUtils.getActivity("VideoAutoAdHelper");
        this.mAddedPlacementIds = new ArrayList<String>();
        ATRewardVideoAutoAd.init((Context)this.mActivity, null, (ATRewardVideoAutoLoadListener)new ATRewardVideoAutoLoadListener(){

            public void onRewardVideoAutoLoaded(final String placementId) {
                MsgTools.printMsg("video_autoad ", "onRewardVideoAutoLoaded: " + placementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoAutoAdHelper.this.mListener != null) {
                            VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                            synchronized (videoAutoAdHelper) {
                                VideoAutoAdHelper.this.mListener.onRewardedVideoAdLoaded(placementId);
                            }
                        }
                    }
                });
            }

            public void onRewardVideoAutoLoadFail(final String placementId, final AdError adError) {
                MsgTools.printMsg("video_autoad ", "onRewardVideoAutoLoadFail: " + placementId + ", " + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (VideoAutoAdHelper.this.mListener != null) {
                            VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                            synchronized (videoAutoAdHelper) {
                                VideoAutoAdHelper.this.mListener.onRewardedVideoAdFailed(placementId, adError.getCode(), adError.getFullErrorInfo());
                            }
                        } else {
                            MsgTools.printMsg("video_autoad ", "onRewardVideoAutoLoadFail callnoback: " + adError.getFullErrorInfo());
                        }
                    }
                });
            }
        });
        MsgTools.printMsg("video_autoad ", "VideoAutoAdHelper: init success");
    }

    public void addPlacementIds(String placementIds) {
        if (TextUtils.isEmpty((CharSequence)placementIds)) {
            MsgTools.printMsg("video_autoad ", "addPlacementIds warn: not set placementIds");
            return;
        }
        try {
            MsgTools.printMsg("video_autoad ", "addPlacementIds: " + placementIds);
            JSONArray jsonArray = new JSONArray(placementIds);
            final String[] placementIdArr = new String[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                placementIdArr[i] = jsonArray.getString(i);
            }
            this.mAddedPlacementIds.addAll(Arrays.asList(placementIdArr));
            UnityPluginUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ATRewardVideoAutoAd.addPlacementId((String[])placementIdArr);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgTools.printMsg("video_autoad ", "addPlacementIds error,please check your placementIds:\"" + placementIds + "\"");
        }
    }

    public void removePlacementIds(String placementIds) {
        if (TextUtils.isEmpty((CharSequence)placementIds)) {
            MsgTools.printMsg("video_autoad ", "removePlacementIds warn: not set placementId");
            return;
        }
        try {
            JSONArray jsonArray = new JSONArray(placementIds);
            final String[] placementIdArr = new String[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                placementIdArr[i] = jsonArray.getString(i);
            }
            this.mAddedPlacementIds.removeAll(Arrays.asList(placementIdArr));
            MsgTools.printMsg("video_autoad ", "removePlacementIds: " + placementIds);
            UnityPluginUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ATRewardVideoAutoAd.removePlacementId((String[])placementIdArr);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgTools.printMsg("video_autoad ", "removePlacementIds error,please check your placementIds:\"" + placementIds + "\"");
        }
    }

    public void show(final String placementId, String jsonMap) {
        if (this.mListener == null) {
            MsgTools.printMsg("video_autoad ", "show warn:please init before show");
        }
        if (!this.mAddedPlacementIds.contains(placementId)) {
            MsgTools.printMsg("video_autoad ", "show warn:please addPlacementIds first: " + placementId);
        }
        if (!ATRewardVideoAutoAd.isAdReady((String)placementId)) {
            MsgTools.printMsg("video_autoad ", "show fail:this placementId(" + placementId + ") is not ready to show");
            return;
        }
        String scenario = "";
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            try {
                JSONObject _jsonObject = new JSONObject(jsonMap);
                if (_jsonObject.has("Scenario")) {
                    scenario = _jsonObject.optString("Scenario");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MsgTools.printMsg("video_autoad ", "show placementId:" + placementId + ", scenario:" + scenario);
        final String finalScenario = scenario;
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                final boolean[] isReaward = new boolean[]{false};
                ATRewardVideoAutoAd.show((Activity)VideoAutoAdHelper.this.mActivity, (String)placementId, (String)finalScenario, (ATRewardVideoAutoEventListener)new ATRewardVideoAutoEventListener(){

                    public void onRewardedVideoAdPlayStart(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdPlayStart: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdPlayStart(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdPlayEnd(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdPlayEnd: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdPlayEnd(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdPlayFailed(final AdError adError, ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdPlayFailed: " + placementId + ", " + adError.getFullErrorInfo());
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdPlayFailed(placementId, adError.getCode(), adError.getFullErrorInfo());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdClosed(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdClosed: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdClosed(placementId, isReaward[0], atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdPlayClicked(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdPlayClicked: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdPlayClicked(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onReward(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onReward: " + placementId);
                        isReaward[0] = true;
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onReward(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdAgainPlayStart(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdAgainPlayStart: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdAgainPlayStart(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdAgainPlayEnd(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdAgainPlayEnd: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdAgainPlayEnd(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdAgainPlayFailed(final AdError adError, ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdAgainPlayFailed: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdAgainPlayFailed(placementId, adError.getCode(), adError.getFullErrorInfo());
                                    }
                                }
                            }
                        });
                    }

                    public void onRewardedVideoAdAgainPlayClicked(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onRewardedVideoAdAgainPlayClicked: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onRewardedVideoAdAgainPlayClicked(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }

                    public void onAgainReward(final ATAdInfo atAdInfo) {
                        MsgTools.printMsg("onAgainReward: " + placementId);
                        TaskManager.getInstance().run_proxy(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (VideoAutoAdHelper.this.mListener != null) {
                                    VideoAutoAdHelper videoAutoAdHelper = VideoAutoAdHelper.this;
                                    synchronized (videoAutoAdHelper) {
                                        VideoAutoAdHelper.this.mListener.onAgainReward(placementId, atAdInfo.toString());
                                    }
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public void setAdExtraData(final String placementId, final String jsonMap) {
        MsgTools.printMsg("video_autoad ", "setExtraData start: " + placementId + "," + jsonMap);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String userId = "";
                String userExtraData = "";
                HashMap<String, Object> localExtra = new HashMap<String, Object>();
                try {
                    if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
                        JSONObject jsonObject = new JSONObject(jsonMap);
                        Const.fillMapFromJsonObject(localExtra, jsonObject);
                        if (jsonObject.has("UserId")) {
                            userId = jsonObject.optString("UserId");
                        }
                        if (jsonObject.has("UserExtraData")) {
                            userExtraData = jsonObject.optString("UserExtraData");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MsgTools.printMsg("video_autoad ", "setExtraData failed: " + placementId + "," + jsonMap);
                }
                if (!TextUtils.isEmpty((CharSequence)userId) || !TextUtils.isEmpty((CharSequence)userExtraData)) {
                    localExtra.put("user_id", userId);
                    localExtra.put("user_custom_data", userExtraData);
                    ATRewardVideoAutoAd.setLocalExtra((String)placementId, localExtra);
                    MsgTools.printMsg("fillVideo: " + placementId + ", userId:" + userId + ", userExtraData:" + userExtraData);
                }
            }
        });
    }

    public boolean isAdReady(String placementId) {
        if (!this.mAddedPlacementIds.contains(placementId)) {
            MsgTools.printMsg("video_autoad ", "isAdReady please addPlacementIds first: " + placementId);
        }
        boolean isReady = ATRewardVideoAutoAd.isAdReady((String)placementId);
        MsgTools.printMsg("video_autoad ", "isAdReady: " + placementId + ", " + isReady);
        return isReady;
    }

    public String checkAdStatus(String placementId) {
        if (!this.mAddedPlacementIds.contains(placementId)) {
            MsgTools.printMsg("video_autoad ", "checkAdStatus please addPlacementIds first: " + placementId);
        }
        ATAdStatusInfo atAdStatusInfo = ATRewardVideoAutoAd.checkAdStatus((String)placementId);
        boolean loading = atAdStatusInfo.isLoading();
        boolean ready = atAdStatusInfo.isReady();
        ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isLoading", loading);
            jsonObject.put("isReady", ready);
            try {
                if (atTopAdInfo != null) {
                    jsonObject.put("adInfo", (Object)new JSONObject(atTopAdInfo.toString()));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            MsgTools.printMsg("checkAdStatus: result = " + jsonObject);
            return jsonObject.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getValidAdCaches(String placementId) {
        MsgTools.printMsg("video_autoad ", "getValidAdCaches:" + placementId);
        JSONArray jsonArray = new JSONArray();
        List vaildAds = ATRewardVideoAutoAd.checkValidAdCaches((String)placementId);
        if (vaildAds == null) {
            return "";
        }
        int size = vaildAds.size();
        for (int i = 0; i < size; ++i) {
            try {
                jsonArray.put((Object)new JSONObject(((ATAdInfo)vaildAds.get(i)).toString()));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return jsonArray.toString();
    }

    public void entryAdScenario(String placementId, String scenario) {
        MsgTools.printMsg("video_autoad ", "entryAdScenario... " + placementId + "," + scenario);
        ATRewardVideoAutoAd.entryAdScenario((String)placementId, (String)scenario);
    }
}

