/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.utils;

import android.util.Log;
import com.anythink.unitybridge.utils.Worker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class TaskManager {
    private static TaskManager sSelf = null;
    private ExecutorService mSinglePool = Executors.newSingleThreadExecutor();
    private ThreadPoolExecutor mAPKDownPool = null;

    protected TaskManager() {
    }

    public static TaskManager getInstance() {
        if (sSelf == null) {
            sSelf = new TaskManager();
        }
        return sSelf;
    }

    private void run(Worker worker) {
        this.mSinglePool.execute(worker);
    }

    public void run_proxy(Runnable runnable) {
        this.run_proxyDelayed(runnable, 0L);
    }

    public void run_proxyDelayed(final Runnable runnable, final long delayed) {
        if (runnable != null) {
            Worker worker = new Worker(){

                @Override
                public void work() {
                    try {
                        Thread.sleep(delayed);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)"t", (String)("thread-" + this.getID()));
                    runnable.run();
                }
            };
            worker.setID(new Long(System.currentTimeMillis() / 1000L).intValue());
            this.run(worker);
        }
    }

    public void release() {
        this.mSinglePool.shutdown();
        this.mAPKDownPool.shutdown();
    }
}

