/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.splash;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdSourceStatusListener;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.ATEventInterface;
import com.anythink.core.api.ATNetworkConfirmInfo;
import com.anythink.core.api.ATSDK;
import com.anythink.core.api.AdError;
import com.anythink.splashad.api.ATSplashAd;
import com.anythink.splashad.api.ATSplashAdExtraInfo;
import com.anythink.splashad.api.ATSplashAdListener;
import com.anythink.splashad.api.ATSplashExListener;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.download.DownloadHelper;
import com.anythink.unitybridge.splash.SplashListener;
import com.anythink.unitybridge.utils.Const;
import com.anythink.unitybridge.utils.TaskManager;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SplashHelper {
    private static final String TAG = SplashHelper.class.getSimpleName() + ": ";
    private Activity mActivity;
    private Activity mShowActivity;
    private SplashListener mSplashListener;
    private ATSplashAd mSplashAd;
    private String mPlacementId;
    private ViewGroup mDecorView;
    private ViewGroup mAdContainer;

    public SplashHelper(SplashListener splashListener) {
        MsgTools.printMsg("SplashHelper: " + this);
        if (splashListener == null) {
            MsgTools.printMsg("Listener == null: ");
        }
        this.mSplashListener = new SynSplashListener(splashListener);
        this.mActivity = UnityPluginUtils.getActivity("SplashHelper");
    }

    public void initSplash(String placementId, int fetchAdTimeout, String defaultAdSourceConfig) {
        this.mPlacementId = placementId;
        this.mSplashAd = new ATSplashAd((Context)this.mActivity, placementId, (ATSplashAdListener)new ATSplashExListener(){

            public void onDeeplinkCallback(ATAdInfo atAdInfo, boolean b) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdDeeplinkCallback(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo), b);
                }
            }

            public void onDownloadConfirm(Context context, ATAdInfo atAdInfo, ATNetworkConfirmInfo atNetworkConfirmInfo) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdDownloadConfirm(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }

            public void onAdLoaded(boolean b) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdLoad(SplashHelper.this.mPlacementId, b);
                }
            }

            public void onAdLoadTimeout() {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdLoadTimeOut(SplashHelper.this.mPlacementId);
                }
            }

            public void onNoAdError(AdError adError) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdLoadFailed(SplashHelper.this.mPlacementId, adError != null ? adError.getCode() : "", adError != null ? adError.toString() : "");
                }
            }

            public void onAdShow(ATAdInfo atAdInfo) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdShow(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }

            public void onAdClick(ATAdInfo atAdInfo) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdClick(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }

            public void onAdDismiss(ATAdInfo atAdInfo, ATSplashAdExtraInfo atSplashAdExtraInfo) {
                if (SplashHelper.this.mDecorView != null && SplashHelper.this.mAdContainer != null) {
                    SplashHelper.this.mAdContainer.removeAllViews();
                    SplashHelper.this.mDecorView.removeView((View)SplashHelper.this.mAdContainer);
                }
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onSplashAdDismiss(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }
        }, fetchAdTimeout, defaultAdSourceConfig);
        this.mSplashAd.setAdSourceStatusListener(new ATAdSourceStatusListener(){

            public void onAdSourceBiddingAttempt(ATAdInfo atAdInfo) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onAdSourceBiddingAttempt(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }

            public void onAdSourceBiddingFilled(ATAdInfo atAdInfo) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onAdSourceBiddingFilled(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }

            public void onAdSourceBiddingFail(ATAdInfo atAdInfo, AdError adError) {
                if (SplashHelper.this.mSplashListener != null) {
                    String code = adError != null ? adError.getCode() : "";
                    String msg = adError != null ? adError.getFullErrorInfo() : "";
                    SplashHelper.this.mSplashListener.onAdSourceBiddingFail(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo), code, msg);
                }
            }

            public void onAdSourceAttempt(ATAdInfo atAdInfo) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onAdSourceAttempt(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }

            public void onAdSourceLoadFilled(ATAdInfo atAdInfo) {
                if (SplashHelper.this.mSplashListener != null) {
                    SplashHelper.this.mSplashListener.onAdSourceLoadFilled(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo));
                }
            }

            public void onAdSourceLoadFail(ATAdInfo atAdInfo, AdError adError) {
                if (SplashHelper.this.mSplashListener != null) {
                    String code = adError != null ? adError.getCode() : "";
                    String msg = adError != null ? adError.getFullErrorInfo() : "";
                    SplashHelper.this.mSplashListener.onAdSourceLoadFail(SplashHelper.this.mPlacementId, SplashHelper.this.formatATAdInfo(atAdInfo), code, msg);
                }
            }
        });
        MsgTools.printMsg(TAG + "initSplash() >>> called");
        try {
            if (ATSDK.isCnSDK()) {
                this.mSplashAd.setAdDownloadListener((ATEventInterface)DownloadHelper.getDownloadListener(this.mPlacementId));
            }
        }
        catch (Throwable e) {
            MsgTools.printMsg(TAG + "mSplashAd.setAdDownloadListener() failed: " + e.getMessage());
        }
    }

    public void loadAd(String jsonMap) {
        MsgTools.printMsg(TAG + "loadAd() >>> mPlacementId: " + this.mPlacementId + ", jsonMap: " + jsonMap);
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            try {
                HashMap<String, Object> localExtra = new HashMap<String, Object>();
                JSONObject jsonObject = new JSONObject(jsonMap);
                Const.fillMapFromJsonObject(localExtra, jsonObject);
                if (this.mSplashAd != null) {
                    this.mSplashAd.setLocalExtra(localExtra);
                }
            }
            catch (Exception e) {
                MsgTools.printMsg(TAG + "loadAd() >>> failed: " + e.getMessage());
            }
        }
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (SplashHelper.this.mSplashAd != null) {
                    SplashHelper.this.mSplashAd.loadAd();
                } else {
                    Log.e((String)TAG, (String)("loadAd error, you must call initSplash first " + this));
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (SplashHelper.this.mSplashListener != null) {
                                SplashHelper splashHelper = SplashHelper.this;
                                synchronized (splashHelper) {
                                    SplashHelper.this.mSplashListener.onSplashAdLoadFailed(SplashHelper.this.mPlacementId, "-1", "you must call initSplash first ..");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void showAd(final String jsonMap) {
        MsgTools.printMsg(TAG + "showAd() >>> jsonMap: " + jsonMap + " mShowActivity: " + this.mShowActivity);
        if (this.mSplashAd == null) {
            MsgTools.printMsg(TAG + "showAd failed, you must call initSplash first.");
            TaskManager.getInstance().run_proxy(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (SplashHelper.this.mSplashListener != null) {
                        SplashHelper splashHelper = SplashHelper.this;
                        synchronized (splashHelper) {
                            SplashHelper.this.mSplashListener.onSplashAdLoadFailed(SplashHelper.this.mPlacementId, "-1", "you must call initSplash first.");
                        }
                    }
                }
            });
            return;
        }
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String scenario = "";
                if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
                    try {
                        JSONObject _jsonObject = new JSONObject(jsonMap);
                        if (_jsonObject.has("Scenario")) {
                            scenario = _jsonObject.optString("Scenario");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                MsgTools.printMsg(TAG + "showAd scenario: " + scenario);
                try {
                    SplashHelper.this.mShowActivity = UnityPluginUtils.getActivity("SplashHelper");
                    SplashHelper.this.mDecorView = (ViewGroup)SplashHelper.this.mShowActivity.findViewById(0x1020002);
                    if (SplashHelper.this.mAdContainer == null) {
                        SplashHelper.this.mAdContainer = (ViewGroup)new FrameLayout((Context)SplashHelper.this.mShowActivity);
                        SplashHelper.this.mAdContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                    }
                    SplashHelper.this.mAdContainer.removeAllViews();
                    if (SplashHelper.this.mDecorView != null) {
                        SplashHelper.this.mDecorView.removeView((View)SplashHelper.this.mAdContainer);
                        SplashHelper.this.mDecorView.addView((View)SplashHelper.this.mAdContainer);
                    }
                    if (!TextUtils.isEmpty((CharSequence)scenario)) {
                        SplashHelper.this.mSplashAd.show(SplashHelper.this.mShowActivity, SplashHelper.this.mAdContainer, scenario);
                    } else {
                        SplashHelper.this.mSplashAd.show(SplashHelper.this.mShowActivity, SplashHelper.this.mAdContainer);
                    }
                }
                catch (Exception e) {
                    MsgTools.printMsg(TAG + "showAd failed: " + e.getMessage());
                }
            }
        });
    }

    public boolean isAdReady() {
        boolean result = this.mSplashAd != null && this.mSplashAd.isAdReady();
        MsgTools.printMsg(TAG + "isAdReady() >>> mPlacementId: " + this.mPlacementId + " isAdReady: " + result);
        return result;
    }

    public String checkAdStatus() {
        MsgTools.printMsg(TAG + "checkAdStatus: " + this.mPlacementId);
        if (this.mSplashAd != null) {
            ATAdStatusInfo atAdStatusInfo = this.mSplashAd.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                try {
                    if (atTopAdInfo != null) {
                        jsonObject.put("adInfo", (Object)new JSONObject(atTopAdInfo.toString()));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                MsgTools.printMsg("checkAdStatus: result = " + jsonObject);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String getValidAdCaches() {
        MsgTools.printMsg(TAG + "getValidAdCaches:" + this.mPlacementId);
        if (this.mSplashAd != null) {
            JSONArray jsonArray = new JSONArray();
            List vaildAds = this.mSplashAd.checkValidAdCaches();
            if (vaildAds == null) {
                return "";
            }
            int size = vaildAds.size();
            for (int i = 0; i < size; ++i) {
                try {
                    jsonArray.put((Object)new JSONObject(((ATAdInfo)vaildAds.get(i)).toString()));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return jsonArray.toString();
        }
        return "";
    }

    public void entryAdScenario(final String scenarioId) {
        MsgTools.printMsg(TAG + "entryAdScenario mPlacementId: " + this.mPlacementId + ", scenarioId: " + scenarioId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)SplashHelper.this.mPlacementId)) {
                    ATSplashAd.entryAdScenario((String)SplashHelper.this.mPlacementId, (String)scenarioId);
                } else {
                    MsgTools.printMsg("entryAdScenario error, you must call initSplash first " + SplashHelper.this.mPlacementId);
                }
            }
        });
    }

    private String formatATAdInfo(ATAdInfo atAdInfo) {
        return atAdInfo != null ? atAdInfo.toString() : "";
    }

    private static class SynSplashListener
    implements SplashListener {
        private final Object lockObj = new Object();
        private final SplashListener splashListener;

        public SynSplashListener(SplashListener splashListener) {
            this.splashListener = splashListener;
        }

        private void runOnThread(Runnable runnable) {
            TaskManager.getInstance().run_proxy(runnable);
        }

        @Override
        public void onSplashAdLoad(final String unitId, final boolean isTimeout) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdLoad(unitId, isTimeout);
                        }
                    }
                });
            }
        }

        @Override
        public void onSplashAdLoadTimeOut(final String unitId) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdLoadTimeOut(unitId);
                        }
                    }
                });
            }
        }

        @Override
        public void onSplashAdLoadFailed(final String unitId, final String code, final String msg) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdLoadFailed(unitId, code, msg);
                        }
                    }
                });
            }
        }

        @Override
        public void onSplashAdShow(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdShow(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onSplashAdClick(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdClick(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onSplashAdDismiss(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdDismiss(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onSplashAdDeeplinkCallback(final String unitId, final String callbackJson, final boolean isSuccess) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdDeeplinkCallback(unitId, callbackJson, isSuccess);
                        }
                    }
                });
            }
        }

        @Override
        public void onSplashAdDownloadConfirm(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onSplashAdDownloadConfirm(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onAdSourceBiddingAttempt(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onAdSourceBiddingAttempt(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onAdSourceBiddingFilled(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onAdSourceBiddingFilled(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onAdSourceBiddingFail(final String unitId, final String callbackJson, final String code, final String error) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onAdSourceBiddingFail(unitId, callbackJson, code, error);
                        }
                    }
                });
            }
        }

        @Override
        public void onAdSourceAttempt(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onAdSourceAttempt(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onAdSourceLoadFilled(final String unitId, final String callbackJson) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onAdSourceLoadFilled(unitId, callbackJson);
                        }
                    }
                });
            }
        }

        @Override
        public void onAdSourceLoadFail(final String unitId, final String callbackJson, final String code, final String error) {
            if (this.splashListener != null) {
                this.runOnThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SynSplashListener.this.lockObj;
                        synchronized (object) {
                            SynSplashListener.this.splashListener.onAdSourceLoadFail(unitId, callbackJson, code, error);
                        }
                    }
                });
            }
        }
    }
}

