/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.nativead;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.anythink.core.api.ATAdAppInfo;
import com.anythink.nativead.api.ATNativeImageView;
import com.anythink.nativead.api.ATNativeMaterial;
import com.anythink.nativead.api.ATNativePrepareExInfo;
import com.anythink.nativead.api.ATNativePrepareInfo;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.nativead.CustomAppDownloadButtonStyle;
import com.anythink.unitybridge.nativead.ViewInfo;
import com.anythink.unitybridge.utils.CommonUtil;
import com.anythink.unitybridge.view.SimpleWebViewActivity;
import com.huawei.hms.ads.AppDownloadButton;
import com.huawei.hms.ads.AppDownloadButtonStyle;
import java.util.ArrayList;
import java.util.List;

public class SelfRenderViewUtil {
    Activity mActivity;
    ViewInfo mViewInfo;
    FrameLayout mFrameLayout;
    ImageView mDislikeView;
    int mNetworkType;

    public SelfRenderViewUtil(Activity pActivity, ViewInfo pViewInfo, int networkType) {
        this.mActivity = pActivity;
        this.mViewInfo = pViewInfo;
        this.mNetworkType = networkType;
    }

    public FrameLayout bindSelfRenderView(ATNativeMaterial adMaterial, ATNativePrepareInfo nativePrepareInfo, ViewInfo pViewInfo) {
        this.mFrameLayout = new FrameLayout((Context)this.mActivity);
        FrameLayout frameLayout = new FrameLayout((Context)this.mActivity);
        TextView titleView = new TextView((Context)this.mActivity);
        TextView descView = new TextView((Context)this.mActivity);
        ArrayList<View> clickViewList = new ArrayList<View>();
        ArrayList<View> customClickViews = new ArrayList<View>();
        View mediaView = adMaterial.getAdMediaView(new Object[]{frameLayout});
        if (mediaView != null) {
            MsgTools.printMsg("media view ---> " + adMaterial.getVideoUrl());
            if (pViewInfo.imgMainView != null) {
                ViewInfo.add2ParentView(frameLayout, mediaView, pViewInfo.imgMainView, -1);
            }
        } else {
            MsgTools.printMsg("main image ---> " + adMaterial.getMainImageUrl());
            if (pViewInfo.imgMainView != null) {
                ATNativeImageView mainImageView = new ATNativeImageView((Context)this.mActivity);
                ViewInfo.add2ParentView(frameLayout, (View)mainImageView, pViewInfo.imgMainView, -1);
                mainImageView.setImage(adMaterial.getMainImageUrl());
                nativePrepareInfo.setMainImageView((View)mainImageView);
            }
        }
        if (pViewInfo.titleView != null) {
            if (!TextUtils.isEmpty((CharSequence)pViewInfo.titleView.textcolor)) {
                titleView.setTextColor(Color.parseColor((String)pViewInfo.titleView.textcolor));
            }
            if (pViewInfo.titleView.textSize > 0) {
                titleView.setTextSize((float)pViewInfo.titleView.textSize);
            }
            MsgTools.printMsg("title----> " + adMaterial.getTitle());
            titleView.setText((CharSequence)adMaterial.getTitle());
            titleView.setSingleLine();
            titleView.setMaxEms(15);
            titleView.setEllipsize(TextUtils.TruncateAt.END);
            ViewInfo.add2ParentView(frameLayout, (View)titleView, pViewInfo.titleView, -1);
            nativePrepareInfo.setTitleView((View)titleView);
        }
        if (pViewInfo.descView != null && descView != null) {
            if (!TextUtils.isEmpty((CharSequence)pViewInfo.descView.textcolor)) {
                descView.setTextColor(Color.parseColor((String)pViewInfo.descView.textcolor));
            }
            if (pViewInfo.descView.textSize > 0) {
                descView.setTextSize((float)pViewInfo.descView.textSize);
            }
            MsgTools.printMsg("desc----> " + adMaterial.getDescriptionText());
            descView.setText((CharSequence)adMaterial.getDescriptionText());
            descView.setMaxLines(3);
            descView.setMaxEms(15);
            descView.setEllipsize(TextUtils.TruncateAt.END);
            ViewInfo.add2ParentView(frameLayout, (View)descView, pViewInfo.descView, -1);
            nativePrepareInfo.setDescView((View)descView);
        }
        ATNativeImageView iconView = null;
        if (pViewInfo.IconView != null) {
            FrameLayout iconArea = new FrameLayout((Context)this.mActivity);
            View adIconView = adMaterial.getAdIconView();
            if (adIconView == null) {
                iconView = new ATNativeImageView((Context)this.mActivity);
                iconArea.addView((View)iconView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                iconView.setImage(adMaterial.getIconImageUrl());
                MsgTools.printMsg("ad icon url----> " + adMaterial.getIconImageUrl());
            } else {
                MsgTools.printMsg("ad icon view----> " + adIconView);
                iconArea.addView(adIconView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
            ViewInfo.add2ParentView(frameLayout, (View)iconArea, pViewInfo.IconView, -1);
            nativePrepareInfo.setIconView((View)iconView);
        }
        View ctaView = null;
        if (pViewInfo.ctaView != null) {
            block43: {
                try {
                    if (this.mNetworkType == 39 && (ctaView = adMaterial.getCallToActionButton()) != null && ctaView instanceof AppDownloadButton) {
                        CustomAppDownloadButtonStyle appDownloadButtonStyle = new CustomAppDownloadButtonStyle((Context)this.mActivity, pViewInfo);
                        if (pViewInfo.ctaView.textSize > 0) {
                            ((AppDownloadButton)ctaView).setTextSize((float)CommonUtil.dip2px((Context)this.mActivity, pViewInfo.ctaView.textSize));
                        }
                        ((AppDownloadButton)ctaView).setAppDownloadButtonStyle((AppDownloadButtonStyle)appDownloadButtonStyle);
                        MsgTools.printMsg("cta----> download button");
                        FrameLayout.LayoutParams ctaLayoutParams = new FrameLayout.LayoutParams(pViewInfo.ctaView.mWidth, pViewInfo.ctaView.mHeight);
                        ctaLayoutParams.leftMargin = pViewInfo.ctaView.mX;
                        ctaLayoutParams.topMargin = pViewInfo.ctaView.mY;
                        ctaLayoutParams.gravity = 51;
                        frameLayout.addView(ctaView, (ViewGroup.LayoutParams)ctaLayoutParams);
                    }
                }
                catch (Throwable e) {
                    ctaView = null;
                    if (!MsgTools.isDebug) break block43;
                    e.printStackTrace();
                }
            }
            if (ctaView == null) {
                TextView ctaTextView = new TextView((Context)this.mActivity);
                if (!TextUtils.isEmpty((CharSequence)pViewInfo.ctaView.textcolor)) {
                    ctaTextView.setTextColor(Color.parseColor((String)pViewInfo.ctaView.textcolor));
                }
                if (pViewInfo.ctaView.textSize > 0) {
                    ctaTextView.setTextSize((float)pViewInfo.ctaView.textSize);
                }
                ctaTextView.setGravity(17);
                ctaTextView.setSingleLine();
                ctaTextView.setMaxEms(15);
                ctaTextView.setEllipsize(TextUtils.TruncateAt.END);
                MsgTools.printMsg("cta----> " + adMaterial.getCallToActionText());
                ctaTextView.setText((CharSequence)adMaterial.getCallToActionText());
                ViewInfo.add2ParentView(frameLayout, (View)ctaTextView, pViewInfo.ctaView, -1);
                nativePrepareInfo.setCtaView((View)ctaTextView);
                ctaView = ctaTextView;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)adMaterial.getAdFrom())) {
            FrameLayout.LayoutParams adFromParam = new FrameLayout.LayoutParams(-2, -2);
            adFromParam.leftMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
            adFromParam.bottomMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
            adFromParam.gravity = 80;
            TextView adFromTextView = new TextView((Context)this.mActivity);
            adFromTextView.setTextSize(1, 6.0f);
            adFromTextView.setPadding(CommonUtil.dip2px((Context)this.mActivity, 5.0f), CommonUtil.dip2px((Context)this.mActivity, 2.0f), CommonUtil.dip2px((Context)this.mActivity, 5.0f), CommonUtil.dip2px((Context)this.mActivity, 2.0f));
            adFromTextView.setBackgroundColor(-7829368);
            adFromTextView.setTextColor(-1);
            adFromTextView.setText((CharSequence)adMaterial.getAdFrom());
            MsgTools.printMsg("ad from----> " + adMaterial.getAdFrom());
            frameLayout.addView((View)adFromTextView, (ViewGroup.LayoutParams)adFromParam);
            nativePrepareInfo.setAdFromView((View)adFromTextView);
        }
        if (pViewInfo.elementsView != null) {
            ATAdAppInfo adAppInfo = adMaterial.getAdAppInfo();
            if (adAppInfo != null) {
                View elementsView;
                MsgTools.printMsg("adAppInfo----> " + adAppInfo.toString());
                String appName = adAppInfo.getAppName();
                if (!TextUtils.isEmpty((CharSequence)appName)) {
                    MsgTools.printMsg("update title ----> " + appName);
                    titleView.setText((CharSequence)appName);
                }
                if ((elementsView = this.createElementsView(pViewInfo.elementsView, adAppInfo)) != null) {
                    ViewInfo.add2ParentView(frameLayout, elementsView, pViewInfo.elementsView, -1);
                }
            } else {
                MsgTools.printMsg("adAppInfo----> null");
            }
        }
        View logoView = null;
        if (pViewInfo.adLogoView != null) {
            View adLogoView = adMaterial.getAdLogoView();
            if (adLogoView != null) {
                logoView = adLogoView;
                MsgTools.printMsg("ad logo view----> " + adLogoView);
                ViewInfo.add2ParentView(frameLayout, logoView, pViewInfo.adLogoView, -1);
                nativePrepareInfo.setAdLogoView(logoView);
            } else {
                String adChoiceIconUrl = adMaterial.getAdChoiceIconUrl();
                Bitmap adLogoBitmap = adMaterial.getAdLogo();
                ATNativeImageView atNativeImageView = new ATNativeImageView((Context)this.mActivity);
                if (!TextUtils.isEmpty((CharSequence)adChoiceIconUrl)) {
                    MsgTools.printMsg("ad choice url----> " + adChoiceIconUrl);
                    atNativeImageView.setImage(adChoiceIconUrl);
                    logoView = atNativeImageView;
                    ViewInfo.add2ParentView(frameLayout, logoView, pViewInfo.adLogoView, -1);
                    nativePrepareInfo.setAdLogoView(logoView);
                } else if (adLogoBitmap != null) {
                    MsgTools.printMsg("ad logo bitmap----> " + adLogoBitmap);
                    atNativeImageView.setImageBitmap(adLogoBitmap);
                    logoView = atNativeImageView;
                    ViewInfo.add2ParentView(frameLayout, logoView, pViewInfo.adLogoView, -1);
                    nativePrepareInfo.setAdLogoView(logoView);
                } else {
                    MsgTools.printMsg("start to add adMaterial label textview");
                    TextView adLableTextView = new TextView((Context)this.mActivity);
                    adLableTextView.setTextColor(-1);
                    adLableTextView.setText((CharSequence)"AD");
                    adLableTextView.setTextSize(11.0f);
                    adLableTextView.setPadding(CommonUtil.dip2px((Context)this.mActivity, 3.0f), 0, CommonUtil.dip2px((Context)this.mActivity, 3.0f), 0);
                    adLableTextView.setBackgroundColor(Color.parseColor((String)"#66000000"));
                    if (frameLayout != null) {
                        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                        layoutParams.leftMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
                        layoutParams.topMargin = CommonUtil.dip2px((Context)this.mActivity, 3.0f);
                        frameLayout.addView((View)adLableTextView, (ViewGroup.LayoutParams)layoutParams);
                        MsgTools.printMsg("add adMaterial label textview 2 activity");
                        nativePrepareInfo.setAdLogoView((View)adLableTextView);
                    }
                }
            }
            FrameLayout.LayoutParams adLogoLayoutParams = new FrameLayout.LayoutParams(pViewInfo.adLogoView.mWidth, pViewInfo.adLogoView.mHeight);
            adLogoLayoutParams.leftMargin = pViewInfo.adLogoView.mX;
            adLogoLayoutParams.topMargin = pViewInfo.adLogoView.mY;
            nativePrepareInfo.setChoiceViewLayoutParams(adLogoLayoutParams);
        }
        if (pViewInfo.dislikeView != null) {
            this.initDislikeView(pViewInfo.dislikeView);
            MsgTools.printMsg("ad dislike----> " + this.mDislikeView);
            ViewInfo.add2ParentView(frameLayout, (View)this.mDislikeView, pViewInfo.dislikeView, -1);
            nativePrepareInfo.setCloseView((View)this.mDislikeView);
        }
        if (pViewInfo.rootView != null) {
            this.dealWithClick((View)frameLayout, pViewInfo.rootView.isCustomClick, clickViewList, customClickViews, "root");
        }
        if (pViewInfo.titleView != null) {
            this.dealWithClick((View)titleView, pViewInfo.titleView.isCustomClick, clickViewList, customClickViews, "title");
        }
        if (pViewInfo.descView != null) {
            this.dealWithClick((View)descView, pViewInfo.descView.isCustomClick, clickViewList, customClickViews, "desc");
        }
        if (pViewInfo.IconView != null) {
            this.dealWithClick((View)iconView, pViewInfo.IconView.isCustomClick, clickViewList, customClickViews, "icon");
        }
        if (pViewInfo.adLogoView != null) {
            this.dealWithClick(logoView, pViewInfo.adLogoView.isCustomClick, clickViewList, customClickViews, "adLogo");
        }
        if (pViewInfo.ctaView != null) {
            this.dealWithClick(ctaView, pViewInfo.ctaView.isCustomClick, clickViewList, customClickViews, "cta");
        }
        nativePrepareInfo.setClickViewList(clickViewList);
        if (nativePrepareInfo instanceof ATNativePrepareExInfo) {
            ((ATNativePrepareExInfo)nativePrepareInfo).setCreativeClickViewList(customClickViews);
        }
        return frameLayout;
    }

    private void initDislikeView(ViewInfo.INFO dislikeInfoView) {
        if (this.mDislikeView == null) {
            this.mDislikeView = new ImageView((Context)this.mActivity);
            this.mDislikeView.setImageResource(CommonUtil.getResId((Context)this.mActivity, "btn_close", "drawable"));
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(dislikeInfoView.mWidth, dislikeInfoView.mHeight);
        layoutParams.leftMargin = dislikeInfoView.mX;
        layoutParams.topMargin = dislikeInfoView.mY;
        if (!TextUtils.isEmpty((CharSequence)dislikeInfoView.bgcolor)) {
            this.mDislikeView.setBackgroundColor(Color.parseColor((String)dislikeInfoView.bgcolor));
        }
        this.mDislikeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void dealWithClick(View view, boolean isCustomClick, List<View> clickViews, List<View> customClickViews, String name) {
        if (view == null) {
            return;
        }
        if ((this.mNetworkType == 8 || this.mNetworkType == 22) && isCustomClick) {
            MsgTools.printMsg("add customClick ----> " + name);
            customClickViews.add(view);
            return;
        }
        MsgTools.printMsg("add click ----> " + name);
        clickViews.add(view);
    }

    private View createElementsView(ViewInfo.INFO elementsView, ATAdAppInfo atAdAppInfo) {
        if (elementsView == null || atAdAppInfo == null) {
            MsgTools.printMsg("createElementsView ----> " + elementsView + ", " + atAdAppInfo);
            return null;
        }
        String appVersion = atAdAppInfo.getAppVersion();
        String publisher = atAdAppInfo.getPublisher();
        String appPermissonUrl = atAdAppInfo.getAppPermissonUrl();
        String appPrivacyUrl = atAdAppInfo.getAppPrivacyUrl();
        String functionUrl = atAdAppInfo.getFunctionUrl();
        LinearLayout linearLayout = new LinearLayout((Context)this.mActivity);
        linearLayout.setOrientation(0);
        if (!TextUtils.isEmpty((CharSequence)functionUrl)) {
            TextView functionView = new TextView((Context)this.mActivity);
            this.setupElementView(elementsView, "function", functionView, "\u529f\u80fd");
            this.setOpenUrlClickListener((View)functionView, functionUrl);
            linearLayout.addView((View)functionView);
        }
        if (!TextUtils.isEmpty((CharSequence)appPrivacyUrl)) {
            TextView privacyView = new TextView((Context)this.mActivity);
            this.setupElementView(elementsView, "privacy", privacyView, "\u9690\u79c1");
            this.setOpenUrlClickListener((View)privacyView, appPrivacyUrl);
            linearLayout.addView((View)privacyView);
        }
        if (!TextUtils.isEmpty((CharSequence)appPermissonUrl)) {
            TextView permissionView = new TextView((Context)this.mActivity);
            this.setupElementView(elementsView, "permission", permissionView, "\u6743\u9650");
            this.setOpenUrlClickListener((View)permissionView, appPermissonUrl);
            linearLayout.addView((View)permissionView);
        }
        if (!TextUtils.isEmpty((CharSequence)publisher)) {
            TextView publisherView = new TextView((Context)this.mActivity);
            this.setupElementView(elementsView, "publisher", publisherView, publisher);
            linearLayout.addView((View)publisherView);
        }
        if (!TextUtils.isEmpty((CharSequence)appVersion)) {
            TextView appVersionView = new TextView((Context)this.mActivity);
            this.setupElementView(elementsView, "appVersion", appVersionView, "v" + appVersion);
            linearLayout.addView((View)appVersionView);
        }
        if (linearLayout.getChildCount() > 0) {
            return linearLayout;
        }
        return null;
    }

    private void setupElementView(ViewInfo.INFO elementsView, String tag, TextView view, String text) {
        try {
            view.setTextColor(Color.parseColor((String)elementsView.textcolor));
            view.setTextSize((float)elementsView.textSize);
            MsgTools.printMsg(tag + "----> " + text);
            view.setText((CharSequence)text);
            view.setSingleLine();
            view.setMaxEms(15);
            view.setEllipsize(TextUtils.TruncateAt.END);
            int padding = CommonUtil.dip2px((Context)this.mActivity, 2.0f);
            view.setPadding(padding, padding, padding, padding);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.gravity = 16;
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void setOpenUrlClickListener(View view, final String url) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    MsgTools.printMsg("open url: " + url);
                    Intent intent = new Intent((Context)SelfRenderViewUtil.this.mActivity, SimpleWebViewActivity.class);
                    intent.putExtra("extra_url", url);
                    intent.addFlags(0x10000000);
                    SelfRenderViewUtil.this.mActivity.startActivity(intent);
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
            }
        });
    }
}

