/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.nativead;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdSourceStatusListener;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.ATEventInterface;
import com.anythink.core.api.ATSDK;
import com.anythink.core.api.AdError;
import com.anythink.nativead.api.ATNative;
import com.anythink.nativead.api.ATNativeAdView;
import com.anythink.nativead.api.ATNativeDislikeListener;
import com.anythink.nativead.api.ATNativeEventListener;
import com.anythink.nativead.api.ATNativeNetworkListener;
import com.anythink.nativead.api.ATNativePrepareExInfo;
import com.anythink.nativead.api.ATNativePrepareInfo;
import com.anythink.nativead.api.NativeAd;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.download.DownloadHelper;
import com.anythink.unitybridge.nativead.NativeListener;
import com.anythink.unitybridge.nativead.SelfRenderViewUtil;
import com.anythink.unitybridge.nativead.ViewInfo;
import com.anythink.unitybridge.utils.CommonUtil;
import com.anythink.unitybridge.utils.TaskManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeHelper {
    public static final String TAG = "AT_android_unity3d";
    NativeListener mListener;
    Activity mActivity;
    String mPlacementId;
    ATNativeAdView mATNativeAdView;
    ATNative mATNative;
    ImageView mDislikeView;
    ATNativePrepareInfo mNativePrepareInfo;
    NativeAd mNativeAd;
    ViewInfo pViewInfo;
    static List<ViewInfo> currViewInfo = new ArrayList<ViewInfo>();

    public NativeHelper(NativeListener pListener) {
        if (pListener == null) {
            Log.e((String)TAG, (String)"Listener == null");
        }
        this.mListener = pListener;
        this.mActivity = UnityPluginUtils.getActivity("NativeHelper");
        this.mPlacementId = "";
    }

    public void initNative(String placementId) {
        MsgTools.printMsg("initNative " + placementId);
        this.mPlacementId = placementId;
        this.mATNative = new ATNative((Context)this.mActivity, placementId, new ATNativeNetworkListener(){

            public void onNativeAdLoaded() {
                MsgTools.printMsg("onNativeAdLoaded: " + NativeHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onNativeAdLoaded(NativeHelper.this.mPlacementId);
                            }
                        }
                    }
                });
            }

            public void onNativeAdLoadFail(final AdError pAdError) {
                MsgTools.printMsg("onNativeAdLoadFail: " + NativeHelper.this.mPlacementId + ", " + pAdError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onNativeAdLoadFail(NativeHelper.this.mPlacementId, pAdError.getCode(), pAdError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }
        });
        this.mATNative.setAdSourceStatusListener(new ATAdSourceStatusListener(){

            public void onAdSourceBiddingAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingAttempt: " + NativeHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onAdSourceBiddingAttempt(NativeHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingFilled: " + NativeHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onAdSourceBiddingFilled(NativeHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceBiddingFail: " + NativeHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onAdSourceBiddingFail(NativeHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onAdSourceAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceAttemp: " + NativeHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onAdSourceAttempt(NativeHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceLoadFilled: " + NativeHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onAdSourceLoadFilled(NativeHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceLoadFail: " + NativeHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (NativeHelper.this.mListener != null) {
                            NativeHelper nativeHelper = NativeHelper.this;
                            synchronized (nativeHelper) {
                                NativeHelper.this.mListener.onAdSourceLoadFail(NativeHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }
        });
        MsgTools.printMsg("initNative 2 " + this.mPlacementId);
    }

    public void loadNative(final String localExtra) {
        MsgTools.printMsg("loadNative: " + this.mPlacementId + ".localExtra: " + localExtra);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (NativeHelper.this.mATNative == null) {
                    Log.e((String)NativeHelper.TAG, (String)"you must call initNative first");
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (NativeHelper.this.mListener != null) {
                                NativeHelper nativeHelper = NativeHelper.this;
                                synchronized (nativeHelper) {
                                    NativeHelper.this.mListener.onNativeAdLoadFail(NativeHelper.this.mPlacementId, "-1", "you must call initNative first");
                                }
                            }
                        }
                    });
                    return;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                try {
                    JSONObject _jsonObject = new JSONObject(localExtra);
                    Iterator _iterator = _jsonObject.keys();
                    while (_iterator.hasNext()) {
                        String native_ad_size;
                        String key = (String)_iterator.next();
                        map.put(key, _jsonObject.get(key));
                        if (TextUtils.equals((CharSequence)"native_ad_size", (CharSequence)key) && !TextUtils.isEmpty((CharSequence)(native_ad_size = _jsonObject.optString(key)))) {
                            String[] sizes = native_ad_size.split("x");
                            map.put("key_width", sizes[0]);
                            map.put("key_height", sizes[1]);
                        }
                        if (!TextUtils.equals((CharSequence)"AdaptiveHeight", (CharSequence)key) || !TextUtils.equals((CharSequence)"1", (CharSequence)_jsonObject.optString(key))) continue;
                        map.put("tt_image_height", 0);
                        map.put("gdtad_height", -2);
                    }
                    NativeHelper.this.mATNative.setLocalExtra(map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                NativeHelper.this.mATNative.makeAdRequest();
            }
        });
    }

    private ViewInfo parseViewInfo(String showConfig) {
        this.pViewInfo = new ViewInfo();
        if (TextUtils.isEmpty((CharSequence)showConfig)) {
            Log.e((String)TAG, (String)"showConfig is null ,user defult");
            this.pViewInfo = ViewInfo.createDefualtView(this.mActivity);
        }
        try {
            String tempjson;
            JSONObject _jsonObject = new JSONObject(showConfig);
            if (_jsonObject.has("parent")) {
                tempjson = _jsonObject.getString("parent");
                MsgTools.printMsg("parent----> " + tempjson);
                this.pViewInfo.rootView = this.pViewInfo.parseINFO(tempjson, "parent", 0, 0);
            }
            if (_jsonObject.has("appIcon")) {
                tempjson = _jsonObject.getString("appIcon");
                MsgTools.printMsg("appIcon----> " + tempjson);
                this.pViewInfo.IconView = this.pViewInfo.parseINFO(tempjson, "appIcon", 0, 0);
            }
            if (_jsonObject.has("mainImage")) {
                tempjson = _jsonObject.getString("mainImage");
                MsgTools.printMsg("mainImage----> " + tempjson);
                this.pViewInfo.imgMainView = this.pViewInfo.parseINFO(tempjson, "mainImage", 0, 0);
            }
            if (_jsonObject.has("title")) {
                tempjson = _jsonObject.getString("title");
                MsgTools.printMsg("title----> " + tempjson);
                this.pViewInfo.titleView = this.pViewInfo.parseINFO(tempjson, "title", 0, 0);
            }
            if (_jsonObject.has("desc")) {
                tempjson = _jsonObject.getString("desc");
                MsgTools.printMsg("desc----> " + tempjson);
                this.pViewInfo.descView = this.pViewInfo.parseINFO(tempjson, "desc", 0, 0);
            }
            if (_jsonObject.has("adLogo")) {
                tempjson = _jsonObject.getString("adLogo");
                MsgTools.printMsg("adLogo----> " + tempjson);
                this.pViewInfo.adLogoView = this.pViewInfo.parseINFO(tempjson, "adLogo", 0, 0);
            }
            if (_jsonObject.has("cta")) {
                tempjson = _jsonObject.getString("cta");
                MsgTools.printMsg("cta----> " + tempjson);
                this.pViewInfo.ctaView = this.pViewInfo.parseINFO(tempjson, "cta", 0, 0);
            }
            if (_jsonObject.has("dislike")) {
                tempjson = _jsonObject.getString("dislike");
                MsgTools.printMsg("dislike----> " + tempjson);
                this.pViewInfo.dislikeView = this.pViewInfo.parseINFO(tempjson, "dislike", 0, 0);
            }
            if (_jsonObject.has("elements")) {
                tempjson = _jsonObject.getString("elements");
                MsgTools.printMsg("elements----> " + tempjson);
                this.pViewInfo.elementsView = this.pViewInfo.parseINFO(tempjson, "elements", 0, 0);
            } else {
                ViewInfo.INFO defaultViewInfoForElements = this.pViewInfo.getDefaultViewInfoForElements(this.pViewInfo.rootView);
                MsgTools.printMsg("elements----> default config: " + defaultViewInfoForElements);
                this.pViewInfo.elementsView = defaultViewInfoForElements;
            }
        }
        catch (JSONException pE) {
            pE.printStackTrace();
        }
        return this.pViewInfo;
    }

    public void show(final String showConfig, final String jsonMap) {
        MsgTools.printMsg("show: " + this.mPlacementId + ", showConfig: " + showConfig + ", jsonMap: " + jsonMap);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                NativeAd nativeAd;
                String scenario = "";
                boolean isExpressAdaptiveHeight = false;
                String parentPosition = "";
                String position = "";
                int parentGravity = -1;
                if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
                    try {
                        JSONObject jsonObject = new JSONObject(jsonMap);
                        if (jsonObject.has("Scenario")) {
                            scenario = jsonObject.optString("Scenario");
                        }
                        if (jsonObject.has("AdaptiveHeight")) {
                            isExpressAdaptiveHeight = TextUtils.equals((CharSequence)jsonObject.optString("AdaptiveHeight"), (CharSequence)"1");
                        }
                        if (jsonObject.has("Position")) {
                            position = jsonObject.optString("Position");
                            if (TextUtils.equals((CharSequence)"Bottom", (CharSequence)position)) {
                                parentGravity = 81;
                            } else if (TextUtils.equals((CharSequence)"Top", (CharSequence)position)) {
                                parentGravity = 49;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((nativeAd = !TextUtils.isEmpty((CharSequence)scenario) ? NativeHelper.this.mATNative.getNativeAd(scenario) : NativeHelper.this.mATNative.getNativeAd()) != null) {
                    MsgTools.printMsg("nativeAd:" + NativeHelper.this.mPlacementId + ", scenario: " + scenario + ", isExpressAdaptiveHeight: " + isExpressAdaptiveHeight + ", position: " + position);
                    NativeHelper.this.pViewInfo = NativeHelper.this.parseViewInfo(showConfig);
                    currViewInfo.add(NativeHelper.this.pViewInfo);
                    NativeHelper.this.mNativeAd = nativeAd;
                    nativeAd.setNativeEventListener(new ATNativeEventListener(){

                        public void onAdImpressed(ATNativeAdView view, final ATAdInfo adInfo) {
                            MsgTools.printMsg("onAdImpressed: " + NativeHelper.this.mPlacementId);
                            TaskManager.getInstance().run_proxy(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (NativeHelper.this.mListener != null) {
                                        NativeHelper nativeHelper = NativeHelper.this;
                                        synchronized (nativeHelper) {
                                            NativeHelper.this.mListener.onAdImpressed(NativeHelper.this.mPlacementId, adInfo.toString());
                                        }
                                    }
                                }
                            });
                        }

                        public void onAdClicked(ATNativeAdView view, final ATAdInfo adInfo) {
                            MsgTools.printMsg("onAdClicked: " + NativeHelper.this.mPlacementId);
                            TaskManager.getInstance().run_proxy(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (NativeHelper.this.mListener != null) {
                                        NativeHelper nativeHelper = NativeHelper.this;
                                        synchronized (nativeHelper) {
                                            NativeHelper.this.mListener.onAdClicked(NativeHelper.this.mPlacementId, adInfo.toString());
                                        }
                                    }
                                }
                            });
                        }

                        public void onAdVideoStart(ATNativeAdView view) {
                            MsgTools.printMsg("onAdVideoStart: " + NativeHelper.this.mPlacementId);
                            TaskManager.getInstance().run_proxy(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (NativeHelper.this.mListener != null) {
                                        NativeHelper nativeHelper = NativeHelper.this;
                                        synchronized (nativeHelper) {
                                            NativeHelper.this.mListener.onAdVideoStart(NativeHelper.this.mPlacementId);
                                        }
                                    }
                                }
                            });
                        }

                        public void onAdVideoEnd(ATNativeAdView view) {
                            MsgTools.printMsg("onAdVideoEnd: " + NativeHelper.this.mPlacementId);
                            TaskManager.getInstance().run_proxy(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (NativeHelper.this.mListener != null) {
                                        NativeHelper nativeHelper = NativeHelper.this;
                                        synchronized (nativeHelper) {
                                            NativeHelper.this.mListener.onAdVideoEnd(NativeHelper.this.mPlacementId);
                                        }
                                    }
                                }
                            });
                        }

                        public void onAdVideoProgress(ATNativeAdView view, final int progress) {
                            MsgTools.printMsg("onAdVideoProgress: " + NativeHelper.this.mPlacementId);
                            TaskManager.getInstance().run_proxy(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (NativeHelper.this.mListener != null) {
                                        NativeHelper nativeHelper = NativeHelper.this;
                                        synchronized (nativeHelper) {
                                            NativeHelper.this.mListener.onAdVideoProgress(NativeHelper.this.mPlacementId, progress);
                                        }
                                    }
                                }
                            });
                        }
                    });
                    nativeAd.setDislikeCallbackListener(new ATNativeDislikeListener(){

                        public void onAdCloseButtonClick(ATNativeAdView atNativeAdView, final ATAdInfo atAdInfo) {
                            MsgTools.printMsg("onAdCloseButtonClick: " + NativeHelper.this.mPlacementId);
                            TaskManager.getInstance().run_proxy(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (NativeHelper.this.mListener != null) {
                                        NativeHelper nativeHelper = NativeHelper.this;
                                        synchronized (nativeHelper) {
                                            NativeHelper.this.mListener.onAdCloseButtonClicked(NativeHelper.this.mPlacementId, atAdInfo.toString());
                                        }
                                    }
                                }
                            });
                        }
                    });
                    try {
                        if (ATSDK.isCnSDK()) {
                            nativeAd.setAdDownloadListener((ATEventInterface)DownloadHelper.getDownloadListener(NativeHelper.this.mPlacementId));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (isExpressAdaptiveHeight && NativeHelper.this.pViewInfo.rootView != null) {
                        MsgTools.printMsg("nativeAd: rootView, use adaptive height for express");
                        NativeHelper.this.pViewInfo.rootView.mHeight = -2;
                    }
                    if (NativeHelper.this.mATNativeAdView == null) {
                        NativeHelper.this.mATNativeAdView = new ATNativeAdView((Context)NativeHelper.this.mActivity);
                    } else {
                        NativeHelper.this.mATNativeAdView.removeAllViews();
                    }
                    NativeHelper.this.mNativePrepareInfo = null;
                    try {
                        if (nativeAd.isNativeExpress()) {
                            nativeAd.renderAdContainer(NativeHelper.this.mATNativeAdView, null);
                        } else {
                            SelfRenderViewUtil selfRenderViewUtil = new SelfRenderViewUtil(NativeHelper.this.mActivity, NativeHelper.this.pViewInfo, NativeHelper.this.mNativeAd.getAdInfo().getNetworkFirmId());
                            NativeHelper.this.mNativePrepareInfo = new ATNativePrepareExInfo();
                            FrameLayout selfRenderView = selfRenderViewUtil.bindSelfRenderView(NativeHelper.this.mNativeAd.getAdMaterial(), NativeHelper.this.mNativePrepareInfo, NativeHelper.this.pViewInfo);
                            NativeHelper.this.mNativeAd.renderAdContainer(NativeHelper.this.mATNativeAdView, (View)selfRenderView);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    NativeHelper.this.mNativeAd.prepare(NativeHelper.this.mATNativeAdView, NativeHelper.this.mNativePrepareInfo);
                    ViewInfo.addNativeAdView2Activity(NativeHelper.this.mActivity, NativeHelper.this.pViewInfo, NativeHelper.this.mATNativeAdView, nativeAd.isNativeExpress() ? parentGravity : -1);
                } else {
                    MsgTools.printMsg("No Cache:" + NativeHelper.this.mPlacementId);
                }
            }
        });
    }

    private void initDislikeView(ViewInfo.INFO dislikeView) {
        if (this.mDislikeView == null) {
            this.mDislikeView = new ImageView((Context)this.mActivity);
            this.mDislikeView.setImageResource(CommonUtil.getResId((Context)this.mActivity, "btn_close", "drawable"));
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(dislikeView.mWidth, dislikeView.mHeight);
        layoutParams.leftMargin = dislikeView.mX;
        layoutParams.topMargin = dislikeView.mY;
        if (!TextUtils.isEmpty((CharSequence)dislikeView.bgcolor)) {
            this.mDislikeView.setBackgroundColor(Color.parseColor((String)dislikeView.bgcolor));
        }
        this.mDislikeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public boolean isAdReady() {
        MsgTools.printMsg("isAdReady:" + this.mPlacementId);
        ATAdStatusInfo adStatusInfo = this.mATNative.checkAdStatus();
        boolean ready = adStatusInfo.isReady();
        MsgTools.printMsg("isAdReady:" + this.mPlacementId + ", " + ready);
        return ready;
    }

    public void clean() {
        if (this.mATNative != null) {
            // empty if block
        }
    }

    public void cleanView() {
        MsgTools.printMsg("cleanView:" + this.mPlacementId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (ViewInfo tempinfo : currViewInfo) {
                        ViewGroup _viewGroup;
                        if (NativeHelper.this.mATNativeAdView == null || (_viewGroup = (ViewGroup)NativeHelper.this.mATNativeAdView.getParent()) == null) continue;
                        _viewGroup.removeView((View)NativeHelper.this.mATNativeAdView);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void onPause() {
        if (this.mNativeAd != null) {
            this.mNativeAd.onPause();
        }
    }

    public void onResume() {
        if (this.mNativeAd != null) {
            this.mNativeAd.onResume();
        }
    }

    public String checkAdStatus() {
        MsgTools.printMsg("checkAdStatus:" + this.mPlacementId);
        if (this.mATNative != null) {
            ATAdStatusInfo atAdStatusInfo = this.mATNative.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                try {
                    if (atTopAdInfo != null) {
                        jsonObject.put("adInfo", (Object)new JSONObject(atTopAdInfo.toString()));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                MsgTools.printMsg("checkAdStatus: result = " + jsonObject);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String getValidAdCaches() {
        MsgTools.printMsg("getValidAdCaches:" + this.mPlacementId);
        if (this.mATNative != null) {
            JSONArray jsonArray = new JSONArray();
            List vaildAds = this.mATNative.checkValidAdCaches();
            if (vaildAds == null) {
                return "";
            }
            int size = vaildAds.size();
            for (int i = 0; i < size; ++i) {
                try {
                    jsonArray.put((Object)new JSONObject(((ATAdInfo)vaildAds.get(i)).toString()));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return jsonArray.toString();
        }
        return "";
    }

    public void entryAdScenario(final String scenarioId) {
        MsgTools.printMsg("entryAdScenario start: " + this.mPlacementId + ", scenarioId: " + scenarioId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)NativeHelper.this.mPlacementId)) {
                    ATNative.entryAdScenario((String)NativeHelper.this.mPlacementId, (String)scenarioId);
                } else {
                    MsgTools.printMsg("entryAdScenario error, you must call initNative first " + NativeHelper.this.mPlacementId);
                }
            }
        });
    }
}

