/*
 * Decompiled with CFR 0.152.
 */
package com.anythink.unitybridge.banner;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.anythink.banner.api.ATBannerListener;
import com.anythink.banner.api.ATBannerView;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdSourceStatusListener;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.ATEventInterface;
import com.anythink.core.api.ATSDK;
import com.anythink.core.api.AdError;
import com.anythink.unitybridge.MsgTools;
import com.anythink.unitybridge.UnityPluginUtils;
import com.anythink.unitybridge.banner.BannerListener;
import com.anythink.unitybridge.download.DownloadHelper;
import com.anythink.unitybridge.utils.CommonUtil;
import com.anythink.unitybridge.utils.Const;
import com.anythink.unitybridge.utils.TaskManager;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BannerHelper {
    private static final String kATBannerAdShowingPisitionTop = "top";
    private static final String kATBannerAdShowingPisitionBottom = "bottom";
    private final String TAG = this.getClass().getSimpleName();
    BannerListener mListener;
    Activity mActivity;
    String mPlacementId;
    ATBannerView mBannerView;

    public BannerHelper(BannerListener listener) {
        MsgTools.printMsg("BannerHelper: " + this);
        if (listener == null) {
            MsgTools.printMsg("Listener == null");
        }
        this.mListener = listener;
        this.mActivity = UnityPluginUtils.getActivity("BannerHelper");
        this.mPlacementId = "";
    }

    public void initBanner(String placementId) {
        MsgTools.printMsg("initBanner 1: " + placementId);
        this.mPlacementId = placementId;
        this.mBannerView = new ATBannerView((Context)this.mActivity);
        this.mBannerView.setPlacementId(this.mPlacementId);
        MsgTools.printMsg("initBanner 2: " + this.mPlacementId);
        this.mBannerView.setBannerAdListener(new ATBannerListener(){

            public void onBannerLoaded() {
                MsgTools.printMsg("onBannerLoaded: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onBannerLoaded(BannerHelper.this.mPlacementId);
                            }
                        }
                    }
                });
            }

            public void onBannerFailed(final AdError adError) {
                MsgTools.printMsg("onBannerFailed: " + BannerHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onBannerFailed(BannerHelper.this.mPlacementId, adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onBannerClicked(final ATAdInfo adInfo) {
                MsgTools.printMsg("onBannerClicked: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onBannerClicked(BannerHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onBannerShow(final ATAdInfo adInfo) {
                MsgTools.printMsg("onBannerShow: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onBannerShow(BannerHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onBannerClose(final ATAdInfo adInfo) {
                MsgTools.printMsg("onBannerClose: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onBannerClose(BannerHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onBannerAutoRefreshed(final ATAdInfo adInfo) {
                MsgTools.printMsg("onBannerAutoRefreshed: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onBannerAutoRefreshed(BannerHelper.this.mPlacementId, adInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onBannerAutoRefreshFail(final AdError adError) {
                MsgTools.printMsg("onBannerAutoRefreshFail: " + BannerHelper.this.mPlacementId + ", " + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onBannerAutoRefreshFail(BannerHelper.this.mPlacementId, adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }
        });
        this.mBannerView.setAdSourceStatusListener(new ATAdSourceStatusListener(){

            public void onAdSourceBiddingAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingAttempt: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onAdSourceBiddingAttempt(BannerHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceBiddingFilled: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onAdSourceBiddingFilled(BannerHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceBiddingFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceBiddingFail: " + BannerHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onAdSourceBiddingFail(BannerHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }

            public void onAdSourceAttempt(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceAttemp: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onAdSourceAttempt(BannerHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFilled(final ATAdInfo atAdInfo) {
                MsgTools.printMsg("onAdSourceLoadFilled: " + BannerHelper.this.mPlacementId);
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onAdSourceLoadFilled(BannerHelper.this.mPlacementId, atAdInfo.toString());
                            }
                        }
                    }
                });
            }

            public void onAdSourceLoadFail(final ATAdInfo atAdInfo, final AdError adError) {
                MsgTools.printMsg("onAdSourceLoadFail: " + BannerHelper.this.mPlacementId + "," + adError.getFullErrorInfo());
                TaskManager.getInstance().run_proxy(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (BannerHelper.this.mListener != null) {
                            BannerHelper bannerHelper = BannerHelper.this;
                            synchronized (bannerHelper) {
                                BannerHelper.this.mListener.onAdSourceLoadFail(BannerHelper.this.mPlacementId, atAdInfo.toString(), adError.getCode(), adError.getFullErrorInfo());
                            }
                        }
                    }
                });
            }
        });
        MsgTools.printMsg("initBanner 3: " + this.mPlacementId);
        try {
            if (ATSDK.isCnSDK()) {
                this.mBannerView.setAdDownloadListener((ATEventInterface)DownloadHelper.getDownloadListener(this.mPlacementId));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadBannerAd(final String jsonMap) {
        MsgTools.printMsg("loadBanner: " + this.mPlacementId + ", jsonMap: " + jsonMap);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
                        try {
                            JSONObject jsonObject = new JSONObject(jsonMap);
                            if (jsonObject.has("banner_ad_size")) {
                                String banner_ad_size = jsonObject.getString("banner_ad_size");
                                MsgTools.printMsg("banner_ad_size----> " + banner_ad_size);
                                boolean usePixel = true;
                                if (jsonObject.has("uses_pixel")) {
                                    usePixel = jsonObject.getBoolean("uses_pixel");
                                }
                                MsgTools.printMsg("usePixel----> " + usePixel);
                                if (BannerHelper.this.mBannerView != null && !TextUtils.isEmpty((CharSequence)banner_ad_size)) {
                                    String[] size = banner_ad_size.split("x");
                                    try {
                                        int width = Integer.parseInt(size[0]);
                                        int height = Integer.parseInt(size[1]);
                                        MsgTools.printMsg("loadBannerAd, banner_ad_size" + banner_ad_size);
                                        if (!usePixel) {
                                            width = CommonUtil.dip2px(BannerHelper.this.mBannerView.getContext(), width);
                                            height = CommonUtil.dip2px(BannerHelper.this.mBannerView.getContext(), height);
                                        }
                                        if (BannerHelper.this.mBannerView.getLayoutParams() == null) {
                                            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, height);
                                            BannerHelper.this.mBannerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                                        } else {
                                            BannerHelper.this.mBannerView.getLayoutParams().width = width;
                                            BannerHelper.this.mBannerView.getLayoutParams().height = height;
                                        }
                                        if (width > 0 && !jsonObject.has("key_width")) {
                                            jsonObject.put("key_width", width);
                                        }
                                        if (height > 0 && !jsonObject.has("key_height")) {
                                            jsonObject.put("key_height", height);
                                        }
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (jsonObject.has("inline_adaptive_width")) {
                                String adaptive_width = jsonObject.getString("inline_adaptive_width");
                                MsgTools.printMsg("inline_adaptive_width----> " + adaptive_width);
                                jsonObject.put("adaptive_width", (Object)adaptive_width);
                            }
                            if (jsonObject.has("inline_adaptive_orientation")) {
                                int adaptive_orientation = jsonObject.getInt("inline_adaptive_orientation");
                                MsgTools.printMsg("inline_adaptive_orientation----> " + adaptive_orientation);
                                jsonObject.put("adaptive_orientation", adaptive_orientation);
                            }
                            if (!jsonObject.has("adaptive_type")) {
                                jsonObject.put("adaptive_type", 0);
                            }
                            HashMap<String, Object> localExtra = new HashMap<String, Object>();
                            Const.fillMapFromJsonObject(localExtra, jsonObject);
                            BannerHelper.this.mBannerView.setLocalExtra(localExtra);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    BannerHelper.this.mBannerView.loadAd();
                } else {
                    MsgTools.printMsg("loadBannerAd error, you must call initBanner first " + BannerHelper.this.mPlacementId);
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (BannerHelper.this.mListener != null) {
                                BannerHelper bannerHelper = BannerHelper.this;
                                synchronized (bannerHelper) {
                                    BannerHelper.this.mListener.onBannerFailed(BannerHelper.this.mPlacementId, "-1", "you must call initBanner first");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void loadBannerAd() {
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    BannerHelper.this.mBannerView.loadAd();
                } else {
                    MsgTools.printMsg("loadBannerAd error, you must call initBanner first " + BannerHelper.this.mPlacementId);
                    TaskManager.getInstance().run_proxy(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (BannerHelper.this.mListener != null) {
                                BannerHelper bannerHelper = BannerHelper.this;
                                synchronized (bannerHelper) {
                                    BannerHelper.this.mListener.onBannerFailed(BannerHelper.this.mPlacementId, "-1", "you must call initBanner first");
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void showBannerAd(int x, int y, int width, int height, String jsonMap) {
        this.showBannerAd(x, y, width, height, jsonMap, true);
    }

    public void showBannerAd(final int x, final int y, final int width, final int height, final String jsonMap, final boolean usePixel) {
        MsgTools.printMsg("showBanner: " + this.mPlacementId + ", jsonMap: " + jsonMap);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    FrameLayout.LayoutParams layoutParams = null;
                    if (usePixel) {
                        layoutParams = new FrameLayout.LayoutParams(width, height);
                        layoutParams.leftMargin = x;
                        layoutParams.topMargin = y;
                    } else {
                        layoutParams = new FrameLayout.LayoutParams(CommonUtil.dip2px((Context)BannerHelper.this.mActivity, width), CommonUtil.dip2px((Context)BannerHelper.this.mActivity, height));
                        layoutParams.leftMargin = CommonUtil.dip2px((Context)BannerHelper.this.mActivity, x);
                        layoutParams.topMargin = CommonUtil.dip2px((Context)BannerHelper.this.mActivity, y);
                    }
                    if (BannerHelper.this.mBannerView.getParent() != null) {
                        ((ViewGroup)BannerHelper.this.mBannerView.getParent()).removeView((View)BannerHelper.this.mBannerView);
                    }
                    BannerHelper.this.setConfig(jsonMap);
                    BannerHelper.this.mBannerView.setVisibility(0);
                    BannerHelper.this.mActivity.addContentView((View)BannerHelper.this.mBannerView, (ViewGroup.LayoutParams)layoutParams);
                } else {
                    MsgTools.printMsg("show error, you must call initBanner first " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public void showBannerAd(final String position, final String jsonMap) {
        MsgTools.printMsg("showBanner by position: " + this.mPlacementId + ", jsonMap: " + jsonMap);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    int width = 0;
                    int height = 0;
                    if (BannerHelper.this.mBannerView.getLayoutParams() != null) {
                        width = BannerHelper.this.mBannerView.getLayoutParams().width;
                        height = BannerHelper.this.mBannerView.getLayoutParams().height;
                    }
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
                    layoutParams.gravity = BannerHelper.kATBannerAdShowingPisitionTop.equals(position) ? 49 : 81;
                    if (BannerHelper.this.mBannerView.getParent() != null) {
                        ((ViewGroup)BannerHelper.this.mBannerView.getParent()).removeView((View)BannerHelper.this.mBannerView);
                    }
                    BannerHelper.this.setConfig(jsonMap);
                    BannerHelper.this.mBannerView.setVisibility(0);
                    BannerHelper.this.mActivity.addContentView((View)BannerHelper.this.mBannerView, (ViewGroup.LayoutParams)layoutParams);
                } else {
                    MsgTools.printMsg("show error, you must call initBanner first " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    private void setConfig(String jsonMap) {
        String scenario = "";
        if (!TextUtils.isEmpty((CharSequence)jsonMap)) {
            try {
                JSONObject jsonObject = new JSONObject(jsonMap);
                if (jsonObject.has("Scenario")) {
                    scenario = jsonObject.optString("Scenario");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MsgTools.printMsg("showBanner: " + this.mPlacementId + ", scenario: " + scenario);
        if (!TextUtils.isEmpty((CharSequence)scenario)) {
            this.mBannerView.setScenario(scenario);
        }
    }

    public void showBannerAd() {
        MsgTools.printMsg("showBanner without ATRect: " + this.mPlacementId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    BannerHelper.this.mBannerView.setVisibility(0);
                } else {
                    MsgTools.printMsg("show error, you must call initBanner first " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public void hideBannerAd() {
        MsgTools.printMsg("hideBannerAd: " + this.mPlacementId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null) {
                    BannerHelper.this.mBannerView.setVisibility(8);
                } else {
                    MsgTools.printMsg("hideBannerAd error, you must call initBanner first " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public void cleanBannerAd() {
        MsgTools.printMsg("clean: " + this.mPlacementId);
        UnityPluginUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (BannerHelper.this.mBannerView != null && BannerHelper.this.mBannerView.getParent() != null) {
                    MsgTools.printMsg("clean2: " + BannerHelper.this.mPlacementId);
                    ViewParent viewParent = BannerHelper.this.mBannerView.getParent();
                    ((ViewGroup)viewParent).removeView((View)BannerHelper.this.mBannerView);
                } else {
                    MsgTools.printMsg("clean3: no banner clean " + BannerHelper.this.mPlacementId);
                }
            }
        });
    }

    public String checkAdStatus() {
        MsgTools.printMsg("checkAdStatus: " + this.mPlacementId);
        if (this.mBannerView != null) {
            ATAdStatusInfo atAdStatusInfo = this.mBannerView.checkAdStatus();
            boolean loading = atAdStatusInfo.isLoading();
            boolean ready = atAdStatusInfo.isReady();
            ATAdInfo atTopAdInfo = atAdStatusInfo.getATTopAdInfo();
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("isLoading", loading);
                jsonObject.put("isReady", ready);
                try {
                    if (atTopAdInfo != null) {
                        jsonObject.put("adInfo", (Object)new JSONObject(atTopAdInfo.toString()));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                MsgTools.printMsg("checkAdStatus: result = " + jsonObject);
                return jsonObject.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String getValidAdCaches() {
        MsgTools.printMsg("getValidAdCaches:" + this.mPlacementId);
        if (this.mBannerView != null) {
            JSONArray jsonArray = new JSONArray();
            List vaildAds = this.mBannerView.checkValidAdCaches();
            if (vaildAds == null) {
                return "";
            }
            int size = vaildAds.size();
            for (int i = 0; i < size; ++i) {
                try {
                    jsonArray.put((Object)new JSONObject(((ATAdInfo)vaildAds.get(i)).toString()));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return jsonArray.toString();
        }
        return "";
    }
}

