/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.xsj.crasheye.Crasheye;
import com.xsj.crasheye.CrasheyeLogLevel;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.util.EnumStateStatus;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

public class Utils {
    private static final int Verbose = 10;
    private static final int Debug = 20;
    private static final int Info = 30;
    private static final int Warning = 50;
    private static final int Error = 60;
    protected static final String CONNECTION = "connection";
    protected static final String STATE = "state";
    private static final String ENCRYPT_MAGIC = "^#*&";
    private static final byte[] ENCRYPT_KEY = new byte[]{18, 67, 31, 46, 18, 61, 45, 31, 46, 61, 67, 42};

    public static String getRandomSessionNumber() {
        String time = String.valueOf(System.currentTimeMillis());
        if (time == null) {
            return "";
        }
        if (time.isEmpty()) {
            return "";
        }
        if (time.length() < 8) {
            return time;
        }
        time = time.substring(time.length() - 8, time.length());
        return time;
    }

    public static String getScreenOrientation(Context gContext) {
        String rotation = "NA";
        if (gContext == null) {
            return rotation;
        }
        try {
            Display display = ((WindowManager)gContext.getSystemService("window")).getDefaultDisplay();
            if (display == null) {
                return rotation;
            }
            int orientation = display.getRotation();
            switch (orientation) {
                case 0: {
                    rotation = "Portrait";
                    break;
                }
                case 2: {
                    rotation = "PortraitUpsideDown";
                    break;
                }
                case 3: {
                    rotation = "LandscapeLeft";
                    break;
                }
                case 1: {
                    rotation = "LandscapeRight";
                }
            }
            return rotation;
        }
        catch (Exception ex) {
            Logger.logError(ex.getMessage());
            return rotation;
        }
    }

    public static String getScreenSize(Context gContext) {
        String strOutSize = "NA";
        if (gContext == null) {
            return strOutSize;
        }
        try {
            DisplayMetrics dm = gContext.getResources().getDisplayMetrics();
            if (dm == null) {
                return strOutSize;
            }
            int widthPixe = dm.widthPixels;
            int heightPixe = dm.heightPixels;
            strOutSize = String.format("%d * %d", widthPixe, heightPixe);
        }
        catch (Exception ex) {
            Logger.logError(ex.getMessage());
        }
        return strOutSize;
    }

    public static int convertLoggingLevelToInt(CrasheyeLogLevel level) {
        if (level.equals((Object)CrasheyeLogLevel.Debug)) {
            return 20;
        }
        if (level.equals((Object)CrasheyeLogLevel.Error)) {
            return 60;
        }
        if (level.equals((Object)CrasheyeLogLevel.Info)) {
            return 30;
        }
        if (level.equals((Object)CrasheyeLogLevel.Verbose)) {
            return 10;
        }
        if (level.equals((Object)CrasheyeLogLevel.Warning)) {
            return 50;
        }
        return 10;
    }

    @SuppressLint(value={"MissingPermission"})
    public static HashMap<String, String> getConnectionInfo(Context context) {
        HashMap<String, String> infoMap;
        block12: {
            infoMap = new HashMap<String, String>(2);
            infoMap.put(CONNECTION, "NA");
            infoMap.put(STATE, "NA");
            if (context == null) {
                if (Crasheye.DEBUG) {
                    Logger.logError("Context in getConnection is null!");
                }
            } else {
                try {
                    PackageManager packageManager = context.getPackageManager();
                    if (packageManager == null) {
                        if (Crasheye.DEBUG) {
                            Logger.logError("PackageManager in CheckNetworkConnection is null!");
                        }
                        break block12;
                    }
                    if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", Properties.APP_PACKAGE) != 0) break block12;
                    ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    try {
                        if (mConnectivityManager == null) break block12;
                        NetworkInfo info = mConnectivityManager.getActiveNetworkInfo();
                        if (info != null) {
                            if (info.getSubtypeName() == null || info.getSubtypeName().length() == 0) {
                                infoMap.put(CONNECTION, info.getTypeName());
                            } else {
                                infoMap.put(CONNECTION, info.getSubtypeName());
                            }
                            infoMap.put(STATE, info.getState().toString());
                            break block12;
                        }
                        infoMap.put(CONNECTION, "No connection");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        infoMap.put(CONNECTION, "No connection");
                    }
                }
                catch (Exception ex) {
                    Logger.logError(ex.getMessage());
                }
            }
        }
        return infoMap;
    }

    public static synchronized boolean shouldSendPing(Context ctx) {
        long minSessionTimeInMiliseconds;
        boolean shouldSendPing = true;
        long lastPing = Properties.lastPingTime;
        long timeNow = System.currentTimeMillis();
        shouldSendPing = timeNow - lastPing > (minSessionTimeInMiliseconds = (long)(Properties.RemoteSettingsProps.sessionTime * 1000));
        return shouldSendPing;
    }

    public static EnumStateStatus isGPSOn(Context gContext) {
        return EnumStateStatus.NA;
    }

    public static final String getTime() {
        String time = String.valueOf(System.currentTimeMillis());
        try {
            time = String.valueOf(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static final long getTimeForLong() {
        long time = System.currentTimeMillis();
        return time;
    }

    public static boolean checkForRoot() {
        String[] directories;
        boolean foundSU = false;
        for (String dir : directories = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"}) {
            File file = new File(dir + "su");
            if (!file.exists()) continue;
            foundSU = true;
            break;
        }
        return foundSU;
    }

    public static String MD5(String data) throws Exception {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.update(data.getBytes(), 0, data.length());
        return new BigInteger(1, m.digest()).toString(16);
    }

    public static String MD5(byte[] data) throws Exception {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.update(data, 0, data.length);
        return new BigInteger(1, m.digest()).toString(16);
    }

    public static String MD5(ByteBuffer data) throws Exception {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.update(data);
        return new BigInteger(1, m.digest()).toString(16);
    }

    public static final String getMilisFromStart() {
        long ms_from_start = 0L;
        ms_from_start = System.currentTimeMillis() - Properties.TIMESTAMP;
        return String.valueOf(ms_from_start);
    }

    public static final String getCarrier(Context context) {
        String carrier = "NA";
        return carrier;
    }

    public static String readFile(String filePath) throws Exception {
        if (filePath == null) {
            throw new IllegalArgumentException("filePath Argument is null");
        }
        StringBuilder sb1 = new StringBuilder();
        try (BufferedReader input = null;){
            input = new BufferedReader(new FileReader(filePath));
            String line = null;
            while ((line = input.readLine()) != null) {
                sb1.append(line);
                sb1.append('\n');
            }
            String string = sb1.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String filePath, String content) {
        if (filePath == null || content == null) {
            Logger.logError("Crasheye write file: filepath is null or content is null!");
            return;
        }
        BufferedWriter bWritter = null;
        try {
            bWritter = new BufferedWriter(new FileWriter(filePath));
            bWritter.append(content);
            bWritter.flush();
            bWritter.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (bWritter != null) {
                try {
                    bWritter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void deleteFile(String filePath) {
        if (filePath == null) {
            return;
        }
        try {
            File file = new File(filePath);
            Utils.deleteFile(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        try {
            file.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isRunningService(Context context) {
        if (context == null) {
            return false;
        }
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List appProcesses = activityManager.getRunningAppProcesses();
            String cProcessName = context.getApplicationInfo().packageName;
            if (cProcessName == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (appProcess.pid != android.os.Process.myPid() || !appProcess.processName.equals(cProcessName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] toByteArray(String filePath) {
        byte[] data = null;
        if (filePath == null) {
            throw new IllegalArgumentException("filePath Argument is null");
        }
        try {
            File file = new File(filePath);
            int size = (int)file.length();
            if (size == 0) {
                return null;
            }
            data = new byte[size];
            BufferedInputStream buf = null;
            buf = new BufferedInputStream(new FileInputStream(file));
            buf.read(data, 0, data.length);
            buf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return data;
    }

    public static final String readLogs() {
        String filter;
        int lines = Properties.LOG_MAX_LINES;
        if (lines < 0) {
            lines = 1000;
        }
        if ((filter = Properties.LOG_FILTER) == null) {
            filter = "";
        }
        StringBuilder log = new StringBuilder();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("logcat -d " + filter);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> linesList = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                linesList.add(line);
            }
            if (linesList.size() == 0) {
                return "You must add the android.permission.READ_LOGS permission to your manifest file!";
            }
            int start = linesList.size() - lines;
            if (start < 0) {
                start = 0;
            }
            for (int index = start; index < linesList.size(); ++index) {
                log.append((String)linesList.get(index) + "\n");
            }
            linesList = null;
            return log.toString().replaceAll(Pattern.quote("}{^"), "}{ ^");
        }
        catch (Exception e) {
            Logger.logError("Error reading logcat output!");
            return e.getMessage();
        }
    }

    public static boolean allowedToSendData() {
        if (!Properties.flushOnlyOverWiFi) {
            return true;
        }
        return Properties.CONNECTION.equals("WIFI");
    }

    public static boolean isMatch(byte[] pattern, byte[] input, int pos) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == input[pos + i]) continue;
            return false;
        }
        return true;
    }

    public static List<byte[]> byteSplit(byte[] pattern, byte[] input) {
        ArrayList<byte[]> l = new ArrayList<byte[]>();
        int blockStart = 0;
        for (int i = 0; i < input.length; ++i) {
            if (!Utils.isMatch(pattern, input, i)) continue;
            l.add(Arrays.copyOfRange(input, blockStart, i));
            i = blockStart = i + pattern.length;
        }
        if (blockStart < input.length) {
            l.add(Arrays.copyOfRange(input, blockStart, input.length));
        }
        return l;
    }

    public static String getChannelIdByConfig(Context context, String appChannelId) {
        if (appChannelId != null && !appChannelId.equals("NA") && !appChannelId.isEmpty()) {
            return appChannelId;
        }
        String channelID = "NA";
        if (context == null) {
            Logger.logError("Context is null!");
            return channelID;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            channelID = appInfo.metaData.getString("CRASHEYE_CHANNEL");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return channelID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getGZipString(String data) {
        byte[] gzipData = null;
        String tempData = data;
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gos = null;
        try {
            baos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(baos);
            gos.write(tempData.getBytes());
            gos.close();
            gzipData = baos.toByteArray();
        }
        catch (Exception e) {
            gzipData = null;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (gos != null) {
                try {
                    gos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return gzipData;
    }

    public static String getSendReportUrl() {
        String url;
        String urlNumber = "";
        urlNumber = Properties.RemoteSettingsProps.actionHost == null || Properties.RemoteSettingsProps.actionHost < 0 || Properties.RemoteSettingsProps.actionHost > 99 ? "" : String.valueOf(Properties.RemoteSettingsProps.actionHost);
        switch (Properties.domainConfig) {
            case "internal_cn": {
                url = "https://zyxm" + urlNumber + ".testplus.cn";
                break;
            }
            case "internal_us": {
                url = "https://zyxm" + urlNumber + ".testplus.us";
                break;
            }
            case "external": {
                url = "https://crasheyerp" + urlNumber + ".testplus.cn";
                break;
            }
            case "internal_oversea": {
                url = "https://api-crasheye.testplus.us/v2";
                break;
            }
            default: {
                Logger.logError("Unsupported domain config " + Properties.domainConfig);
                url = "https://crasheyerp" + urlNumber + ".testplus.cn";
            }
        }
        Logger.logInfo("Send report url: " + url);
        return url;
    }

    public static String getAbsolutePath(Context context) {
        if (context == null) {
            return null;
        }
        try {
            if (context.getFilesDir() == null) {
                return null;
            }
            String absolutePath = context.getFilesDir().getAbsolutePath();
            if (absolutePath == null) {
                return null;
            }
            File filesPath = new File(absolutePath);
            if (filesPath.isDirectory()) {
                return absolutePath;
            }
            return null;
        }
        catch (Exception ex) {
            if (Crasheye.DEBUG) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static String getParentFilePath(Context context) {
        if (context == null) {
            return null;
        }
        try {
            File dir = context.getFilesDir();
            if (dir == null) {
                return null;
            }
            File parentDir = context.getFilesDir().getParentFile();
            if (parentDir == null) {
                return null;
            }
            String parentFilePath = parentDir.getAbsolutePath();
            if (parentFilePath == null) {
                return null;
            }
            File filesPath = new File(parentFilePath);
            if (filesPath.isDirectory()) {
                return parentFilePath + "/lib/libmono.so";
            }
            return null;
        }
        catch (Exception ex) {
            if (Crasheye.DEBUG) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static long currentTimestrap() {
        return System.currentTimeMillis();
    }

    public static String encryptString(String content) {
        try {
            if (content != null && content.length() > 0) {
                byte[] xorId = Utils.encryptBytes(content.getBytes(Charset.forName("utf-8")), ENCRYPT_KEY);
                return ENCRYPT_MAGIC + Base64.encodeToString((byte[])xorId, (int)2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return content;
    }

    public static String decryptString(String content) {
        try {
            if (content != null && content.length() > 0 && content.startsWith(ENCRYPT_MAGIC)) {
                byte[] base64Str = Base64.decode((String)content.substring(ENCRYPT_MAGIC.length()), (int)2);
                byte[] xorJson = Utils.encryptBytes(base64Str, ENCRYPT_KEY);
                return new String(xorJson, "utf-8");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return content;
    }

    public static byte[] encryptBytes(byte[] data, byte[] key) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return data;
        }
        byte[] result = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = (byte)(data[i] ^ key[i % key.length]);
        }
        return result;
    }
}

