/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.util;

import com.xsj.crasheye.log.Logger;
import java.util.Calendar;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TaskManager {
    private static volatile TaskManager sInstance;
    private ScheduledExecutorService mExecutor = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private AtomicInteger mThreadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("CrasheyeTask-#" + this.mThreadCount.incrementAndGet());
            thread.setPriority(1);
            return thread;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void postInterval(Runnable task, long interval) {
        Logger.logInfo("[Task] Post Task, Interval=" + interval);
        this.mExecutor.scheduleAtFixedRate(task, 0L, interval, TimeUnit.MILLISECONDS);
    }

    public void postDelay(Runnable task, long delay) {
        Calendar cal = Calendar.getInstance();
        cal.add(14, (int)delay);
        Logger.logInfo("[Task] Post Task, Delay=" + delay + " ms, At=" + cal.getTime().toString());
        this.mExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public void postImmediately(Runnable task) {
        Logger.logInfo("[Task] Post Task, ImmediatelyDelay");
        this.mExecutor.submit(task);
    }

    public Executor getExecutor() {
        return this.mExecutor;
    }
}

