/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.util;

import com.xsj.crasheye.http.MultipartBody;
import com.xsj.crasheye.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SignedInfoUtils {
    public static PresignedUploadInfo parseSignedInfo(String responseBody) throws JSONException {
        PresignedUploadInfo result = new PresignedUploadInfo();
        JSONObject jo = new JSONObject(responseBody);
        JSONObject presigned_upload_info = jo.optJSONObject("presigned_upload_info");
        if (presigned_upload_info == null) {
            return null;
        }
        result.url = presigned_upload_info.optString("url");
        if (result.url == null) {
            return null;
        }
        JSONObject fieldsJo = presigned_upload_info.optJSONObject("fields");
        if (fieldsJo == null) {
            return null;
        }
        result.fields = new PresignedUploadInfoFields();
        result.fields.key = fieldsJo.optString("key");
        if (result.fields.key == null) {
            return null;
        }
        result.fields.AWSAccessKeyId = fieldsJo.optString("AWSAccessKeyId");
        if (result.fields.AWSAccessKeyId == null) {
            return null;
        }
        result.fields.policy = fieldsJo.optString("policy");
        if (result.fields.policy == null) {
            return null;
        }
        result.fields.signature = fieldsJo.optString("signature");
        if (result.fields.signature == null) {
            return null;
        }
        return result;
    }

    public static MultipartBody buildMultipartBody(PresignedUploadInfoFields fieldsInfo, String file) throws IOException {
        String BOUNDARY = "bd5891334f2b5aa4-a5368dc0c067cdf4-329df6dc4831b115-c0a33310af06f8f4";
        HashMap new_headers = new HashMap();
        MultipartBody.Builder builder = new MultipartBody.Builder("bd5891334f2b5aa4-a5368dc0c067cdf4-329df6dc4831b115-c0a33310af06f8f4", "multipart/form-data");
        builder.addStringPart("key", fieldsInfo.key);
        builder.addStringPart("AWSAccessKeyId", fieldsInfo.AWSAccessKeyId);
        builder.addStringPart("policy", fieldsInfo.policy);
        builder.addStringPart("signature", fieldsInfo.signature);
        byte[] FilePart2 = new byte[]{};
        try {
            FilePart2 = Utils.getGZipString(file);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        builder.addFilePart("file", "file", "text/plain", FilePart2);
        return builder.build();
    }

    public static Map<String, String> getNewHeader(String contentType) {
        HashMap<String, String> new_headers = new HashMap<String, String>();
        new_headers.put("Content-Type", contentType);
        return new_headers;
    }

    public static class PresignedUploadInfo {
        public String url;
        public PresignedUploadInfoFields fields;
    }

    public static class PresignedUploadInfoFields {
        public String key;
        public String AWSAccessKeyId;
        public String policy;
        public String signature;
    }
}

