/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public final class MemInfoUtils {
    private static final String PROC_MEMINFO_FILENAME = "/proc/meminfo";
    private static final String KEY_MEM_TOTAL = "MemTotal";
    private static final String KEY_MEM_FREE = "MemFree";
    private static final String KEY_MEM_AVAILABLE = "MemAvailable";
    private static final String KEY_BUFFERS = "Buffers";
    private static final String KEY_CACHED = "Cached";
    private static MemInfo sMenInfo = null;

    public static MemInfo getCurrentMemInfo() {
        sMenInfo = MemInfoUtils.readProcMemInfo();
        return sMenInfo;
    }

    public static MemInfo getLastMemInfo() {
        if (sMenInfo == null) {
            sMenInfo = MemInfoUtils.readProcMemInfo();
        }
        return sMenInfo;
    }

    private static MemInfo readProcMemInfo() {
        MemInfo memInfo = new MemInfo();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(PROC_MEMINFO_FILENAME));
            while ((line = reader.readLine()) != null) {
                if (memInfo.memTotal != 0L) {
                    if (memInfo.memAvailable != 0L) break;
                    if (memInfo.memFree != 0L && memInfo.buffers != 0L && memInfo.cached != 0L) {
                        break;
                    }
                }
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith(KEY_MEM_TOTAL)) {
                    memInfo.memTotal = MemInfoUtils.readMemInfoValue(line, KEY_MEM_TOTAL);
                    continue;
                }
                if (line.startsWith(KEY_MEM_FREE)) {
                    memInfo.memFree = MemInfoUtils.readMemInfoValue(line, KEY_MEM_FREE);
                    continue;
                }
                if (line.startsWith(KEY_MEM_AVAILABLE)) {
                    memInfo.memAvailable = MemInfoUtils.readMemInfoValue(line, KEY_MEM_AVAILABLE);
                    continue;
                }
                if (line.startsWith(KEY_BUFFERS)) {
                    memInfo.buffers = MemInfoUtils.readMemInfoValue(line, KEY_BUFFERS);
                    continue;
                }
                if (!line.startsWith(KEY_CACHED)) continue;
                memInfo.cached = MemInfoUtils.readMemInfoValue(line, KEY_CACHED);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException line) {}
            }
        }
        return memInfo;
    }

    private static long readMemInfoValue(String line, String key) {
        long val = 0L;
        try {
            val = Long.parseLong(line.split(":\\s+", 2)[1].toLowerCase().replace("kb", "").trim()) << 10;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return val;
    }

    public static class MemInfo {
        public long memTotal = 0L;
        public long memAvailable = 0L;
        public long memFree = 0L;
        public long buffers = 0L;
        public long cached = 0L;

        public String toString() {
            return "MemInfo{memTotal=" + this.memTotal + ", memAvailable=" + this.memAvailable + ", memFree=" + this.memFree + ", buffers=" + this.buffers + ", cached=" + this.cached + '}';
        }
    }
}

