/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.pushstrategy;

import com.xsj.crasheye.ActionEvent;
import com.xsj.crasheye.CrasheyeFileFilter;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.util.Utils;
import java.io.File;
import java.io.FileFilter;

public class MergerSession {
    private static int sessionFileCount = 0;

    public static void MergerSessionFiles() {
        File filesPath = new File(Properties.FILES_PATH);
        File[] files = filesPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File fileName) {
                return fileName.getName().startsWith("session-CrasheyeSavedData-") && fileName.getName().endsWith(".json");
            }
        });
        if (files == null) {
            return;
        }
        if (files.length <= 1) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            int fileCount = MergerSession.GetSessionCountByFileName(fileName);
            boolean delSuccess = MergerSession.DeleteOldSessionFiles(file);
            if (!delSuccess || fileCount <= 0) continue;
            sessionFileCount += fileCount;
        }
        if (sessionFileCount <= 0) {
            return;
        }
        MergerSession.BuildMergerSession(sessionFileCount);
    }

    public static int GetSessionCountByFileName(String fileName) {
        String[] strSplit = fileName.split("-");
        int fileCount = 0;
        try {
            fileCount = Integer.valueOf(strSplit[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileCount;
    }

    private static void BuildMergerSession(int sessionCount) {
        Properties.sessionCount = sessionCount;
        ActionEvent ace = ActionEvent.createPing(0);
        String jsonLine = ace.toJsonLine();
        Logger.logInfo("Merge session count: " + sessionCount);
        CrasheyeFileFilter.SetFileCount(sessionCount);
        Utils.writeFile(CrasheyeFileFilter.createSessionNewFile(), jsonLine);
    }

    private static boolean DeleteOldSessionFiles(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.exists() && file.isFile()) {
                file.delete();
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

