/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.pushstrategy;

import android.content.Context;
import android.content.SharedPreferences;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.util.Utils;
import java.text.SimpleDateFormat;

public class DateRefreshStrategy {
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static long recordStartDate = -1L;
    private static long lastReportTime = -1L;
    private static DateRefreshStrategy m_instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateRefreshStrategy getInstance() {
        if (m_instance != null) return m_instance;
        Class<DateRefreshStrategy> clazz = DateRefreshStrategy.class;
        synchronized (DateRefreshStrategy.class) {
            if (m_instance != null) return m_instance;
            m_instance = new DateRefreshStrategy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    public void load(Context ctx) {
        SharedPreferences preferences = ctx.getSharedPreferences("DATAREFRESHSTRATEGY", 0);
        if (preferences == null) {
            return;
        }
        try {
            recordStartDate = preferences.getLong("recordStartDate", -1L);
            lastReportTime = preferences.getLong("lastReportTime", -1L);
        }
        catch (Exception e) {
            Logger.logWarning("load DateRefreshStrategy error.");
        }
    }

    public void saveAll(Context ctx) {
        this.saveRecordStartDate(ctx);
        this.saveLastReportTime(ctx);
    }

    public void updataRecordStartDate(long StartDate) {
        if (StartDate <= 0L) {
            Logger.logWarning("StartDate time is illegal.");
        }
        recordStartDate = StartDate;
    }

    public void saveRecordStartDate(Context ctx) {
        SharedPreferences preferences = ctx.getSharedPreferences("DATAREFRESHSTRATEGY", 0);
        if (preferences == null) {
            return;
        }
        SharedPreferences.Editor editor = preferences.edit();
        if (editor == null) {
            return;
        }
        try {
            if (recordStartDate >= 0L) {
                editor.putLong("recordStartDate", recordStartDate);
                if (editor.commit()) {
                    Logger.logInfo("saveRecordStartDate commit success.");
                } else {
                    Logger.logWarning("saveRecordStartDate commit error.");
                }
            }
        }
        catch (Exception e) {
            Logger.logWarning("saveRecordStartDate save error.");
        }
    }

    public void updataLastReportTime(long ReportDate) {
        if (ReportDate <= 0L) {
            Logger.logWarning("ReportDate time is illegal.");
        }
        lastReportTime = ReportDate;
    }

    public void saveLastReportTime(Context ctx) {
        SharedPreferences preferences = ctx.getSharedPreferences("DATAREFRESHSTRATEGY", 0);
        if (preferences == null) {
            return;
        }
        SharedPreferences.Editor editor = preferences.edit();
        if (editor == null) {
            return;
        }
        try {
            if (recordStartDate >= 0L) {
                editor.putLong("lastReportTime", lastReportTime);
                if (editor.commit()) {
                    Logger.logInfo("saveLastReportTime commit success.");
                } else {
                    Logger.logWarning("saveLastReportTime commit error.");
                }
            }
        }
        catch (Exception e) {
            Logger.logWarning("saveLastReportTime save error.");
        }
    }

    public boolean checkCanRefresh() {
        boolean IsUpdata = false;
        if (recordStartDate <= 0L) {
            IsUpdata = true;
        }
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String SpTime = sf.format(recordStartDate);
            String CurrentTime = sf.format(Utils.getTimeForLong());
            if (SpTime.equals(CurrentTime)) {
                Logger.logInfo("today has sent a request to the server, no need to send");
                IsUpdata = false;
            } else {
                IsUpdata = true;
            }
        }
        catch (Exception e) {
            Logger.logWarning("DateRefreshStrategy check Exception.");
            IsUpdata = true;
        }
        return IsUpdata;
    }

    public boolean checkCanReportBySpanTime() {
        int actionSpan = Properties.RemoteSettingsProps.actionSpan;
        if (actionSpan == -1) {
            return true;
        }
        if (actionSpan <= 0 || actionSpan >= 24) {
            Logger.logWarning("actionSpan Don't take effect");
            return false;
        }
        if (lastReportTime <= 0L) {
            Logger.logWarning("lastReportTime is not exist, so can report");
            return true;
        }
        if (Utils.getTimeForLong() - lastReportTime < 0L) {
            Logger.logWarning("lastReportTime Don't take effect, so can report");
            return true;
        }
        if (Utils.getTimeForLong() - lastReportTime <= (long)actionSpan * 3600000L) {
            Logger.logInfo("set session report send span time " + actionSpan + " hour.");
            return false;
        }
        return true;
    }

    public boolean checkCanReportByFileCount(int fileCount) {
        if (fileCount <= 0) {
            return false;
        }
        return fileCount >= Properties.RemoteSettingsProps.actionCounts;
    }
}

