/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.minidump;

import com.xsj.crasheye.log.Logger;
import java.io.File;

public class MinidumpStackAnalyzer {
    private static boolean sLibraryLoaded = false;

    public File analyze(File dumpFile) {
        String outputFilePath;
        if (dumpFile == null || !dumpFile.exists()) {
            throw new IllegalArgumentException("file can't be null or not exists");
        }
        String dumpFilePath = dumpFile.getAbsolutePath();
        boolean success = this.analyze(dumpFilePath, outputFilePath = dumpFilePath + ".analyzed");
        return success ? new File(outputFilePath) : null;
    }

    public boolean analyze(String inputDumpPath, String outputFilePath) {
        if (!sLibraryLoaded) {
            Logger.logError("minidump_stack_analyze so not loaded");
            return false;
        }
        Logger.logInfo("analyze minidump file: " + inputDumpPath + " -> " + outputFilePath);
        try {
            return this.analyzer(inputDumpPath, outputFilePath) == 0;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public native int analyzer(String var1, String var2);

    static {
        try {
            System.loadLibrary("crasheye_stack_analyze");
            sLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            sLibraryLoaded = false;
        }
    }
}

