/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.content.Context;
import com.xsj.crasheye.BaseDTO;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.CrasheyeLogLevel;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.NetSenderResponse;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.RemoteSettings;
import com.xsj.crasheye.RemoteSettingsData;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.pushstrategy.DateRefreshStrategy;
import com.xsj.crasheye.session.Session;
import com.xsj.crasheye.util.Utils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionEvent
extends BaseDTO
implements InterfaceDataType {
    protected static String savedSessionID = "";
    protected String eventName = "";
    protected Integer eventLevel = null;
    protected long duration = -1L;
    protected String session_id = "";

    public ActionEvent(EnumActionType type, String eventName, Integer level, HashMap<String, Object> customData) {
        super(type, customData);
        this.eventName = eventName;
        this.eventLevel = level;
        if (type == EnumActionType.ping) {
            savedSessionID = this.session_id = Utils.getRandomSessionNumber();
        } else if (type == EnumActionType.gnip) {
            this.session_id = savedSessionID;
        }
    }

    public static final ActionEvent createEvent(String eventName) {
        return new ActionEvent(EnumActionType.event, eventName, Utils.convertLoggingLevelToInt(CrasheyeLogLevel.Verbose), null);
    }

    public static final ActionEvent createEvent(String eventName, CrasheyeLogLevel level, HashMap<String, Object> customData) {
        return new ActionEvent(EnumActionType.event, eventName, Utils.convertLoggingLevelToInt(level), customData);
    }

    public static final ActionEvent createPing(int type) {
        ActionEvent eventPing = new ActionEvent(EnumActionType.ping, Session.getSessionNameByType(type), null, null);
        Properties.lastPingTime = eventPing.timestampMilis;
        return eventPing;
    }

    public static final ActionEvent createGnip() {
        ActionEvent eventGnip = new ActionEvent(EnumActionType.gnip, null, null, null);
        eventGnip.duration = eventGnip.timestampMilis - Properties.lastPingTime;
        return eventGnip;
    }

    public String getSessionId() {
        return this.session_id;
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            json.remove("isservice");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.duration != -1L) {
                json.put("ses_duration", this.duration);
            }
            if (this.eventName != null) {
                json.put("event_name", (Object)this.eventName);
            }
            if (this.eventLevel != null) {
                json.put("level", (Object)this.eventLevel);
            }
            if (this.type != EnumActionType.event) {
                json.put("sessionid", (Object)this.session_id);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator(this.type);
    }

    public static void parseAndSaveRemoteSettingsFromPingResponse(Context ctx, NetSenderResponse nsr) {
        if (nsr != null && nsr.getSentSuccessfully().booleanValue()) {
            RemoteSettingsData remoteData = RemoteSettings.convertJsonToRemoteSettings(nsr.getServerResponse());
            if (remoteData == null) {
                Logger.logInfo("send return RemoteData is null, revert send report host!");
                RemoteSettings.revertAndLoadSendReoprtHost(ctx);
            } else {
                if ((remoteData.actionSpan < 1 || remoteData.actionSpan > 23) && remoteData.actionSpan != -1) {
                    return;
                }
                if (remoteData.actionCounts <= 0 && remoteData.actionCounts != -1) {
                    return;
                }
                if ((remoteData.actionHost < 0 || remoteData.actionHost > 99) && remoteData.actionHost != -1) {
                    return;
                }
                boolean saveSuccess = RemoteSettings.saveAndLoadRemoteSettings(ctx, remoteData);
                if (saveSuccess) {
                    DateRefreshStrategy.getInstance().updataRecordStartDate(Utils.getTimeForLong());
                    DateRefreshStrategy.getInstance().saveRecordStartDate(ctx);
                }
            }
        }
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        if (this.type.equals((Object)EnumActionType.ping)) {
            String postData = this.toJsonLine();
            NetSenderResponse nsr = netSender.sendBlocking(null, postData, saveOnFail);
            ActionEvent.parseAndSaveRemoteSettingsFromPingResponse(ctx, nsr);
        } else {
            netSender.send(null, this.toJsonLine(), saveOnFail);
        }
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        if (this.eventLevel != null) {
            if (this.eventLevel >= Properties.RemoteSettingsProps.eventLevel) {
                dataSaver.save(this.toJsonLine());
            } else {
                Logger.logInfo("Event's level is lower than the minimum level from Remote Settings, event will not be saved");
            }
        } else {
            dataSaver.save(this.toJsonLine());
        }
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }
}

