/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye;

import android.app.ActivityManager;
import android.content.Context;
import com.xsj.crasheye.BaseDTO;
import com.xsj.crasheye.BaseDataSaver;
import com.xsj.crasheye.CrasheyeFileFilter;
import com.xsj.crasheye.EnumActionType;
import com.xsj.crasheye.EnumErrorType;
import com.xsj.crasheye.EnumExceptionType;
import com.xsj.crasheye.InterfaceDataType;
import com.xsj.crasheye.NetSender;
import com.xsj.crasheye.Properties;
import com.xsj.crasheye.StacktraceHash;
import com.xsj.crasheye.session.SessionManager;
import com.xsj.crasheye.util.DeviceUtils;
import com.xsj.crasheye.util.EnumStateStatus;
import com.xsj.crasheye.util.Utils;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionError
extends BaseDTO
implements InterfaceDataType {
    private String stacktrace;
    private Boolean handled;
    private String klass;
    private String message;
    private String errorHash;
    private String where;
    private EnumStateStatus gpsStatus;
    private String msFromStart;
    private String memSysTotal = null;
    private String memSysLow;
    private String memSysAvailable = null;
    private String memSysThreshold;
    private String memAppMax;
    private String memAppAvailable;
    private String memAppTotal;
    private JSONArray breadcrumbs;
    private String romTotal;
    private String romFree;
    private String sdcardTotal;
    private String sdcardFree;
    private String foreground;
    private String crashTime;
    private String crashuuid;

    public ActionError(EnumActionType dataType, String stacktrace, EnumExceptionType exceptionType, HashMap<String, Object> customData) {
        super(dataType, customData);
        this.stacktrace = stacktrace;
        this.handled = exceptionType == EnumExceptionType.HANDLED ? Boolean.valueOf(true) : Boolean.valueOf(false);
        HashMap<String, String> stackHashMap = StacktraceHash.manipulateStacktrace(Properties.APP_PACKAGE, stacktrace);
        this.klass = stackHashMap.get("klass");
        this.message = stackHashMap.get("message");
        this.errorHash = stackHashMap.get("errorHash");
        this.where = stackHashMap.get("where");
        this.gpsStatus = Properties.IS_GPS_ON;
        this.msFromStart = Utils.getMilisFromStart();
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        Runtime rt = Runtime.getRuntime();
        if (!this.handled.booleanValue()) {
            long[] tmp = DeviceUtils.getRAMStat();
            this.memSysAvailable = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
            this.memSysTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
            tmp = DeviceUtils.getROMStat();
            this.romFree = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
            this.romTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
            tmp = DeviceUtils.getSDCardSpace();
            this.sdcardFree = String.valueOf((double)tmp[0] / DeviceUtils.GB_BYTE);
            this.sdcardTotal = String.valueOf((double)tmp[1] / DeviceUtils.GB_BYTE);
        }
        this.memSysThreshold = String.valueOf((double)memoryInfo.threshold / 1048576.0);
        this.memSysLow = String.valueOf(memoryInfo.lowMemory);
        this.memAppMax = String.valueOf((double)rt.maxMemory() / 1048576.0);
        this.memAppAvailable = String.valueOf((double)rt.freeMemory() / 1048576.0);
        this.memAppTotal = String.valueOf((double)rt.totalMemory() / 1048576.0);
        this.breadcrumbs = Properties.breadcrumbs.getList();
        this.crashTime = Utils.getTime();
        this.crashuuid = Utils.randomUUID();
        this.foreground = SessionManager.getInstance().getForeground() + "";
    }

    public final String getErrorHash() {
        return this.errorHash;
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            JSONObject node = new JSONObject();
            node.put("stack", (Object)this.stacktrace);
            node.put("error", (Object)this.message);
            json.put("crash", (Object)node);
            json.put("dumptype", (Object)EnumErrorType.java.toString());
            json.put("handled", (Object)this.handled);
            json.put("klass", (Object)this.klass);
            json.put("message", (Object)this.message);
            json.put("errorhash", (Object)this.errorHash);
            json.put("where", (Object)this.where);
            json.put("rooted", (Object)this.rooted);
            json.put("gpsstatus", (Object)this.gpsStatus.toString());
            json.put("msfromstart", (Object)this.msFromStart);
            if (this.breadcrumbs != null && this.breadcrumbs.length() > 0) {
                json.put("breadcrumbs", (Object)this.breadcrumbs);
            }
            json.put("memsyslow", (Object)this.memSysLow);
            json.put("memsystotal", (Object)this.memSysTotal);
            json.put("memsysavailable", (Object)this.memSysAvailable);
            json.put("romtotal", (Object)this.romTotal);
            json.put("romavailable", (Object)this.romFree);
            json.put("sdcardtotal", (Object)this.sdcardTotal);
            json.put("sdcardavailable", (Object)this.sdcardFree);
            json.put("memsysthreshold", (Object)this.memSysThreshold);
            json.put("memappmax", (Object)this.memAppMax);
            json.put("memappavailable", (Object)this.memAppAvailable);
            json.put("memapptotal", (Object)this.memAppTotal);
            if (Properties.SEND_LOG) {
                String logcat = Utils.readLogs();
                json.put("log", (Object)logcat);
            } else {
                json.put("log", (Object)"NA");
            }
            json.put("crashuuid", (Object)this.crashuuid);
            json.put("crashtime", (Object)this.crashTime);
            json.put("foreground", (Object)this.foreground);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator(this.type);
    }

    @Override
    public void send(NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save(BaseDataSaver dataSaver) {
        Utils.writeFile(CrasheyeFileFilter.createNewFile(), this.toJsonLine());
    }

    @Override
    public void send(Context ctx, NetSender netSender, boolean saveOnFail) {
        netSender.send(null, this.toJsonLine(), saveOnFail);
    }
}

