/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import com.yasirkula.unity.DebugConsoleLogcatLogReceiver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class DebugConsoleLogcatLogger {
    private LogcatWorker worker;

    public void Start(DebugConsoleLogcatLogReceiver logReceiver, String arguments) {
        this.Stop();
        if (logReceiver == null) {
            return;
        }
        String command = "logcat";
        if (arguments != null && (arguments = arguments.trim()).length() > 0) {
            command = command + " " + arguments;
        }
        this.worker = new LogcatWorker(logReceiver, command);
        Thread thread = new Thread(this.worker);
        thread.start();
    }

    public void Stop() {
        if (this.worker != null) {
            this.worker.terminate();
            this.worker = null;
        }
    }

    private static class LogcatWorker
    implements Runnable {
        private DebugConsoleLogcatLogReceiver logReceiver;
        private String command;
        private volatile boolean running = true;

        public LogcatWorker(DebugConsoleLogcatLogReceiver logReceiver, String command) {
            this.logReceiver = logReceiver;
            this.command = command;
        }

        @Override
        public void run() {
            try {
                Runtime.getRuntime().exec("logcat -c");
                Process process = Runtime.getRuntime().exec(this.command);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while (this.running) {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        this.logReceiver.OnLogReceived(line);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void terminate() {
            this.running = false;
        }
    }
}

