/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.google;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.CountDownTimer;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.AuthenticationResult;
import com.google.android.gms.games.GamesSignInClient;
import com.google.android.gms.games.LeaderboardsClient;
import com.google.android.gms.games.PlayGames;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.SnapshotsClient;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.youloft.callbcak.NetCallBack;
import com.youloft.core.UnityPlayerBridge;
import com.youloft.core.utils.LogUtils;
import com.youloft.google.SelectSnapshotActivity;
import com.youloft.google.SnapshotCoordinator;
import com.youloft.login.LoginUtils;
import com.youloft.statistics.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleGameManager {
    private static final String TAG = "GoogleGameManager";
    private static final String SAVE_GAME = "saveGame";
    private static final String LOAD_GAME = "loadGame";
    public static final int TIME_OUT = 9999;
    private static final int RC_SIGN_IN = 9001;
    private static final int RC_LIST_SAVED_GAMES = 9002;
    private static final int RC_SELECT_SNAPSHOT = 9003;
    private static final int RC_SAVE_SNAPSHOT = 9004;
    private static final int RC_LOAD_SNAPSHOT = 9005;
    private static SnapshotsClient mSnapshotsClient = null;
    private Activity activity;
    static final int MAX_SNAPSHOT_RESOLVE_RETRIES = 5;
    private String currentSaveName = "snapshotTemp";
    private static final int RC_SAVED_GAMES = 9009;
    private byte[] data;
    private CountDownTimer mcd;
    private NetCallBack mSaveCallBack;
    private NetCallBack mLoadCallBack;
    private static GoogleGameManager instance = null;

    private GoogleGameManager() {
    }

    public void setLoadCallBack(NetCallBack netCallBack) {
        this.mLoadCallBack = netCallBack;
    }

    public void setSaveCallBack(NetCallBack netCallBack) {
        this.mSaveCallBack = netCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleGameManager getInstance() {
        Class<GoogleGameManager> clazz = GoogleGameManager.class;
        synchronized (GoogleGameManager.class) {
            if (null == instance) {
                instance = new GoogleGameManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void loginGame(Activity context) {
        this.activity = context;
        GamesSignInClient gamesSignInClient = PlayGames.getGamesSignInClient((Activity)this.activity);
        gamesSignInClient.signIn();
        gamesSignInClient.isAuthenticated().addOnCompleteListener(isAuthenticatedTask -> {
            boolean isAuthenticated;
            boolean bl = isAuthenticated = isAuthenticatedTask.isSuccessful() && ((AuthenticationResult)isAuthenticatedTask.getResult()).isAuthenticated();
            if (isAuthenticated) {
                PlayGames.getPlayersClient((Activity)this.activity).getCurrentPlayer().addOnCompleteListener(mTask -> {
                    LogUtils.e(((Player)mTask.getResult()).getCurrentPlayerInfo() + "");
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("id", (Object)((Player)mTask.getResult()).getPlayerId());
                        jsonObject.put("name", (Object)((Player)mTask.getResult()).getDisplayName());
                        jsonObject.put("picture", (Object)((Player)mTask.getResult()).getIconImageUri());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    LoginUtils.getLoginSuccess(jsonObject, 2);
                    LogUtils.e(jsonObject.toString());
                });
            } else {
                LoginUtils.getLoginError("GoogleGame\u81ea\u52a8\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25,\u8bf7\u624b\u52a8\u767b\u5f55" + ((AuthenticationResult)isAuthenticatedTask.getResult()).toString(), 2);
            }
        });
    }

    public void saveGame(Activity context, String currentSaveName, String data) {
        this.activity = context;
        this.currentSaveName = currentSaveName;
        this.saveSnapshot(null, data.getBytes());
    }

    public void loadGame(Activity context, String currentSaveName) {
        this.activity = context;
        this.currentSaveName = currentSaveName;
        mSnapshotsClient = PlayGames.getSnapshotsClient((Activity)this.activity);
        this.loadFromSnapshot(null);
    }

    public void loadLeaderBoard(String id2, int time) {
        this.loadLeaderBoard(id2, time, null);
    }

    public void loadLeaderBoard(String id2, int time, final NetCallBack netCallBack) {
        if (this.activity == null) {
            if (netCallBack != null) {
                netCallBack.failed("null");
            }
            return;
        }
        if (time != 0 && time != 1 && time != 2) {
            time = 2;
        }
        LeaderboardsClient leaderboardsClient = PlayGames.getLeaderboardsClient((Activity)this.activity);
        leaderboardsClient.loadCurrentPlayerLeaderboardScore(id2, time, 0).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<AnnotatedData<LeaderboardScore>>(){

            public void onComplete(@NonNull Task<AnnotatedData<LeaderboardScore>> task) {
                block7: {
                    try {
                        if (task.getResult() != null) {
                            LeaderboardScore leaderboardScore = (LeaderboardScore)((AnnotatedData)task.getResult()).get();
                            if (leaderboardScore == null) break block7;
                            JSONObject jsonObject = new JSONObject();
                            try {
                                jsonObject.put("DisplayRank", (Object)leaderboardScore.getDisplayRank());
                                jsonObject.put("DisplayScore", (Object)leaderboardScore.getDisplayScore());
                                jsonObject.put("Rank", leaderboardScore.getRank());
                                jsonObject.put("RawScore", leaderboardScore.getRawScore());
                                jsonObject.put("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName());
                                jsonObject.put("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl());
                                LogUtils.d("PlayerLeaderboardScore", jsonObject.toString());
                                UnityPlayerBridge.sendMsg("PottingMobile", "PlayerLeaderboardScore", jsonObject.toString());
                                if (netCallBack != null) {
                                    netCallBack.success(jsonObject.toString());
                                }
                                break block7;
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                UnityPlayerBridge.sendMsg("PottingMobile", "PlayerLeaderboardScore", "");
                                if (netCallBack != null) {
                                    netCallBack.failed(jsonObject.toString());
                                }
                                break block7;
                            }
                        }
                        UnityPlayerBridge.sendMsg("PottingMobile", "PlayerLeaderboardScore", "");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                UnityPlayerBridge.sendMsg("PottingMobile", "PlayerLeaderboardScore", "");
                GoogleGameManager.this.handleException(e, "");
            }
        });
    }

    public void showLeaderBoard() {
        if (this.activity == null) {
            return;
        }
        LeaderboardsClient leaderboardsClient = PlayGames.getLeaderboardsClient((Activity)this.activity);
        leaderboardsClient.getAllLeaderboardsIntent().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Intent>(){

            public void onSuccess(Intent intent) {
                GoogleGameManager.this.activity.startActivityForResult(intent, 1001);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                GoogleGameManager.this.handleException(e, GoogleGameManager.this.activity.getString(R.string.leaderboards_exception));
            }
        });
    }

    public void showLeaderBoard(String id2, int time) {
        if (this.activity == null) {
            return;
        }
        if (time != 0 && time != 1 && time != 2) {
            time = 2;
        }
        LeaderboardsClient leaderboardsClient = PlayGames.getLeaderboardsClient((Activity)this.activity);
        leaderboardsClient.getLeaderboardIntent(id2, time, 0).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Intent>(){

            public void onSuccess(Intent intent) {
                GoogleGameManager.this.activity.startActivityForResult(intent, 1001);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                GoogleGameManager.this.handleException(e, GoogleGameManager.this.activity.getString(R.string.leaderboards_exception));
            }
        });
    }

    public void submitLeaderBoardScore(String id2, long score) {
        if (this.activity == null) {
            return;
        }
        LeaderboardsClient leaderboardsClient = PlayGames.getLeaderboardsClient((Activity)this.activity);
        leaderboardsClient.submitScore(id2, score);
    }

    private void onDisconnected() {
        LogUtils.d(TAG, "onDisconnected()");
        mSnapshotsClient = null;
    }

    private void onConnected(GoogleSignInAccount account) {
        LogUtils.d(TAG, "onConnected(): connected to Google APIs");
    }

    private void onAccountChanged() {
        mSnapshotsClient = PlayGames.getSnapshotsClient((Activity)this.activity);
    }

    public void showSnapshots(String title, boolean allowAdd, boolean allowDelete) {
        mSnapshotsClient = PlayGames.getSnapshotsClient((Activity)this.activity);
        int maxNumberOfSavedGamesToShow = 5;
        SnapshotCoordinator.getInstance().getSelectSnapshotIntent(mSnapshotsClient, title, allowAdd, allowDelete, maxNumberOfSavedGamesToShow).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Intent>(){

            public void onComplete(@NonNull Task<Intent> task) {
                if (task.isSuccessful()) {
                    GoogleGameManager.this.activity.startActivityForResult((Intent)task.getResult(), 9002);
                } else {
                    GoogleGameManager.this.handleException(task.getException(), GoogleGameManager.this.activity.getString(R.string.show_snapshots_error));
                }
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 9002) {
            if (intent != null) {
                if (intent.hasExtra("com.google.android.gms.games.SNAPSHOT_METADATA")) {
                    SnapshotMetadata snapshotMetadata = (SnapshotMetadata)intent.getParcelableExtra("com.google.android.gms.games.SNAPSHOT_METADATA");
                    this.currentSaveName = snapshotMetadata.getUniqueName();
                    this.loadFromSnapshot(snapshotMetadata);
                } else if (intent.hasExtra("com.google.android.gms.games.SNAPSHOT_NEW")) {
                    String unique = Long.toString(System.currentTimeMillis());
                    this.currentSaveName = "snapshotTemp-" + unique;
                    this.saveSnapshot(null, this.data);
                }
            }
        } else if (requestCode == 9003) {
            LogUtils.d(TAG, "Selected a snapshot!");
            if (resultCode == -1) {
                if (intent != null && intent.hasExtra("snapshotmeta")) {
                    SnapshotMetadata snapshotMetadata = (SnapshotMetadata)intent.getParcelableExtra("snapshotmeta");
                    this.currentSaveName = snapshotMetadata.getUniqueName();
                    LogUtils.d(TAG, "ok - loading " + this.currentSaveName);
                    this.loadFromSnapshot(snapshotMetadata);
                } else {
                    LogUtils.w(TAG, "Expected snapshot metadata but found none.");
                }
            }
        } else if (requestCode == 9005) {
            LogUtils.d(TAG, "Loading a snapshot resultCode = " + resultCode);
            if (resultCode == -1 && intent != null && intent.hasExtra("snapshotmeta")) {
                String conflictId = intent.getStringExtra("conflictId");
                int retryCount = intent.getIntExtra("retrycount", 5);
                SnapshotMetadata snapshotMetadata = (SnapshotMetadata)intent.getParcelableExtra("snapshotmeta");
                if (conflictId == null) {
                    this.loadFromSnapshot(snapshotMetadata);
                } else {
                    LogUtils.d(TAG, "resolving " + snapshotMetadata);
                    this.resolveSnapshotConflict(requestCode, conflictId, retryCount, snapshotMetadata);
                }
            }
        } else if (requestCode == 9004 && resultCode == -1 && intent != null && intent.hasExtra("snapshotmeta")) {
            String conflictId = intent.getStringExtra("conflictId");
            int retryCount = intent.getIntExtra("retrycount", 5);
            SnapshotMetadata snapshotMetadata = (SnapshotMetadata)intent.getParcelableExtra("snapshotmeta");
            if (conflictId == null) {
                this.saveSnapshot(snapshotMetadata, this.data);
            } else {
                LogUtils.d(TAG, "resolving " + snapshotMetadata);
                this.resolveSnapshotConflict(requestCode, conflictId, retryCount, snapshotMetadata);
            }
        }
    }

    private void showSavedGamesUI() {
        SnapshotsClient snapshotsClient = PlayGames.getSnapshotsClient((Activity)this.activity);
        int maxNumberOfSavedGamesToShow = 5;
        Task intentTask = snapshotsClient.getSelectSnapshotIntent("See My Saves", true, true, maxNumberOfSavedGamesToShow);
        intentTask.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Intent>(){

            public void onSuccess(Intent intent) {
                GoogleGameManager.this.activity.startActivityForResult(intent, 9009);
            }
        });
    }

    void saveSnapshot(SnapshotMetadata snapshotMetadata, final byte[] data) {
        mSnapshotsClient = PlayGames.getSnapshotsClient((Activity)this.activity);
        this.data = data;
        if (mSnapshotsClient == null) {
            UnityPlayerBridge.sendMsg("PottingMobile", SAVE_GAME, "{\"Code\":-2,\"Msg\":\"google game\u672a\u767b\u5f55\"}");
            if (this.mSaveCallBack != null) {
                this.mSaveCallBack.failed("google game\u672a\u767b\u5f55");
            }
            this.handleException(new NullPointerException(), this.activity.getString(R.string.write_snapshot_error));
            return;
        }
        this.waitForClosedAndOpen(snapshotMetadata).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<SnapshotsClient.DataOrConflict<Snapshot>>(){

            public void onComplete(@NonNull Task<SnapshotsClient.DataOrConflict<Snapshot>> task) {
                SnapshotsClient.DataOrConflict result = null;
                try {
                    result = (SnapshotsClient.DataOrConflict)task.getResult();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.SAVE_GAME, "{\"Code\":-1,\"Msg\":\"\u5b58\u6863\u5931\u8d25\"}");
                    if (GoogleGameManager.this.mSaveCallBack != null) {
                        GoogleGameManager.this.mSaveCallBack.failed(task.getException().toString());
                    }
                    GoogleGameManager.this.handleException(task.getException(), GoogleGameManager.this.activity.getString(R.string.write_snapshot_error));
                    return;
                }
                Snapshot snapshotToWrite = GoogleGameManager.this.processOpenDataOrConflict(9004, (SnapshotsClient.DataOrConflict<Snapshot>)result, 0, new OnSnapshotCompleteListener(){

                    @Override
                    public void onSnapshotComplete(Snapshot snapshot) {
                        if (snapshot == null) {
                            UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.SAVE_GAME, "{\"Code\":-1,\"Msg\":\"\u5b58\u6863\u5931\u8d25\"}");
                            return;
                        }
                        LogUtils.d(GoogleGameManager.TAG, "Writing data to snapshot: " + snapshot.getMetadata().getUniqueName());
                        GoogleGameManager.this.writeSnapshot(snapshot, data).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<SnapshotMetadata>(){

                            public void onComplete(@NonNull Task<SnapshotMetadata> task) {
                                if (task.isSuccessful()) {
                                    LogUtils.i(GoogleGameManager.TAG, "Snapshot saved!");
                                    UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.SAVE_GAME, "{\"Code\":200,\"Msg\":\"\u5b58\u6863\u6210\u529f\"}");
                                    if (GoogleGameManager.this.mSaveCallBack != null) {
                                        GoogleGameManager.this.mSaveCallBack.success("\u5b58\u6863\u6210\u529f");
                                    }
                                } else {
                                    UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.SAVE_GAME, "{\"Code\":-1,\"Msg\":\"\u5b58\u6863\u5931\u8d25\"}");
                                    if (GoogleGameManager.this.mSaveCallBack != null) {
                                        GoogleGameManager.this.mSaveCallBack.failed(task.getException().toString());
                                    }
                                    GoogleGameManager.this.handleException(task.getException(), GoogleGameManager.this.activity.getString(R.string.write_snapshot_error));
                                }
                            }
                        });
                    }

                    @Override
                    public void onSnapshotError(String e) {
                        UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.SAVE_GAME, "{\"Code\":-1,\"Msg\":\"\u5b58\u6863\u5931\u8d25\"}");
                    }
                });
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.SAVE_GAME, "{\"Code\":-1,\"Msg\":\"\u5b58\u6863\u5931\u8d25\"}");
                if (GoogleGameManager.this.mSaveCallBack != null) {
                    GoogleGameManager.this.mSaveCallBack.failed(e.toString());
                }
                GoogleGameManager.this.handleException(e, GoogleGameManager.this.activity.getString(R.string.write_snapshot_error));
            }
        });
    }

    Snapshot processOpenDataOrConflict(int requestCode, SnapshotsClient.DataOrConflict<Snapshot> result, int retryCount, final OnSnapshotCompleteListener onSnapshotCompleteListener) {
        ++retryCount;
        if (!result.isConflict()) {
            onSnapshotCompleteListener.onSnapshotComplete((Snapshot)result.getData());
            return (Snapshot)result.getData();
        }
        LogUtils.i(TAG, "Open resulted in a conflict!");
        Task snapshotTask = null;
        try {
            snapshotTask = this.processSnapshotOpenResult(result, retryCount).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Snapshot>(){

                public void onComplete(@NonNull Task<Snapshot> task) {
                    try {
                        if (task == null || task.getResult() == null) {
                            onSnapshotCompleteListener.onSnapshotError("null");
                            return;
                        }
                        onSnapshotCompleteListener.onSnapshotComplete((Snapshot)task.getResult());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogUtils.e(GoogleGameManager.TAG, "The conflict that was being resolved doesn't exist");
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Task<Snapshot> processSnapshotOpenResult(SnapshotsClient.DataOrConflict<Snapshot> result, final int retryCount) {
        if (!result.isConflict()) {
            TaskCompletionSource source = new TaskCompletionSource();
            source.setResult((Object)((Snapshot)result.getData()));
            return source.getTask();
        }
        SnapshotsClient.SnapshotConflict conflict = result.getConflict();
        Snapshot snapshot = conflict.getSnapshot();
        Snapshot conflictSnapshot = conflict.getConflictingSnapshot();
        Snapshot resolvedSnapshot = snapshot;
        if (retryCount == 5) {
            LogUtils.e(TAG, "\u5b58\u6863\u51b2\u7a81\u5904\u7406\u5931\u8d25--\u4f7f\u7528\u672c\u5730\u5b58\u6863");
            TaskCompletionSource source = new TaskCompletionSource();
            source.setResult((Object)conflict.getConflictingSnapshot());
            return source.getTask();
        }
        if (snapshot.getMetadata().getLastModifiedTimestamp() < conflictSnapshot.getMetadata().getLastModifiedTimestamp()) {
            resolvedSnapshot = conflictSnapshot;
        }
        return PlayGames.getSnapshotsClient((Activity)this.activity).resolveConflict(conflict.getConflictId(), resolvedSnapshot).continueWithTask((Continuation)new Continuation<SnapshotsClient.DataOrConflict<Snapshot>, Task<Snapshot>>(){

            public Task<Snapshot> then(@NonNull Task<SnapshotsClient.DataOrConflict<Snapshot>> task) throws Exception {
                LogUtils.e(GoogleGameManager.TAG, "\u5b58\u6863\u51b2\u7a81--resolve snapshot conflicts");
                if (retryCount <= 5) {
                    return GoogleGameManager.this.processSnapshotOpenResult((SnapshotsClient.DataOrConflict<Snapshot>)((SnapshotsClient.DataOrConflict)task.getResult()), retryCount + 1);
                }
                LogUtils.e(GoogleGameManager.TAG, "Could not resolve snapshot conflicts");
                TaskCompletionSource source = new TaskCompletionSource();
                source.setResult(null);
                return source.getTask();
            }
        });
    }

    private void selectSnapshotItem(int requestCode, ArrayList<Snapshot> items, String conflictId, int retryCount) {
        ArrayList<SnapshotMetadata> snapshotList = new ArrayList<SnapshotMetadata>(items.size());
        for (Snapshot m : items) {
            snapshotList.add((SnapshotMetadata)m.getMetadata().freeze());
        }
        Intent intent = new Intent((Context)this.activity, SelectSnapshotActivity.class);
        intent.putParcelableArrayListExtra("snapshotmetaList", snapshotList);
        intent.putExtra("conflictId", conflictId);
        intent.putExtra("retrycount", retryCount);
        LogUtils.d(TAG, "Starting activity to select snapshot");
        this.activity.startActivityForResult(intent, requestCode);
    }

    private Task<SnapshotMetadata> writeSnapshot(Snapshot snapshot, byte[] data) {
        snapshot.getSnapshotContents().writeBytes(data);
        SnapshotMetadataChange metadataChange = new SnapshotMetadataChange.Builder().setDescription("Modified data at: " + Calendar.getInstance().getTime()).build();
        return SnapshotCoordinator.getInstance().commitAndClose(mSnapshotsClient, snapshot, metadataChange);
    }

    private Task<SnapshotsClient.DataOrConflict<Snapshot>> resolveSnapshotConflict(final int requestCode, final String conflictId, final int retryCount, SnapshotMetadata snapshotMetadata) {
        LogUtils.i(TAG, "Resolving conflict retry count = " + retryCount + " conflictid = " + conflictId);
        return this.waitForClosedAndOpen(snapshotMetadata).continueWithTask((Continuation)new Continuation<SnapshotsClient.DataOrConflict<Snapshot>, Task<SnapshotsClient.DataOrConflict<Snapshot>>>(){

            public Task<SnapshotsClient.DataOrConflict<Snapshot>> then(@NonNull Task<SnapshotsClient.DataOrConflict<Snapshot>> task) throws Exception {
                return SnapshotCoordinator.getInstance().resolveConflict(mSnapshotsClient, conflictId, (Snapshot)((SnapshotsClient.DataOrConflict)task.getResult()).getData()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<SnapshotsClient.DataOrConflict<Snapshot>>(){

                    public void onComplete(@NonNull Task<SnapshotsClient.DataOrConflict<Snapshot>> task) {
                        if (!task.isSuccessful()) {
                            GoogleGameManager.this.handleException(task.getException(), "There was a problem opening a file for resolving the conflict!");
                            return;
                        }
                        Snapshot snapshot = GoogleGameManager.this.processOpenDataOrConflict(requestCode, (SnapshotsClient.DataOrConflict<Snapshot>)((SnapshotsClient.DataOrConflict)task.getResult()), retryCount, new OnSnapshotCompleteListener(){

                            @Override
                            public void onSnapshotComplete(Snapshot snapshot) {
                                LogUtils.d(GoogleGameManager.TAG, "resolved snapshot conflict - snapshot is " + snapshot);
                                if (snapshot != null) {
                                    Intent intent = new Intent("");
                                    intent.putExtra("snapshotmeta", (Parcelable)snapshot.getMetadata().freeze());
                                    GoogleGameManager.this.onActivityResult(requestCode, -1, intent);
                                }
                            }

                            @Override
                            public void onSnapshotError(String e) {
                            }
                        });
                    }
                });
            }
        });
    }

    void loadFromSnapshot(SnapshotMetadata snapshotMetadata) {
        if (mSnapshotsClient == null) {
            UnityPlayerBridge.sendMsg("PottingMobile", LOAD_GAME, "{\"Code\":-2,\"Msg\":\"google game\u672a\u767b\u5f55\"}");
            if (this.mLoadCallBack != null) {
                this.mLoadCallBack.failed("google game\u672a\u767b\u5f55");
            }
            this.handleException(new NullPointerException(), this.activity.getString(R.string.write_snapshot_error));
            return;
        }
        this.waitForClosedAndOpen(snapshotMetadata).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<SnapshotsClient.DataOrConflict<Snapshot>>(){

            public void onSuccess(SnapshotsClient.DataOrConflict<Snapshot> result) {
                Snapshot snapshot = GoogleGameManager.this.processOpenDataOrConflict(9005, result, 0, new OnSnapshotCompleteListener(){

                    @Override
                    public void onSnapshotComplete(Snapshot snapshot) {
                        block5: {
                            if (snapshot == null) {
                                LogUtils.w(GoogleGameManager.TAG, "Conflict was not resolved automatically, waiting for user to resolve.");
                                UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.LOAD_GAME, "{\"Code\":-1,\"Data\":\"\u62c9\u53d6\u5b58\u6863\u5931\u8d25,\u5b58\u6863\u4e0d\u5b58\u5728\"}");
                                if (GoogleGameManager.this.mLoadCallBack != null) {
                                    GoogleGameManager.this.mLoadCallBack.failed("\u62c9\u53d6\u5b58\u6863\u5931\u8d25,\u5b58\u6863\u4e0d\u5b58\u5728");
                                }
                                return;
                            }
                            try {
                                String data = new String(snapshot.getSnapshotContents().readFully());
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("Code", 200);
                                jsonObject.put("Data", (Object)data);
                                UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.LOAD_GAME, jsonObject.toString());
                                if (GoogleGameManager.this.mLoadCallBack != null) {
                                    GoogleGameManager.this.mLoadCallBack.success(data);
                                }
                                LogUtils.i(GoogleGameManager.TAG, "Snapshot loaded:" + jsonObject.toString());
                            }
                            catch (IOException | JSONException e) {
                                LogUtils.e(GoogleGameManager.TAG, "Error while reading snapshot contents: " + e.getMessage());
                                UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.LOAD_GAME, "{\"Code\":-1,\"Data\":\"\u62c9\u53d6\u5b58\u6863\u5931\u8d25\"}");
                                if (GoogleGameManager.this.mLoadCallBack == null) break block5;
                                GoogleGameManager.this.mLoadCallBack.failed(e.getMessage());
                            }
                        }
                        SnapshotCoordinator.getInstance().discardAndClose(mSnapshotsClient, snapshot).addOnFailureListener(new OnFailureListener(){

                            public void onFailure(@NonNull Exception e) {
                                GoogleGameManager.this.handleException(e, "There was a problem discarding the snapshot!");
                                LogUtils.e(GoogleGameManager.TAG, "There was a problem discarding the snapshot!" + e.getMessage());
                            }
                        });
                    }

                    @Override
                    public void onSnapshotError(String e) {
                        UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.LOAD_GAME, "{\"Code\":-1,\"Data\":\"\u62c9\u53d6\u5b58\u6863\u5931\u8d25,\u5b58\u6863\u4e0d\u5b58\u5728\"}");
                    }
                });
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                LogUtils.e(GoogleGameManager.TAG, "Error while reading snapshot contents: " + e.getMessage());
                UnityPlayerBridge.sendMsg("PottingMobile", GoogleGameManager.LOAD_GAME, "{\"Code\":-1,\"Data\":\"\u62c9\u53d6\u5b58\u6863\u5931\u8d25\"}");
                if (GoogleGameManager.this.mLoadCallBack != null) {
                    GoogleGameManager.this.mLoadCallBack.failed(e.getMessage());
                }
            }
        });
    }

    private Task<SnapshotsClient.DataOrConflict<Snapshot>> waitForClosedAndOpen(final SnapshotMetadata snapshotMetadata) {
        boolean useMetadata;
        boolean bl = useMetadata = snapshotMetadata != null && snapshotMetadata.getUniqueName() != null;
        if (useMetadata) {
            LogUtils.i(TAG, "Opening snapshot using metadata: " + snapshotMetadata);
        } else {
            LogUtils.i(TAG, "Opening snapshot using currentSaveName: " + this.currentSaveName);
        }
        final String filename = useMetadata ? snapshotMetadata.getUniqueName() : this.currentSaveName;
        return SnapshotCoordinator.getInstance().waitForClosed(filename).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                GoogleGameManager.this.handleException(e, "There was a problem waiting for the file to close!");
                LogUtils.e(GoogleGameManager.TAG, "There was a problem waiting for the file to close!" + e.getMessage());
            }
        }).continueWithTask((Continuation)new Continuation<Result, Task<SnapshotsClient.DataOrConflict<Snapshot>>>(){

            public Task<SnapshotsClient.DataOrConflict<Snapshot>> then(@NonNull Task<Result> task) throws Exception {
                Task<SnapshotsClient.DataOrConflict<Snapshot>> openTask = useMetadata ? SnapshotCoordinator.getInstance().open(mSnapshotsClient, snapshotMetadata) : SnapshotCoordinator.getInstance().open(mSnapshotsClient, filename, true);
                return openTask.addOnFailureListener(new OnFailureListener(){

                    public void onFailure(@NonNull Exception e) {
                        LogUtils.e(GoogleGameManager.TAG, e.getMessage());
                        GoogleGameManager.this.handleException(e, useMetadata ? GoogleGameManager.this.activity.getString(R.string.error_opening_metadata) : GoogleGameManager.this.activity.getString(R.string.error_opening_filename));
                    }
                });
            }
        });
    }

    private void handleException(Exception exception, String details) {
        int status = 0;
        if (exception instanceof ApiException) {
            ApiException apiException = (ApiException)exception;
            status = apiException.getStatusCode();
        }
        String message = this.activity.getString(R.string.status_exception_error, new Object[]{details, status, exception});
        LogUtils.e(TAG, message);
        if (status == 26570) {
            LogUtils.i(TAG, "Error: Snapshot not found");
        } else if (status == 26572) {
            LogUtils.i(TAG, "Error: Snapshot contents unavailable");
        } else if (status == 26575) {
            LogUtils.i(TAG, "Error: Snapshot folder unavailable");
        }
    }

    static interface OnSnapshotCompleteListener {
        public void onSnapshotComplete(Snapshot var1);

        public void onSnapshotError(String var1);
    }
}

