/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.google;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.youloft.google.GoogleGameManager;

public class GoogleGameActivity
extends Activity {
    private GoogleGameManager googleGameManager;

    public static void loginGame(Activity activity, GoogleGameManager googleGameManager) {
        Intent intent = new Intent((Context)activity, GoogleGameActivity.class);
        intent.putExtra("type", 0);
        activity.startActivity(intent);
    }

    public static void finishActivity(Activity activity, GoogleGameManager googleGameManager) {
        Intent intent = new Intent((Context)activity, GoogleGameActivity.class);
        intent.putExtra("type", -1);
        intent.setFlags(0x4000000);
        activity.startActivity(intent);
    }

    public static void saveGame(Activity activity, GoogleGameManager googleGameManager, String saveName, String data) {
        Intent intent = new Intent((Context)activity, GoogleGameActivity.class);
        intent.putExtra("type", 1);
        intent.putExtra("saveName", saveName);
        intent.putExtra("gameData", data);
        activity.startActivity(intent);
    }

    public static void loadGame(Activity activity, GoogleGameManager googleGameManager, String saveName) {
        Intent intent = new Intent((Context)activity, GoogleGameActivity.class);
        intent.putExtra("type", 2);
        intent.putExtra("saveName", saveName);
        activity.startActivity(intent);
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.googleGameManager = GoogleGameManager.getInstance();
        if (this.googleGameManager == null) {
            return;
        }
        int type = this.getIntent().getIntExtra("type", 0);
        if (type == 0) {
            this.googleGameManager.loginGame(this);
        } else if (type == 1) {
            Intent intent = this.getIntent();
            String data = intent.getStringExtra("gameData");
            String saveName = intent.getStringExtra("saveName");
            this.googleGameManager.saveGame(this, saveName, data);
        } else if (type == 2) {
            String saveName = this.getIntent().getStringExtra("saveName");
            this.googleGameManager.loadGame(this, saveName);
        } else if (type == -1) {
            if (this.googleGameManager != null) {
                this.googleGameManager.onActivityResult(9999, 9999, null);
            }
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.googleGameManager != null) {
            this.googleGameManager.onActivityResult(requestCode, resultCode, data);
        }
    }
}

