/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.notification.local.util;

import android.content.Intent;
import android.os.Build;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import com.google.gson.Gson;
import com.youloft.notification.local.entities.LocalNotification;
import com.youloft.notification.local.entities.LocalNotificationHandler;
import com.youloft.notification.local.entities.LocalNotificationStatusHandler;
import com.youloft.notification.local.workers.TriggerNotificationWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LocalNotificationHelper {
    private static final String TAG = "LocalNotificationHelper";
    public static final String KEY_DATA = "LNH_DATA";
    private static String mDefaultTitle;
    @DrawableRes
    private static int mDefaultSmallIcon;
    @DrawableRes
    private static int mDefaultLargeIcon;
    private static boolean debugMode;
    private static String defaultActionActivity;

    public static String getDefaultTitle() {
        return mDefaultTitle;
    }

    public static void setDefaultTitle(String title) {
        mDefaultTitle = title;
    }

    public static int getDefaultSmallIcon() {
        return mDefaultSmallIcon;
    }

    public static int getDefaultLargeIcon() {
        return mDefaultLargeIcon;
    }

    public static void setDefaultSmallIcon(int icon) {
        mDefaultSmallIcon = icon;
    }

    public static void setDefaultLargeIcon(int icon) {
        mDefaultLargeIcon = icon;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean debugMode) {
        LocalNotificationHelper.debugMode = debugMode;
    }

    public static String getDefaultActionActivity() {
        return defaultActionActivity;
    }

    public static void setDefaultActionActivity(String defaultActionActivity) {
        LocalNotificationHelper.defaultActionActivity = defaultActionActivity;
    }

    public static void getAll(final LocalNotificationHandler callback) {
        final LiveData workStatusData = WorkManager.getInstance().getWorkInfosByTagLiveData("TriggerNotificationWorker");
        workStatusData.observeForever((Observer)new Observer<List<WorkInfo>>(){

            public void onChanged(@Nullable List<WorkInfo> workStatuses) {
                workStatusData.removeObserver((Observer)this);
                ArrayList<LocalNotification> localNotifications = new ArrayList<LocalNotification>();
                if (workStatuses != null && !workStatuses.isEmpty()) {
                    for (WorkInfo status : workStatuses) {
                        if (!LocalNotificationHelper.isStatusScheduled(status)) continue;
                        for (String tag : status.getTags()) {
                            try {
                                LocalNotification notification = (LocalNotification)new Gson().fromJson(tag, LocalNotification.class);
                                if (notification == null) continue;
                                localNotifications.add(notification);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                callback.onNotificationReceived(localNotifications);
            }
        });
    }

    public static List<LocalNotification> getAllSync() {
        ArrayList workStatuses = new ArrayList();
        ArrayList<LocalNotification> localNotifications = new ArrayList<LocalNotification>();
        if (!workStatuses.isEmpty()) {
            for (WorkInfo status : workStatuses) {
                if (!LocalNotificationHelper.isStatusScheduled(status)) continue;
                for (String tag : status.getTags()) {
                    try {
                        LocalNotification notification = (LocalNotification)new Gson().fromJson(tag, LocalNotification.class);
                        if (notification == null) continue;
                        localNotifications.add(notification);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return localNotifications;
    }

    public static void cancel(int notificationId) {
        WorkManager.getInstance().cancelAllWorkByTag(notificationId + "");
    }

    public static void cancel(LocalNotification notification) {
        LocalNotificationHelper.cancel(notification.notificationId);
    }

    public static void cancelAll() {
        WorkManager.getInstance().cancelAllWork();
    }

    public static void isScheduled(int notificationId, final LocalNotificationStatusHandler callback) {
        final LiveData workStatusData = WorkManager.getInstance().getWorkInfosByTagLiveData(notificationId + "");
        workStatusData.observeForever((Observer)new Observer<List<WorkInfo>>(){

            public void onChanged(@Nullable List<WorkInfo> workStatuses) {
                workStatusData.removeObserver((Observer)this);
                if (workStatuses != null && !workStatuses.isEmpty()) {
                    WorkInfo status = workStatuses.get(0);
                    if (LocalNotificationHelper.isStatusScheduled(status)) {
                        callback.onNotificationStatusReceived(true);
                    } else {
                        callback.onNotificationStatusReceived(false);
                    }
                } else {
                    callback.onNotificationStatusReceived(false);
                }
            }
        });
    }

    public static boolean isScheduledSync(int notificationId) {
        return false;
    }

    public static void scheduleNotificationJob(LocalNotification notification) {
        OneTimeWorkRequest.Builder builder = new OneTimeWorkRequest.Builder(TriggerNotificationWorker.class);
        builder.addTag("TriggerNotificationWorker");
        builder.addTag(notification.toTag());
        builder.addTag(notification.notificationId + "");
        builder.setInitialDelay(notification.triggerDelay, TimeUnit.MILLISECONDS);
        WorkManager.getInstance().enqueue(builder.build());
    }

    @Nullable
    public static String parseNotificationData(Intent intent) {
        if (intent == null) {
            return null;
        }
        return intent.getStringExtra(KEY_DATA);
    }

    @Deprecated
    public static void destroy() {
    }

    private static boolean isStatusScheduled(WorkInfo status) {
        return status.getState() == WorkInfo.State.ENQUEUED || status.getState() == WorkInfo.State.BLOCKED;
    }

    static /* synthetic */ String access$000() {
        return mDefaultTitle;
    }

    static /* synthetic */ String access$100() {
        return defaultActionActivity;
    }

    static /* synthetic */ int access$200() {
        return mDefaultSmallIcon;
    }

    static /* synthetic */ int access$300() {
        return mDefaultLargeIcon;
    }

    static {
        mDefaultSmallIcon = -1;
        mDefaultLargeIcon = -1;
        debugMode = false;
        defaultActionActivity = null;
    }

    public static class Scheduler {
        private int notificationId;
        private String channelId;
        private String textTitle = LocalNotificationHelper.access$000();
        private String textContent;
        private String activity = LocalNotificationHelper.access$100();
        private String data;
        private int smallIcon = LocalNotificationHelper.access$200();
        private int largeIcon = LocalNotificationHelper.access$300();
        private long triggerTime;
        private long triggerDelay;
        private long repeatDelay;

        public Scheduler(int notificationId, String textContent) {
            this.notificationId = notificationId;
            this.textContent = textContent;
        }

        public Scheduler setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Scheduler setTextTitle(String textTitle) {
            this.textTitle = textTitle;
            return this;
        }

        public Scheduler setActivity(String activity) {
            this.activity = activity;
            return this;
        }

        public Scheduler setData(String data) {
            this.data = data;
            return this;
        }

        public Scheduler setSmallIcon(int smallIcon) {
            this.smallIcon = smallIcon;
            return this;
        }

        public Scheduler setLargeIcon(int largeIcon) {
            this.largeIcon = largeIcon;
            return this;
        }

        public Scheduler setTriggerTime(long triggerTime) {
            this.triggerTime = triggerTime;
            return this;
        }

        public Scheduler setTriggerDelay(long triggerDelay) {
            this.triggerDelay = triggerDelay;
            return this;
        }

        public Scheduler setTriggerTime(Date time) {
            long delay = time.getTime() - System.currentTimeMillis();
            if (delay < 0L) {
                delay = 0L;
            }
            this.triggerDelay = delay;
            return this;
        }

        public Scheduler setRepeatDelay(long repeatDelay) {
            this.repeatDelay = repeatDelay;
            return this;
        }

        public LocalNotification schedule() {
            if (!debugMode && this.repeatDelay > 0L && this.repeatDelay < 900000L) {
                throw new IllegalArgumentException("Unable to schedule repeating notification with repeat time less then [900000] millis");
            }
            LocalNotificationHelper.cancel(this.notificationId);
            if ((this.channelId == null || this.channelId.trim().length() == 0) && Build.VERSION.SDK_INT >= 26) {
                this.channelId = "Potting Mob";
            }
            LocalNotification notification = new LocalNotification();
            notification.notificationId = this.notificationId;
            notification.channelId = this.channelId;
            notification.smallIcon = this.smallIcon;
            notification.largeIcon = this.largeIcon;
            notification.textTitle = this.textTitle;
            notification.textContent = this.textContent;
            notification.triggerTime = System.currentTimeMillis() + this.triggerDelay;
            notification.triggerDelay = this.triggerDelay;
            notification.repeatDelay = this.repeatDelay;
            notification.activity = this.activity;
            notification.data = this.data;
            LocalNotificationHelper.scheduleNotificationJob(notification);
            return notification;
        }
    }
}

