/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.notification.firebase.service;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.youloft.R;
import com.youloft.notification.local.NotificationUtil;
import java.util.Map;

public class YouLoftFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String TAG = "MyFirebaseMsgService";

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Log.d((String)TAG, (String)("From: " + remoteMessage.getFrom()));
        Map map = remoteMessage.getData();
        Log.d((String)TAG, (String)map.toString());
        Log.d((String)TAG, (String)("Message data payload: " + remoteMessage.getData()));
        if (remoteMessage.getNotification() != null) {
            NotificationUtil.SetLocalNotification(7102, remoteMessage.getNotification().getTitle(), remoteMessage.getNotification().getBody(), 0);
            Log.d((String)TAG, (String)("Message Notification Body: " + remoteMessage.getNotification().getBody()));
        }
    }

    public void onNewToken(String token) {
        Log.d((String)TAG, (String)("Refreshed token: " + token));
        this.sendRegistrationToServer(token);
    }

    public void onDeletedMessages() {
        super.onDeletedMessages();
    }

    private void sendRegistrationToServer(String token) {
    }

    private void sendNotification(String title, String messageBody) {
        Intent intent = YouLoftFirebaseMessagingService.getLauncherActivityIntent((Context)this);
        intent.addFlags(0x4000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x40000000);
        String channelId = this.getString(R.string.default_notification_channel_name);
        Uri defaultSoundUri = RingtoneManager.getDefaultUri((int)2);
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder((Context)this, channelId).setSmallIcon(R.drawable.inh_ic_stat_default).setContentTitle((CharSequence)title).setContentText((CharSequence)messageBody).setLights(-65536, 1000, 1000).setAutoCancel(true).setSound(defaultSoundUri).setContentIntent(pendingIntent);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)"Channel human readable title", 3);
            notificationManager.createNotificationChannel(channel);
        }
        notificationManager.notify(0, notificationBuilder.build());
    }

    public static Intent getLauncherActivityIntent(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = Build.VERSION.SDK_INT >= 3 ? packageManager.getLaunchIntentForPackage(context.getPackageName()) : new Intent(context, null);
        return intent;
    }
}

