/*
 * Decompiled with CFR 0.152.
 */
package com.youloft.googlepay;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.alibaba.fastjson.JSONObject;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.QueryPurchasesParams;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.youloft.core.YouLoftSdk;
import com.youloft.core.utils.LogUtils;
import com.youloft.googlepay.PayCallBack;
import com.youloft.googlepay.QueryPurchasesListener;
import com.youloft.googlepay.R;
import com.youloft.googlepay.SPUtils;
import com.youloft.googlepay.UnityPlayerBridge;
import com.youloft.statistics.StatisticsManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class PayUtil {
    private static final String NO_SERVICE = "-1";
    private static final String OK = "1";
    private static final String ERROR = "0";
    private static final String USER_CANCEL = "2";
    private static final String ITEM_UNAVAILABLE = "3";
    private static final String ITEM_ALREADY_OWNED = "4";
    private static final String SKU_DETAIL = "SkuDetail";
    private static final String UNITY_OBJECT = "PottingMobile";
    public static final String INAPP = "inapp";
    public static final String SUBS = "subs";
    private static final String TAG = PayUtil.class.getSimpleName();
    private Activity activity;
    private BillingClient billingClient;
    private String mSkuId;
    private String mSkuType;
    private String actId = "";
    private PayCallBack mPayCallBack;
    private QueryPurchasesListener mQueryPurchasesListener;
    private PurchasesUpdatedListener purchasesUpdatedListener = new PurchasesUpdatedListener(){

        public void onPurchasesUpdated(BillingResult billingResult, List<Purchase> purchases) {
            if (billingResult.getResponseCode() == 0 && purchases != null) {
                UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.OK);
                if (PayUtil.this.mPayCallBack != null) {
                    PayUtil.this.mPayCallBack.onPaySuccess(purchases);
                }
                for (Purchase purchase : purchases) {
                    LogUtils.e((String)"onPurchasesUpdated");
                    PayUtil.this.handlePurchase(PayUtil.this.mSkuType, purchase);
                }
            } else if (billingResult.getResponseCode() == 1) {
                UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.USER_CANCEL);
                if (PayUtil.this.mPayCallBack != null) {
                    PayUtil.this.mPayCallBack.onPayFail(PayUtil.USER_CANCEL);
                }
                if (PayUtil.this.isNotnullActivity(PayUtil.this.activity)) {
                    Toast.makeText((Context)PayUtil.this.activity, (CharSequence)PayUtil.this.activity.getString(R.string.user_cancel), (int)1).show();
                }
                PayUtil.this.endConnect("onPurchasesUpdated--USER_CANCELED");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("projectId", (Object)PayUtil.this.mSkuId);
                jsonObject.put("errorMsg", (Object)PayUtil.USER_CANCEL);
                PayUtil.sendEvent("PayFail", jsonObject.toJSONString());
            } else if (billingResult.getResponseCode() == 7) {
                UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.ERROR);
                LogUtils.e((String)("ResponseCode:" + billingResult.getResponseCode()));
                if (PayUtil.this.mPayCallBack != null) {
                    PayUtil.this.mPayCallBack.onPayFail(PayUtil.ERROR);
                }
                if (PayUtil.this.isNotnullActivity(PayUtil.this.activity)) {
                    Toast.makeText((Context)PayUtil.this.activity, (CharSequence)"ITEM_ALREADY_OWNED", (int)1).show();
                }
                PayUtil.this.endConnect("onPurchasesUpdated--ITEM_ALREADY_OWNED");
                PayUtil.this.checkPurchases(PayUtil.this.activity, PayUtil.this.mSkuType);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("projectId", (Object)PayUtil.this.mSkuId);
                jsonObject.put("errorMsg", (Object)PayUtil.ERROR);
                PayUtil.sendEvent("PayFail", jsonObject.toJSONString());
            } else {
                UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.ERROR);
                LogUtils.e((String)("ResponseCode:" + billingResult.getResponseCode()));
                if (PayUtil.this.mPayCallBack != null) {
                    PayUtil.this.mPayCallBack.onPayFail(PayUtil.ERROR);
                }
                if (PayUtil.this.isNotnullActivity(PayUtil.this.activity)) {
                    Toast.makeText((Context)PayUtil.this.activity, (CharSequence)PayUtil.this.activity.getString(R.string.pay_error), (int)1).show();
                }
                PayUtil.this.endConnect("onPurchasesUpdated--PayFail");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("projectId", (Object)PayUtil.this.mSkuId);
                jsonObject.put("errorMsg", (Object)PayUtil.ERROR);
                PayUtil.sendEvent("PayFail", jsonObject.toJSONString());
            }
        }
    };

    public void setPayCallBack(PayCallBack payCallBack) {
        if (payCallBack != null) {
            this.mPayCallBack = payCallBack;
        }
    }

    public void setQueryPurchasesListener(QueryPurchasesListener queryPurchasesListener) {
        this.mQueryPurchasesListener = queryPurchasesListener;
    }

    public void InternalPay(Activity activity, String skuId, String skuType, String acId) {
        this.InternalPay(activity, skuId, skuType, acId, "youloft", "youloft");
    }

    private boolean isNotnullActivity(Activity activity) {
        if (activity != null) {
            Log.d((String)"YouLoft", (String)"activity is not null");
            return true;
        }
        LogUtils.e((String)"activity is null");
        return false;
    }

    public void InternalPay(Activity con, final String skuId, final String skuType, String acId, final String accountId, final String profileId) {
        this.activity = con;
        if (this.activity == null || skuId.isEmpty() || skuType.isEmpty()) {
            LogUtils.e((String)"PayUtil", (String)"\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38");
            return;
        }
        this.actId = acId;
        this.isNotnullActivity(this.activity);
        this.mSkuId = skuId;
        this.mSkuType = skuType;
        if (this.billingClient != null) {
            this.endConnect("InternalPay billingClient=null");
        }
        this.billingClient = BillingClient.newBuilder((Context)this.activity).setListener(this.purchasesUpdatedListener).enablePendingPurchases().build();
        this.billingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                if (billingResult.getResponseCode() == 0) {
                    BillingResult featureSupportedResult = PayUtil.this.billingClient.isFeatureSupported("fff");
                    if (featureSupportedResult.getResponseCode() == 0) {
                        Log.d((String)TAG, (String)"Device supports product details");
                    } else {
                        Log.e((String)TAG, (String)"Device does not support product details");
                    }
                    PayUtil.this.launchBillingFlow(skuId, skuType, accountId, profileId);
                } else {
                    LogUtils.e((String)TAG, (String)billingResult.getDebugMessage());
                    UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.NO_SERVICE);
                    if (PayUtil.this.mPayCallBack != null) {
                        PayUtil.this.mPayCallBack.onPayFail(PayUtil.NO_SERVICE);
                    }
                }
            }

            public void onBillingServiceDisconnected() {
            }
        });
        PayUtil.sendEvent("CallPay", "{\"projectId\":\"" + skuId + "\"}");
    }

    public void checkPurchases(Activity activity, final String skuType) {
        this.billingClient = BillingClient.newBuilder((Context)activity).setListener(this.purchasesUpdatedListener).enablePendingPurchases().build();
        this.billingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                PayUtil.this.billingClient.queryPurchasesAsync(QueryPurchasesParams.newBuilder().setProductType(skuType).build(), new PurchasesResponseListener(){

                    public void onQueryPurchasesResponse(BillingResult billingResult, List<Purchase> purchases) {
                        LogUtils.d((String)TAG, (String)purchases.toString());
                        if (purchases != null) {
                            for (int i = 0; i < purchases.size(); ++i) {
                                if (purchases.get(i).isAcknowledged()) continue;
                                PayUtil.this.handleCheckPurchase(skuType, purchases.get(i));
                            }
                        } else {
                            PayUtil.this.endConnect("checkPurchases");
                        }
                    }
                });
            }

            public void onBillingServiceDisconnected() {
            }
        });
    }

    public void queryPurchases(Activity con, final String skuType) {
        this.activity = con;
        LogUtils.e((String)"st queryPurchases");
        this.billingClient = BillingClient.newBuilder((Context)this.activity).setListener(this.purchasesUpdatedListener).enablePendingPurchases().build();
        this.billingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                PayUtil.this.billingClient.queryPurchasesAsync(QueryPurchasesParams.newBuilder().setProductType(skuType).build(), new PurchasesResponseListener(){

                    public void onQueryPurchasesResponse(BillingResult billingResult, List<Purchase> purchases) {
                        LogUtils.e((String)"onQueryPurchasesResponse");
                        ArrayList<String> list = new ArrayList<String>();
                        if (purchases != null && purchases.size() > 0) {
                            for (int i = 0; i < purchases.size(); ++i) {
                                list.add(purchases.get(i).getOriginalJson());
                                LogUtils.e((String)"for queryPurchases");
                                PayUtil.this.handlePurchase(skuType, purchases.get(i));
                            }
                            JSONArray jsonArray = new JSONArray(list);
                            LogUtils.d((String)TAG, (String)jsonArray.toString());
                            LogUtils.e((String)"sendMsg Purchase");
                            UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "Purchase", jsonArray.toString());
                            LogUtils.e((String)"sendMsg Purchase end");
                            if (PayUtil.this.mQueryPurchasesListener != null) {
                                PayUtil.this.mQueryPurchasesListener.onSuccess(purchases);
                            }
                        } else {
                            if (PayUtil.this.mQueryPurchasesListener != null) {
                                PayUtil.this.mQueryPurchasesListener.onNoData();
                            }
                            LogUtils.e((String)"sendMsg Purchase");
                            UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "Purchase", "");
                            LogUtils.e((String)"sendMsg Purchase end");
                            PayUtil.this.endConnect("queryPurchases null");
                        }
                    }
                });
            }

            public void onBillingServiceDisconnected() {
            }
        });
    }

    public void queryHistoryPurchases(Activity activity, final String skuType) {
        this.billingClient = BillingClient.newBuilder((Context)activity).setListener(this.purchasesUpdatedListener).enablePendingPurchases().build();
        this.billingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                PayUtil.this.billingClient.queryPurchaseHistoryAsync(skuType, new PurchaseHistoryResponseListener(){

                    public void onPurchaseHistoryResponse(BillingResult billingResult, List<PurchaseHistoryRecord> purchaseHistoryRecordList) {
                        ArrayList<String> list = new ArrayList<String>();
                        if (purchaseHistoryRecordList != null) {
                            for (int i = 0; i < purchaseHistoryRecordList.size(); ++i) {
                                list.add(purchaseHistoryRecordList.get(i).getOriginalJson());
                            }
                            String str = PayUtil.this.listToJson(list);
                            LogUtils.d((String)TAG, (String)str);
                            UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "HistoryPurchase", str);
                        } else {
                            UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "HistoryPurchase", "");
                        }
                    }
                });
                PayUtil.this.endConnect("queryHistoryPurchases");
            }

            public void onBillingServiceDisconnected() {
            }
        });
    }

    public void querySkuDetail(Activity con, String skuIdJson) {
        this.activity = con;
        if (this.activity == null) {
            LogUtils.e((String)"PayUtil", (String)"\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38");
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, SKU_DETAIL, "");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)skuIdJson)) {
            UnityPlayerBridge.sendMsg(UNITY_OBJECT, SKU_DETAIL, "");
            LogUtils.e((String)"PayUtil", (String)"\u67e5\u8be2ID\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        final List skuIds = (List)new Gson().fromJson(skuIdJson, new TypeToken<List<String>>(){}.getType());
        final ArrayList list = new ArrayList();
        this.billingClient = BillingClient.newBuilder((Context)this.activity).setListener(this.purchasesUpdatedListener).enablePendingPurchases().build();
        this.billingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                if (billingResult.getResponseCode() == 0) {
                    final SkuDetailsParams.Builder params = SkuDetailsParams.newBuilder();
                    params.setSkusList(skuIds).setType(PayUtil.INAPP);
                    PayUtil.this.billingClient.querySkuDetailsAsync(params.build(), new SkuDetailsResponseListener(){

                        public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> skuDetailsList) {
                            if (skuDetailsList != null && skuDetailsList.size() > 0) {
                                for (SkuDetails skuDetails : skuDetailsList) {
                                    list.add(skuDetails.getOriginalJson());
                                }
                            }
                            params.setSkusList(skuIds).setType(PayUtil.SUBS);
                            PayUtil.this.billingClient.querySkuDetailsAsync(params.build(), new SkuDetailsResponseListener(){

                                public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> skuDetailsList) {
                                    if (skuDetailsList != null && skuDetailsList.size() > 0) {
                                        for (SkuDetails skuDetails : skuDetailsList) {
                                            list.add(skuDetails.getOriginalJson());
                                        }
                                    }
                                    String str = PayUtil.this.listToJson(list);
                                    LogUtils.d((String)"SKU", (String)str);
                                    UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, PayUtil.SKU_DETAIL, str);
                                    new SPUtils((Context)PayUtil.this.activity).putString(PayUtil.SKU_DETAIL, str);
                                    PayUtil.this.endConnect("querySkuDetail");
                                }
                            });
                        }
                    });
                }
            }

            public void onBillingServiceDisconnected() {
            }
        });
    }

    private void launchBillingFlow(final String skuId, String type, final String accountId, final String profileId) {
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.add(skuId);
        SkuDetailsParams.Builder params = SkuDetailsParams.newBuilder();
        params.setSkusList(skuList).setType(type);
        this.billingClient.querySkuDetailsAsync(params.build(), new SkuDetailsResponseListener(){

            public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> skuDetailsList) {
                if (billingResult.getResponseCode() == 0 && skuDetailsList != null && skuDetailsList.size() > 0) {
                    for (SkuDetails skuDetails : skuDetailsList) {
                        String sku = skuDetails.getSku();
                        if (!sku.equals(skuId)) continue;
                        BillingFlowParams flowParams = BillingFlowParams.newBuilder().setSkuDetails(skuDetails).setObfuscatedAccountId(accountId).setObfuscatedProfileId(profileId).build();
                        PayUtil.this.billingClient.launchBillingFlow(PayUtil.this.activity, flowParams);
                    }
                } else if (billingResult.getResponseCode() == 7) {
                    UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.ITEM_ALREADY_OWNED);
                    if (PayUtil.this.mPayCallBack != null) {
                        PayUtil.this.mPayCallBack.onPayFail(PayUtil.ITEM_ALREADY_OWNED);
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("projectId", (Object)skuId);
                    jsonObject.put("errorMsg", (Object)PayUtil.ITEM_ALREADY_OWNED);
                    PayUtil.sendEvent("PayFail", jsonObject.toJSONString());
                } else if (billingResult.getResponseCode() == 4) {
                    UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.ITEM_UNAVAILABLE);
                    if (PayUtil.this.mPayCallBack != null) {
                        PayUtil.this.mPayCallBack.onPayFail(PayUtil.ITEM_UNAVAILABLE);
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("projectId", (Object)skuId);
                    jsonObject.put("errorMsg", (Object)PayUtil.ITEM_UNAVAILABLE);
                    PayUtil.sendEvent("PayFail", jsonObject.toJSONString());
                } else {
                    UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "internalPayResult", PayUtil.ERROR);
                    LogUtils.e((String)("ResponseCode:" + billingResult.getResponseCode()));
                    if (PayUtil.this.mPayCallBack != null) {
                        PayUtil.this.mPayCallBack.onPayFail(PayUtil.ERROR);
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("projectId", (Object)skuId);
                    jsonObject.put("errorMsg", (Object)PayUtil.ERROR);
                    PayUtil.sendEvent("PayFail", jsonObject.toJSONString());
                }
            }
        });
    }

    private void handlePurchase(String mSkuType, final Purchase purchase) {
        if (purchase.getPurchaseState() == 1) {
            if (!purchase.isAcknowledged()) {
                if (!TextUtils.isEmpty((CharSequence)mSkuType)) {
                    if (mSkuType.equals(SUBS)) {
                        AcknowledgePurchaseParams acknowledgePurchaseParams = AcknowledgePurchaseParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
                        this.billingClient.acknowledgePurchase(acknowledgePurchaseParams, new AcknowledgePurchaseResponseListener(){

                            public void onAcknowledgePurchaseResponse(BillingResult billingResult) {
                                if (billingResult.getResponseCode() == 0) {
                                    if (PayUtil.this.mPayCallBack != null) {
                                        PayUtil.this.mPayCallBack.onAcknowledgePurchaseResponse(purchase, billingResult);
                                    }
                                    UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "acknowledgePurchase", purchase.getOriginalJson());
                                    LogUtils.d((String)"pay", (String)purchase.getOriginalJson());
                                    PayUtil.this.handlePurchase(purchase, PayUtil.SUBS);
                                }
                            }
                        });
                    } else if (mSkuType.equals(INAPP)) {
                        ConsumeParams consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
                        this.billingClient.consumeAsync(consumeParams, new ConsumeResponseListener(){

                            public void onConsumeResponse(BillingResult billingResult, String purchaseToken) {
                                if (billingResult.getResponseCode() == 0) {
                                    if (PayUtil.this.mPayCallBack != null) {
                                        PayUtil.this.mPayCallBack.onAcknowledgePurchaseResponse(purchase, billingResult);
                                    }
                                    LogUtils.d((String)"pay", (String)purchase.getOriginalJson());
                                    PayUtil.this.handlePurchase(purchase, PayUtil.INAPP);
                                    UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "acknowledgePurchase", purchase.getOriginalJson());
                                }
                            }
                        });
                    }
                } else {
                    this.endConnect("handlePurchase mSkuType");
                }
                PayUtil.sendEvent("youloftpaysuccess", "{\"projectId\":\"" + purchase.getSkus().toString() + "\"}");
            } else {
                this.endConnect("handlePurchase !isAcknowledged");
            }
        } else {
            this.endConnect("handlePurchase getPurchaseState");
        }
    }

    private void endConnect(String form) {
        LogUtils.e((String)("endConnect " + form));
        if (this.billingClient.isReady()) {
            this.billingClient.endConnection();
            LogUtils.e((String)("endConnect end " + form));
        }
    }

    private void handlePurchase(final Purchase purchase, final String type) {
        final ArrayList skuIds = new ArrayList();
        if (this.activity == null) {
            LogUtils.e((String)"activity null");
        }
        if (this.purchasesUpdatedListener == null) {
            LogUtils.e((String)"purchasesUpdatedListener null");
        }
        this.billingClient = BillingClient.newBuilder((Context)this.activity).setListener(this.purchasesUpdatedListener).enablePendingPurchases().build();
        this.billingClient.startConnection(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                if (billingResult.getResponseCode() == 0) {
                    SkuDetailsParams.Builder params = SkuDetailsParams.newBuilder();
                    if (type.equals(PayUtil.INAPP)) {
                        params.setSkusList((List)purchase.getSkus()).setType(PayUtil.INAPP);
                        PayUtil.this.billingClient.querySkuDetailsAsync(params.build(), new SkuDetailsResponseListener(){

                            public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> skuDetailsList) {
                                if (skuDetailsList != null && skuDetailsList.size() > 0) {
                                    for (SkuDetails skuDetails : skuDetailsList) {
                                        PayUtil.validateAndTrackInAppPurchase(PayUtil.this.actId, YouLoftSdk.PUBLIC_KEY, purchase.getSignature(), purchase.getOriginalJson(), skuDetails.getPriceAmountMicros(), skuDetails.getPriceCurrencyCode(), PayUtil.INAPP);
                                    }
                                }
                                PayUtil.this.endConnect("handlePurchase INAPP");
                            }
                        });
                    }
                    if (type.equals(PayUtil.SUBS)) {
                        params.setSkusList(skuIds).setType(PayUtil.SUBS);
                        PayUtil.this.billingClient.querySkuDetailsAsync(params.build(), new SkuDetailsResponseListener(){

                            public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> skuDetailsList) {
                                if (skuDetailsList != null && skuDetailsList.size() > 0) {
                                    for (SkuDetails skuDetails : skuDetailsList) {
                                        PayUtil.validateAndTrackInAppPurchase(PayUtil.this.actId, YouLoftSdk.PUBLIC_KEY, purchase.getSignature(), purchase.getOriginalJson(), skuDetails.getPriceAmountMicros(), skuDetails.getPriceCurrencyCode(), PayUtil.SUBS);
                                    }
                                }
                                PayUtil.this.endConnect("handlePurchase SUBS");
                            }
                        });
                    }
                }
            }

            public void onBillingServiceDisconnected() {
            }
        });
    }

    public static void validateAndTrackInAppPurchase(String actId, String publicKey, String signature, String purchaseData, long price, String priceCurrencyCode, String skuType) {
        try {
            Class<?> threadClazz = Class.forName("com.youloft.statistics.StatisticsManager");
            Method method = threadClazz.getMethod("validateAndTrackInAppPurchase", String.class, String.class, String.class, Long.TYPE, String.class, String.class, String.class);
            method.invoke(null, publicKey, signature, purchaseData, price, priceCurrencyCode, skuType, actId);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void sendEvent(String eventName, String eventValues) {
        StatisticsManager.customEvent((String)eventName, (String)eventValues);
    }

    private void handleCheckPurchase(String mSkuType, final Purchase purchase) {
        if (purchase.getPurchaseState() == 1 && !purchase.isAcknowledged() && !TextUtils.isEmpty((CharSequence)mSkuType)) {
            if (mSkuType.equals(SUBS)) {
                AcknowledgePurchaseParams acknowledgePurchaseParams = AcknowledgePurchaseParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
                this.billingClient.acknowledgePurchase(acknowledgePurchaseParams, new AcknowledgePurchaseResponseListener(){

                    public void onAcknowledgePurchaseResponse(BillingResult billingResult) {
                        UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "CheckPurchase", PayUtil.SUBS);
                        PayUtil.this.handlePurchase(purchase, PayUtil.SUBS);
                    }
                });
            } else if (mSkuType.equals(INAPP)) {
                ConsumeParams consumeParams = ConsumeParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
                this.billingClient.consumeAsync(consumeParams, new ConsumeResponseListener(){

                    public void onConsumeResponse(BillingResult billingResult, String purchaseToken) {
                        UnityPlayerBridge.sendMsg(PayUtil.UNITY_OBJECT, "CheckPurchase", PayUtil.INAPP);
                        PayUtil.this.handlePurchase(purchase, PayUtil.INAPP);
                    }
                });
            }
        }
    }

    private String listToJson(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (list.size() > 0) {
            for (String obj : list) {
                json.append(obj);
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }
}

