/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.unity3d.player.A0;
import com.unity3d.player.AudioVolumeHandler;
import com.unity3d.player.C0;
import com.unity3d.player.Camera2Wrapper;
import com.unity3d.player.D0;
import com.unity3d.player.E0;
import com.unity3d.player.F;
import com.unity3d.player.GoogleARCoreApi;
import com.unity3d.player.HFPStatus;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.MultiWindowSupport;
import com.unity3d.player.NativeLoader;
import com.unity3d.player.NetworkConnectivity;
import com.unity3d.player.NetworkConnectivityNougat;
import com.unity3d.player.O0;
import com.unity3d.player.OrientationLockListener;
import com.unity3d.player.P0;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.T;
import com.unity3d.player.UnityPermissions;
import com.unity3d.player.V;
import com.unity3d.player.W;
import com.unity3d.player.Y;
import com.unity3d.player.Z;
import com.unity3d.player.a.d;
import com.unity3d.player.a.e;
import com.unity3d.player.a0;
import com.unity3d.player.b0;
import com.unity3d.player.c0;
import com.unity3d.player.d0;
import com.unity3d.player.e0;
import com.unity3d.player.f0;
import com.unity3d.player.g0;
import com.unity3d.player.h0;
import com.unity3d.player.i0;
import com.unity3d.player.j0;
import com.unity3d.player.k0;
import com.unity3d.player.l0;
import com.unity3d.player.m0;
import com.unity3d.player.n0;
import com.unity3d.player.o0;
import com.unity3d.player.p0;
import com.unity3d.player.q0;
import com.unity3d.player.r0;
import com.unity3d.player.s;
import com.unity3d.player.s0;
import com.unity3d.player.t;
import com.unity3d.player.t0;
import com.unity3d.player.u0;
import com.unity3d.player.v0;
import com.unity3d.player.w0;
import com.unity3d.player.x0;
import com.unity3d.player.y0;
import com.unity3d.player.z0;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class UnityPlayer
extends FrameLayout
implements IUnityPlayerLifecycleEvents {
    public static Activity currentActivity;
    public static Context currentContext;
    public static UnityPlayer currentUnityPlayer;
    private static final int RUN_STATE_CHANGED_MSG_CODE = 2269;
    private static String m_InstantGameRoot;
    private static String m_InstantGameEngineRoot;
    protected static String m_InstantGameName;
    private static String m_InstantGameEngine;
    private static String m_JNIWhiteList;
    private static final String SPLASH_ENABLE_METADATA_NAME = "tuanjie.splash-enable";
    private static final String SPLASH_MODE_METADATA_NAME = "tuanjie.splash-mode";
    private static final String LAUNCH_FULLSCREEN = "tuanjie.launch-fullscreen";
    private static final String ARCORE_ENABLE_METADATA_NAME = "tuanjie.arcore-enable";
    private static final String AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME = "tuanjie.auto-report-fully-drawn";
    Handler mHandler;
    private IHostPermission mHostPermission;
    private int mInitialScreenOrientation;
    private boolean mMainDisplayOverride;
    private boolean mIsFullscreen;
    private E0 mState;
    private final ConcurrentLinkedQueue m_Events;
    private OrientationEventListener mOrientationListener;
    private int mNaturalOrientation;
    private Configuration prevConfig;
    C0 m_MainThread;
    private boolean m_AddPhoneCallListener;
    private z0 m_PhoneCallListener;
    private TelephonyManager m_TelephonyManager;
    private ClipboardManager m_ClipboardManager;
    private e m_SplashScreen;
    private GoogleARCoreApi m_ARCoreApi;
    private y0 m_FakeListener;
    private Camera2Wrapper m_Camera2Wrapper;
    private HFPStatus m_HFPStatus;
    private AudioVolumeHandler m_AudioVolumeHandler;
    private OrientationLockListener m_OrientationLockListener;
    private Uri m_launchUri;
    private NetworkConnectivity m_NetworkConnectivity;
    private IUnityPlayerLifecycleEvents m_UnityPlayerLifecycleEvents;
    private int m_IsNoWindowMode;
    Window m_Window;
    private Context mContext;
    private Activity mActivity;
    private V mGlView;
    private boolean mQuitting;
    private boolean mProcessKillRequested;
    private P0 mVideoPlayerProxy;
    F mSoftInput;

    public UnityPlayer(Context context) {
        this(context, null);
    }

    public UnityPlayer(Context object, IUnityPlayerLifecycleEvents object2) {
        super(object);
        HFPStatus hFPStatus;
        Camera2Wrapper camera2Wrapper;
        V v2;
        y0 y02;
        z0 z02;
        C0 c02;
        ConcurrentLinkedQueue concurrentLinkedQueue;
        E0 e02;
        Handler handler;
        Object object3 = handler;
        handler = new Handler();
        this.mHandler = object3;
        this.mHostPermission = null;
        this.mInitialScreenOrientation = -1;
        this.mMainDisplayOverride = false;
        this.mIsFullscreen = true;
        object3 = e02;
        e02 = new E0();
        this.mState = object3;
        object3 = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        this.m_Events = object3;
        this.mOrientationListener = null;
        object3 = c02;
        c02 = new C0(this);
        this.m_MainThread = object3;
        this.m_AddPhoneCallListener = false;
        object3 = z02;
        z02 = new z0(this);
        this.m_PhoneCallListener = object3;
        this.m_ARCoreApi = null;
        object3 = y02;
        y02 = new y0();
        this.m_FakeListener = object3;
        this.m_Camera2Wrapper = null;
        this.m_HFPStatus = null;
        this.m_AudioVolumeHandler = null;
        this.m_OrientationLockListener = null;
        this.m_launchUri = null;
        this.m_NetworkConnectivity = null;
        this.m_UnityPlayerLifecycleEvents = null;
        this.m_IsNoWindowMode = -1;
        this.mProcessKillRequested = true;
        this.mSoftInput = null;
        if (currentUnityPlayer == null) {
            currentUnityPlayer = this;
        }
        if (object2 == null) {
            object2 = this;
        }
        Context context = object;
        this.m_UnityPlayerLifecycleEvents = object2;
        T.a(UnityPlayer.getUnityNativeLibraryPath(context));
        currentContext = context;
        if (context instanceof Activity) {
            currentActivity = this.mActivity = (Activity)object;
            this.mInitialScreenOrientation = this.mActivity.getRequestedOrientation();
            this.m_launchUri = this.mActivity.getIntent().getData();
        }
        m_InstantGameRoot = currentActivity.getIntent().getStringExtra("instantGameRoot");
        m_InstantGameEngineRoot = currentActivity.getIntent().getStringExtra("instantGameEngineRoot");
        m_InstantGameName = currentActivity.getIntent().getStringExtra("instantGame");
        m_InstantGameEngine = currentActivity.getIntent().getStringExtra("engineFolder");
        m_JNIWhiteList = currentActivity.getIntent().getStringExtra("jniWhiteList");
        if (m_InstantGameEngine == null) {
            m_InstantGameEngine = "2022";
        }
        if (m_InstantGameRoot == null) {
            m_InstantGameRoot = currentActivity.getFilesDir().getAbsolutePath();
        }
        if (m_InstantGameEngineRoot == null) {
            m_InstantGameEngineRoot = currentActivity.getFilesDir().getAbsolutePath();
        }
        if ((object2 = currentActivity.getIntent().getStringExtra("unity")) == null) {
            object2 = "";
        }
        if (m_InstantGameName != null) {
            object2 = (String)object2 + " -instantGame " + m_InstantGameName;
            object2 = (String)object2 + " -instantGameEngine " + m_InstantGameEngine;
            object2 = (String)object2 + " -instantGameRoot " + m_InstantGameRoot;
            object2 = (String)object2 + " -instantGameEngineRoot " + m_InstantGameEngineRoot;
            if (m_JNIWhiteList != null) {
                object2 = (String)object2 + " -jniWhiteList " + m_JNIWhiteList;
            }
            object3 = m_InstantGameEngineRoot + "/UnityPlayers/" + m_InstantGameEngine;
            object2 = (String)object2 + " -overrideMonoSearchPath " + ((String)object3 + "/Managed");
        }
        if ((object3 = currentActivity.getIntent().getStringExtra("overrideExternalDir")) != null) {
            object2 = (String)object2 + " -overrideExternalDir " + (String)object3;
        }
        if ((object3 = currentActivity.getIntent().getStringExtra("overrideInternalDir")) != null) {
            object2 = (String)object2 + " -overrideInternalDir " + (String)object3;
        }
        currentActivity.getIntent().putExtra("unity", (String)object2);
        this.mContext = object;
        this.EarlyEnableFullScreenIfEnabled();
        this.prevConfig = this.getResources().getConfiguration();
        this.mNaturalOrientation = this.getNaturalOrientation(this.prevConfig.orientation);
        if (this.mActivity != null && this.getSplashEnabled() && m_InstantGameName == null) {
            e e2;
            object2 = e2;
            e2 = new e(this.mContext, d.a()[this.getSplashMode()]);
            this.m_SplashScreen = object2;
            this.addView((View)object2);
        }
        UnityPlayer.preloadJavaPlugins();
        object2 = UnityPlayer.loadNative(UnityPlayer.getUnityNativeLibraryPath(this.mContext));
        if (!E0.d()) {
            h0 h02;
            t.Log(6, "Your hardware does not support this application.");
            object = h02;
            h02 = new h0(this);
            AlertDialog alertDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Failure to initialize!").setPositiveButton((CharSequence)"OK", (DialogInterface.OnClickListener)object).setMessage((CharSequence)("Your hardware does not support this application.\n\n" + (String)object2 + "\n\n Press OK to quit.")).create();
            alertDialog.setCancelable(false);
            alertDialog.show();
            return;
        }
        this.initJni((Context)object);
        this.mState.d(true);
        object2 = v2;
        v2 = new V((Context)object, this);
        this.mGlView = object2;
        this.addView((View)object2);
        this.bringChildToFront(this.m_SplashScreen);
        this.mQuitting = false;
        object = this.mActivity;
        if (object != null) {
            this.m_Window = object.getWindow();
        }
        this.hideStatusBar();
        this.m_TelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.m_ClipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        object = camera2Wrapper;
        camera2Wrapper = new Camera2Wrapper(this.mContext);
        this.m_Camera2Wrapper = object;
        object = hFPStatus;
        hFPStatus = new HFPStatus(this.mContext);
        this.m_HFPStatus = object;
        this.m_MainThread.start();
    }

    private int getNaturalOrientation(int n2) {
        int n3 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if ((n3 != 0 && n3 != 2 || n2 != 2) && (n3 != 1 && n3 != 3 || n2 != 1)) {
            return 1;
        }
        return 0;
    }

    private String GetGlViewContentDescription(Context context) {
        if (m_InstantGameName != null) {
            return "Game view";
        }
        String string = context.getPackageName();
        return context.getResources().getString(context.getResources().getIdentifier("game_view_content_description", "string", string));
    }

    private void DisableStaticSplashScreen() {
        q0 q02;
        q0 q03 = q02;
        q02 = new q0(this);
        this.runOnUiThread(q03);
    }

    private void EarlyEnableFullScreenIfEnabled() {
        Activity activity = this.mActivity;
        if (activity != null && activity.getWindow() != null && (this.getLaunchFullscreen() || this.mActivity.getIntent().getBooleanExtra("android.intent.extra.VR_LAUNCH", false)) && (activity = this.mActivity.getWindow().getDecorView()) != null) {
            activity.setSystemUiVisibility(7);
        }
        s.a(this.mActivity);
    }

    private boolean IsWindowTranslucent() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer == null) {
            return false;
        }
        unityPlayer = unityPlayer.getTheme().obtainStyledAttributes(new int[]{16842840});
        boolean bl = unityPlayer.getBoolean(0, false);
        unityPlayer.recycle();
        return bl;
    }

    private boolean updateDisplayInternal(int n2, Surface surface) {
        String string = "Timeout (";
        if (E0.d() && ((UnityPlayer)object).mState.a()) {
            block14: {
                Object object;
                s0 s02;
                Semaphore semaphore;
                Semaphore semaphore2 = semaphore;
                semaphore = new Semaphore(0);
                s0 s03 = s02;
                s02 = new s0((UnityPlayer)object, n2, surface, semaphore2);
                if (n2 == 0) {
                    if (surface == null) {
                        object = ((UnityPlayer)object).m_MainThread;
                        if (((C0)object).a != null) {
                            Object object2 = object;
                            ((C0)object2).a(A0.d);
                            Message.obtain((Handler)((C0)object2).a, (Runnable)s03).sendToTarget();
                        }
                    } else {
                        object = ((UnityPlayer)object).m_MainThread;
                        Handler handler = ((C0)object).a;
                        if (handler != null) {
                            Message.obtain((Handler)handler, (Runnable)s03).sendToTarget();
                            ((C0)object).a(A0.e);
                        }
                    }
                } else {
                    s03.run();
                }
                if (surface == null && n2 == 0) {
                    Semaphore semaphore3 = semaphore2;
                    object = SynchronizationTimeout.SurfaceDetach;
                    long l2 = ((SynchronizationTimeout)((Object)object)).getTimeout();
                    if (semaphore3.tryAcquire(l2, TimeUnit.MILLISECONDS)) break block14;
                    try {
                        t.Log(5, string + ((SynchronizationTimeout)((Object)object)).getTimeout() + " ms) while trying detaching primary window.");
                    }
                    catch (InterruptedException interruptedException) {
                        t.Log(5, "UI thread got interrupted while trying to detach the primary window from the Unity Engine.");
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void UnitySendMessage(String string, String string2, String string3) {
        if (!E0.d()) {
            t.Log(5, "Native libraries not loaded - dropping message for " + string + "." + string2);
            return;
        }
        try {
            UnityPlayer.nativeUnitySendMessage(string, string2, string3.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static native void nativeUnitySendMessage(String var0, String var1, byte[] var2);

    private void finish() {
        Activity activity = this.mActivity;
        if (activity != null && !activity.isFinishing()) {
            this.mActivity.finish();
        }
    }

    private void queueDestroy() {
        u0 u02;
        t.Log(4, "Queue Destroy");
        u0 u03 = u02;
        u02 = new u0(this);
        this.runOnUiThread(u03);
    }

    private void pauseUnity() {
        UnityPlayer unityPlayer = this;
        String string = "Timeout (";
        unityPlayer.reportSoftInputStr(null, 1, true);
        if (unityPlayer.mState.c() && !this.mState.b()) {
            block12: {
                if (E0.d()) {
                    Runnable runnable;
                    Semaphore semaphore;
                    Object object = semaphore;
                    semaphore = new Semaphore(0);
                    if (this.isFinishing()) {
                        v0 v02;
                        runnable = v02;
                        v02 = new v0(this, (Semaphore)object);
                    } else {
                        w0 w02;
                        runnable = w02;
                        w02 = new w0(this, (Semaphore)object);
                    }
                    C0 c02 = this.m_MainThread;
                    if (c02.a != null) {
                        C0 c03 = c02;
                        c03.a(A0.a);
                        Message.obtain((Handler)c03.a, (Runnable)runnable).sendToTarget();
                    }
                    Semaphore semaphore2 = object;
                    object = SynchronizationTimeout.Pause;
                    long l2 = ((SynchronizationTimeout)((Object)object)).getTimeout();
                    if (semaphore2.tryAcquire(l2, TimeUnit.MILLISECONDS)) break block12;
                    try {
                        t.Log(5, string + ((SynchronizationTimeout)((Object)object)).getTimeout() + " ms) while trying to pause the Unity Engine.");
                    }
                    catch (InterruptedException interruptedException) {
                        t.Log(5, "UI thread got interrupted while trying to pause the Unity Engine.");
                    }
                }
            }
            UnityPlayer unityPlayer2 = this;
            unityPlayer2.mState.c(false);
            unityPlayer2.mState.e(true);
            if (unityPlayer2.m_AddPhoneCallListener) {
                this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 0);
            }
            return;
        }
    }

    private void shutdown() {
        UnityPlayer unityPlayer = this;
        unityPlayer.mProcessKillRequested = unityPlayer.nativeDone();
        unityPlayer.mState.d(false);
    }

    private void checkResumePlayer() {
        boolean bl = false;
        Activity activity = this.mActivity;
        if (activity != null) {
            bl = MultiWindowSupport.isInMultiWindowMode(activity);
        }
        if (!this.mState.a(bl)) {
            return;
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.c(true);
        unityPlayer.queueGLThreadEvent(new W(this));
        unityPlayer.m_MainThread.a(A0.b);
    }

    private final native void initJni(Context var1);

    private final native boolean nativeRender();

    private final native void nativeSetInputArea(int var1, int var2, int var3, int var4);

    private final native void nativeSetKeyboardIsVisible(boolean var1);

    private final native void nativeSetInputString(String var1);

    private final native void nativeSetInputSelection(int var1, int var2);

    private final native void nativeSoftInputCanceled();

    private final native void nativeSoftInputLostFocus();

    private final native void nativeReportKeyboardConfigChanged();

    private final native boolean nativePause();

    private final native void nativeResume();

    private final native void nativeLowMemory();

    private final native void nativeApplicationUnload();

    private final native void nativeFocusChanged(boolean var1);

    private final native void nativeRecreateGfxState(int var1, Surface var2);

    private final native void nativeSendSurfaceChangedEvent();

    private final native boolean nativeDone();

    private final native void nativeSoftInputClosed();

    private final native boolean nativeInjectEvent(InputEvent var1);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeMuteMasterAudio(boolean var1);

    private final native void nativeRestartActivityIndicator();

    private final native void nativeSetLaunchURL(String var1);

    private final native void nativeOrientationChanged(int var1, int var2);

    private final native boolean nativeGetNoWindowMode();

    private final native void nativeHidePreservedContent();

    private static String logLoadLibMainError(String string, String string2) {
        String string3 = "Failed to load 'libmain.so'\n\n" + string2;
        t.Log(6, string3);
        return string3;
    }

    private static void preloadJavaPlugins() {
        try {
            Class.forName("com.unity3d.JavaPluginPreloader");
        }
        catch (LinkageError linkageError) {
            t.Log(6, "Java class preloading failed: " + linkageError.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadNative(String var0) {
        var1_1 = var0 + "/libmain.so";
        try {
            System.load(var1_1);
            ** GOTO lbl12
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                System.loadLibrary("main");
            }
            catch (SecurityException v1) {
                return UnityPlayer.logLoadLibMainError(var1_1, v1.toString());
            }
lbl12:
            // 2 sources

            if (UnityPlayer.m_InstantGameName != null && !new File((var0 = UnityPlayer.m_InstantGameRoot + "/UnityGames/" + UnityPlayer.m_InstantGameName + "/sos") + "/libtuanjie.so").exists()) {
                var0 = UnityPlayer.m_InstantGameEngineRoot + "/UnityPlayers/" + UnityPlayer.m_InstantGameEngine;
            }
            if (NativeLoader.load(var0)) {
                E0.e();
                return "";
            }
            t.Log(6, "NativeLoader.load failure, Unity libraries were not loaded.");
            return "NativeLoader.load failure, Unity libraries were not loaded.";
            catch (UnsatisfiedLinkError v2) {
                return UnityPlayer.logLoadLibMainError(var1_1, v2.toString());
            }
        }
    }

    private static void unloadNative() {
        if (!E0.d()) {
            return;
        }
        if (NativeLoader.unload()) {
            E0.f();
            return;
        }
        throw new UnsatisfiedLinkError("Unable to unload libraries from libmain.so");
    }

    private static String getUnityNativeLibraryPath(Context context) {
        return context.getApplicationInfo().nativeLibraryDir;
    }

    private void hidePreservedContent() {
        Z z2;
        Z z3 = z2;
        z2 = new Z(this);
        this.runOnUiThread(z3);
    }

    private String getProcessName() {
        int n2 = Process.myPid();
        Object object = ((ActivityManager)this.mContext.getSystemService("activity")).getRunningAppProcesses();
        if (object == null) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
            if (runningAppProcessInfo.pid != n2) continue;
            return runningAppProcessInfo.processName;
        }
        return null;
    }

    private ApplicationInfo getApplicationInfo() {
        return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
    }

    private ActivityInfo getActivityInfo() {
        return this.mActivity.getPackageManager().getActivityInfo(this.mActivity.getComponentName(), 128);
    }

    private boolean getSplashEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getARCoreEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(ARCORE_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getLaunchFullscreen() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(LAUNCH_FULLSCREEN);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getHaveAndroidWindowSupport() {
        if (this.m_IsNoWindowMode == -1) {
            this.m_IsNoWindowMode = this.nativeGetNoWindowMode() ? 1 : 0;
        }
        return this.m_IsNoWindowMode == 1;
    }

    private boolean getAutoReportFullyDrawnEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(AUTO_REPORT_FULLY_DRAWN_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void queueGLThreadEvent(D0 d02) {
        if (this.isFinishing()) {
            return;
        }
        this.queueGLThreadEvent((Runnable)d02);
    }

    private void hideStatusBar() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            unityPlayer.getWindow().setFlags(1024, 1024);
        }
    }

    private void swapViews(View view, View view2) {
        ViewParent viewParent;
        boolean bl = false;
        if (!this.mState.b()) {
            this.setupUnityToBePaused();
            bl = true;
        }
        if (!(view == null || (viewParent = view.getParent()) instanceof UnityPlayer && (UnityPlayer)viewParent == this)) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            UnityPlayer unityPlayer = this;
            unityPlayer.addView(view);
            unityPlayer.bringChildToFront(view);
            view.setVisibility(0);
        }
        if (view2 != null && view2.getParent() == this) {
            view2.setVisibility(8);
            this.removeView(view2);
        }
        if (bl) {
            this.setupUnityToBeResumed();
        }
    }

    static {
        new T().a();
    }

    public void SetHostPermissionImpl(IHostPermission iHostPermission) {
        this.mHostPermission = iHostPermission;
    }

    @Override
    public void onUnityPlayerUnloaded() {
    }

    @Override
    public void onUnityPlayerQuitted() {
    }

    protected void toggleGyroscopeSensor(boolean bl) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(11);
        if (bl) {
            sensorManager.registerListener((SensorEventListener)this.m_FakeListener, sensor, 1);
        } else {
            sensorManager.unregisterListener((SensorEventListener)this.m_FakeListener);
        }
    }

    void sendSurfaceChangedEvent() {
        if (E0.d() && unityPlayer.mState.a()) {
            r0 r02;
            r0 r03 = r02;
            r02 = new r0(unityPlayer);
            UnityPlayer unityPlayer = unityPlayer.m_MainThread.a;
            if (unityPlayer != null) {
                Message.obtain((Handler)unityPlayer, (Runnable)r03).sendToTarget();
            }
            return;
        }
    }

    void updateGLDisplay(int n2, Surface surface) {
        if (this.mMainDisplayOverride) {
            return;
        }
        this.updateDisplayInternal(n2, surface);
    }

    public boolean displayChanged(int n2, Surface surface) {
        if (n2 == 0) {
            t0 t02;
            boolean bl = surface != null;
            this.mMainDisplayOverride = bl;
            t0 t03 = t02;
            t02 = new t0(this);
            this.runOnUiThread(t03);
        }
        return this.updateDisplayInternal(n2, surface);
    }

    void runOnAnonymousThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    void runOnUiThread(Runnable runnable) {
        Activity activity = this.mActivity;
        if (activity != null) {
            activity.runOnUiThread(runnable);
        } else if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public void init(int n2, boolean bl) {
    }

    public View getView() {
        return this;
    }

    public Bundle getSettings() {
        return Bundle.EMPTY;
    }

    public void quit() {
        this.destroy();
    }

    public void newIntent(Intent intent) {
        this.m_launchUri = intent.getData();
        this.m_MainThread.a(A0.i);
    }

    public void destroy() {
        Object object = this.m_Camera2Wrapper;
        if (object != null) {
            ((Camera2Wrapper)object).a();
            this.m_Camera2Wrapper = null;
        }
        if ((object = this.m_HFPStatus) != null) {
            ((HFPStatus)object).b();
            this.m_HFPStatus = null;
        }
        if ((object = this.m_NetworkConnectivity) != null) {
            ((NetworkConnectivity)((Object)object)).a();
            this.m_NetworkConnectivity = null;
        }
        this.mQuitting = true;
        if (!this.mState.b()) {
            this.setupUnityToBePaused();
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.m_MainThread.a(A0.c);
        C0 c02 = unityPlayer.m_MainThread;
        long l2 = SynchronizationTimeout.Destroy.getTimeout();
        try {
            c02.join(l2);
        }
        catch (InterruptedException interruptedException) {
            this.m_MainThread.interrupt();
        }
        if (E0.d()) {
            this.removeAllViews();
        }
        if (this.mProcessKillRequested) {
            UnityPlayer unityPlayer2 = this;
            unityPlayer2.m_UnityPlayerLifecycleEvents.onUnityPlayerQuitted();
            unityPlayer2.kill();
        }
        UnityPlayer.unloadNative();
    }

    protected void kill() {
        Process.killProcess((int)Process.myPid());
    }

    public void onStop() {
        if (!MultiWindowSupport.isInMultiWindowMode(this.mActivity)) {
            return;
        }
        this.setupUnityToBePaused();
    }

    public void onStart() {
        if (!MultiWindowSupport.isInMultiWindowMode(this.mActivity)) {
            return;
        }
        this.setupUnityToBeResumed();
    }

    public void onPause() {
        UnityPlayer unityPlayer = this;
        MultiWindowSupport.saveMultiWindowMode(unityPlayer.mActivity);
        if (MultiWindowSupport.isInMultiWindowMode(unityPlayer.mActivity)) {
            return;
        }
        this.setupUnityToBePaused();
    }

    public void onResume() {
        if (MultiWindowSupport.isInMultiWindowMode(this.mActivity) && !MultiWindowSupport.isMultiWindowModeChangedToTrue(this.mActivity)) {
            return;
        }
        this.setupUnityToBeResumed();
    }

    public void pause() {
        this.setupUnityToBePaused();
    }

    protected void setupUnityToBePaused() {
        Object object = this.m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).pauseARCore();
        }
        if ((object = this.mVideoPlayerProxy) != null) {
            ((P0)object).b();
        }
        if ((object = this.m_AudioVolumeHandler) != null) {
            ((AudioVolumeHandler)object).a();
            this.m_AudioVolumeHandler = null;
        }
        if ((object = this.m_OrientationLockListener) != null) {
            ((OrientationLockListener)object).a();
            this.m_OrientationLockListener = null;
        }
        this.pauseUnity();
    }

    public void resume() {
        this.setupUnityToBeResumed();
    }

    protected void setupUnityToBeResumed() {
        Object object = this.m_ARCoreApi;
        if (object != null) {
            ((GoogleARCoreApi)object).resumeARCore();
        }
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.e(false);
        object = unityPlayer.mVideoPlayerProxy;
        if (object != null) {
            ((P0)object).c();
        }
        this.checkResumePlayer();
        if (E0.d()) {
            this.nativeRestartActivityIndicator();
        }
        if (this.m_AudioVolumeHandler == null) {
            this.m_AudioVolumeHandler = new AudioVolumeHandler(this.mContext);
        }
        if (this.m_OrientationLockListener == null && E0.d()) {
            Activity activity = this.mActivity;
            if (activity == null) {
                activity = this.mContext;
            }
            this.m_OrientationLockListener = object = new OrientationLockListener((Context)activity);
        }
        this.prevConfig = this.getResources().getConfiguration();
    }

    public void lowMemory() {
        x0 x02;
        if (!E0.d()) {
            return;
        }
        x0 x03 = x02;
        x02 = new x0(this);
        this.queueGLThreadEvent(x03);
    }

    public void unload() {
        this.nativeApplicationUnload();
    }

    protected boolean skipPermissionsDialog() {
        UnityPlayer unityPlayer = unityPlayer.mActivity;
        if (unityPlayer != null) {
            return UnityPermissions.skipPermissionsDialog((Activity)unityPlayer);
        }
        return false;
    }

    protected void requestUserAuthorization(String string) {
        if (m_InstantGameName != null && this.mHostPermission != null) {
            t.Log(4, "mHostPermission");
            this.mHostPermission.requestPermission(string);
        } else if (string != null && !string.isEmpty() && this.mActivity != null) {
            UnityPermissions.ModalWaitForPermissionResponse modalWaitForPermissionResponse;
            UnityPermissions.ModalWaitForPermissionResponse modalWaitForPermissionResponse2 = modalWaitForPermissionResponse;
            modalWaitForPermissionResponse2();
            UnityPermissions.requestUserPermissions(this.mActivity, new String[]{string}, modalWaitForPermissionResponse2);
            modalWaitForPermissionResponse.waitForResponse();
        }
    }

    protected int getNetworkConnectivity() {
        NetworkConnectivity networkConnectivity = this.m_NetworkConnectivity;
        if (networkConnectivity != null) {
            return networkConnectivity.b();
        }
        this.m_NetworkConnectivity = PlatformSupport.NOUGAT_SUPPORT ? new NetworkConnectivityNougat(this.mContext) : new NetworkConnectivity(this.mContext);
        return this.m_NetworkConnectivity.b();
    }

    public void configurationChanged(Configuration configuration) {
        Configuration configuration2;
        int n2 = ((UnityPlayer)object).prevConfig.diff(configuration);
        if ((n2 & 0x100) != 0 || (n2 & 0x400) != 0 || (n2 & 0x800) != 0 || (n2 & 0x80) != 0) {
            ((UnityPlayer)object).nativeHidePreservedContent();
        }
        UnityPlayer unityPlayer = object;
        Object object = configuration2;
        configuration2 = new Configuration(configuration);
        unityPlayer.prevConfig = object;
        object = unityPlayer.mVideoPlayerProxy;
        if (object != null) {
            ((P0)object).a();
        }
    }

    public void windowFocusChanged(boolean bl) {
        F f2;
        UnityPlayer unityPlayer = this;
        unityPlayer.mState.b(bl);
        if (unityPlayer.mState.a() && ((f2 = this.mSoftInput) == null || f2.d())) {
            if (bl) {
                this.m_MainThread.a(A0.g);
            } else {
                this.m_MainThread.a(A0.f);
            }
            this.checkResumePlayer();
            return;
        }
    }

    protected boolean loadLibrary(String string) {
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    protected void addPhoneCallListener() {
        this.m_AddPhoneCallListener = true;
        this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 32);
    }

    protected void showSoftInput(String string, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, int n3, boolean bl5, boolean bl6) {
        Y y2;
        Y y3 = y2;
        UnityPlayer unityPlayer = this;
        y2 = new Y(unityPlayer, unityPlayer, string, n2, bl, bl2, bl3, bl4, string2, n3, bl5, bl6);
        this.postOnUiThread(y3);
    }

    protected void hideSoftInput() {
        a0 a02;
        a0 a03 = a02;
        a02 = new a0(this);
        this.postOnUiThread(a03);
    }

    protected void setSoftInputStr(String string) {
        b0 b02;
        b0 b03 = b02;
        b02 = new b0(this, string);
        this.runOnUiThread(b03);
    }

    protected void setCharacterLimit(int n2) {
        c0 c02;
        c0 c03 = c02;
        c02 = new c0(this, n2);
        this.runOnUiThread(c03);
    }

    protected void setHideInputField(boolean bl) {
        d0 d02;
        d0 d03 = d02;
        d02 = new d0(this, bl);
        this.runOnUiThread(d03);
    }

    protected void setSelection(int n2, int n3) {
        e0 e02;
        e0 e03 = e02;
        e02 = new e0(this, n2, n3);
        this.runOnUiThread(e03);
    }

    protected String getKeyboardLayout() {
        F f2 = ((UnityPlayer)((Object)f2)).mSoftInput;
        if (f2 == null) {
            return null;
        }
        return f2.a();
    }

    protected void reportSoftInputStr(String string, int n2, boolean bl) {
        f0 f02;
        if (n2 == 1) {
            this.hideSoftInput();
        }
        f0 f03 = f02;
        f02 = new f0(this, bl, string, n2);
        this.queueGLThreadEvent(f03);
    }

    protected void reportSoftInputSelection(int n2, int n3) {
        g0 g02;
        g0 g03 = g02;
        g02 = new g0(this, n2, n3);
        this.queueGLThreadEvent(g03);
    }

    protected void reportSoftInputArea(Rect rect) {
        i0 i02;
        i0 i03 = i02;
        i02 = new i0(this, rect);
        this.queueGLThreadEvent(i03);
    }

    protected void reportSoftInputIsVisible(boolean bl) {
        j0 j02;
        j0 j03 = j02;
        j02 = new j0(this, bl);
        this.queueGLThreadEvent(j03);
    }

    protected void setClipboardText(String string) {
        UnityPlayer unityPlayer = unityPlayer2;
        UnityPlayer unityPlayer2 = ClipData.newPlainText((CharSequence)"Text", (CharSequence)string);
        unityPlayer.m_ClipboardManager.setPrimaryClip((ClipData)unityPlayer2);
    }

    protected String getClipboardText() {
        String string = "";
        ClipData clipData = this.m_ClipboardManager.getPrimaryClip();
        if (clipData != null) {
            string = clipData.getItemAt(0).coerceToText(this.mContext).toString();
        }
        return string;
    }

    protected String getLaunchURL() {
        UnityPlayer unityPlayer = unityPlayer.m_launchUri;
        return unityPlayer != null ? unityPlayer.toString() : null;
    }

    protected boolean initializeGoogleAr() {
        if (this.m_ARCoreApi == null && this.mActivity != null && this.getARCoreEnabled()) {
            GoogleARCoreApi googleARCoreApi;
            GoogleARCoreApi googleARCoreApi2;
            GoogleARCoreApi googleARCoreApi3 = googleARCoreApi2 = googleARCoreApi;
            googleARCoreApi3();
            this.m_ARCoreApi = googleARCoreApi3;
            googleARCoreApi.initializeARCore(this.mActivity);
            if (!this.mState.b()) {
                this.m_ARCoreApi.resumeARCore();
            }
        }
        return false;
    }

    protected boolean showVideoPlayer(String string, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        k0 k02;
        if (this.mVideoPlayerProxy == null) {
            P0 p02;
            P0 p03 = p02;
            p02 = new P0(this);
            this.mVideoPlayerProxy = p03;
        }
        Object object = this.mContext;
        long l2 = n5;
        long l3 = n6;
        Context context = object;
        object = k02;
        k02 = new k0(this);
        boolean bl2 = this.mVideoPlayerProxy.a(context, string, n2, n3, n4, bl, l2, l3, (O0)object);
        if (bl2) {
            l0 l02;
            l0 l03 = l02;
            l02 = new l0(this);
            this.runOnUiThread(l03);
        }
        return bl2;
    }

    protected void pauseJavaAndCallUnloadCallback() {
        m0 m02;
        m0 m03 = m02;
        m02 = new m0(this);
        this.runOnUiThread(m03);
    }

    protected boolean isUaaLUseCase() {
        Object object = this.mActivity;
        if (object != null) {
            return (object = object.getCallingPackage()) != null && ((String)object).equals(this.mContext.getPackageName());
        }
        return false;
    }

    protected int getUaaLLaunchProcessType() {
        String string = this.getProcessName();
        return string != null && !string.equals(this.mContext.getPackageName()) ? 1 : 0;
    }

    protected int getSplashMode() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_MODE_METADATA_NAME);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void executeGLThreadJobs() {
        Runnable runnable;
        while ((runnable = (Runnable)this.m_Events.poll()) != null) {
            runnable.run();
        }
    }

    protected void disableLogger() {
        t.a = true;
    }

    void queueGLThreadEvent(Runnable runnable) {
        if (!E0.d()) {
            return;
        }
        if (Thread.currentThread() == this.m_MainThread) {
            runnable.run();
        } else {
            this.m_Events.add(runnable);
        }
    }

    protected boolean isFinishing() {
        if (this.mQuitting) {
            return true;
        }
        Activity activity = this.mActivity;
        if (activity != null) {
            this.mQuitting = activity.isFinishing();
        }
        return this.mQuitting;
    }

    public boolean injectEvent(InputEvent inputEvent) {
        if (!E0.d()) {
            return false;
        }
        return this.nativeInjectEvent(inputEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyMultiple(int n2, int n3, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyLongPress(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.mGlView.c() ? this.injectEvent((InputEvent)motionEvent) : false;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return !this.mGlView.c() ? this.injectEvent((InputEvent)motionEvent) : false;
    }

    public boolean addViewToPlayer(View view, boolean bl) {
        V v2 = bl ? this.mGlView : null;
        this.swapViews(view, (View)v2);
        boolean bl2 = view.getParent() == this;
        bl = bl && this.mGlView.getParent() == null;
        boolean bl3 = this.mGlView.getParent() == this;
        boolean bl4 = bl2 && (bl || bl3);
        if (!bl4) {
            if (!bl2) {
                t.Log(6, "addViewToPlayer: Failure adding view to hierarchy");
            }
            if (!bl && !bl3) {
                t.Log(6, "addViewToPlayer: Failure removing old view from hierarchy");
            }
        }
        return bl4;
    }

    public void removeViewFromPlayer(View view) {
        UnityPlayer unityPlayer = this;
        unityPlayer.swapViews((View)unityPlayer.mGlView, view);
        boolean bl = view.getParent() == null;
        boolean bl2 = this.mGlView.getParent() == this;
        if (!(bl && bl2)) {
            if (!bl) {
                t.Log(6, "removeViewFromPlayer: Failure removing view from hierarchy");
            }
            if (!bl2) {
                t.Log(6, "removeVireFromPlayer: Failure agging old view to hierarchy");
            }
        }
    }

    public void reportError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        t.Log(6, stringBuilder.toString());
    }

    public String getNetworkProxySettings(String string) {
        block8: {
            String string2;
            Object object;
            block7: {
                block6: {
                    if (!string.startsWith("http:")) break block6;
                    object = "http.proxyHost";
                    string = "http.proxyPort";
                    string2 = "http.nonProxyHosts";
                    break block7;
                }
                if (!string.startsWith("https:")) break block8;
                object = "https.proxyHost";
                string = "https.proxyPort";
                string2 = "http.nonProxyHosts";
            }
            object = System.getProperties().getProperty((String)object);
            if (object != null && !"".equals(object)) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder = new StringBuilder((String)object);
                object = System.getProperties().getProperty(string);
                if (object != null && !"".equals(object)) {
                    stringBuilder2.append(":").append((String)object);
                }
                if ((object = System.getProperties().getProperty(string2)) != null && !"".equals(object)) {
                    stringBuilder2.append('\n').append((String)object);
                }
                return stringBuilder2.toString();
            }
            return null;
        }
        return null;
    }

    public boolean startOrientationListener(int n2) {
        n0 n02;
        if (this.mOrientationListener != null) {
            t.Log(5, "Orientation Listener already started.");
            return false;
        }
        n0 n03 = n02;
        UnityPlayer unityPlayer = this;
        this.mOrientationListener = new n0(unityPlayer, unityPlayer.mContext, n2);
        if (n03.canDetectOrientation()) {
            this.mOrientationListener.enable();
            return true;
        }
        t.Log(5, "Orientation Listener cannot detect orientation.");
        return false;
    }

    public boolean stopOrientationListener() {
        OrientationEventListener orientationEventListener = this.mOrientationListener;
        if (orientationEventListener == null) {
            t.Log(5, "Orientation Listener was not started.");
            return false;
        }
        orientationEventListener.disable();
        this.mOrientationListener = null;
        return true;
    }

    public void setMainSurfaceViewAspectRatio(float f2) {
        if (this.mGlView != null) {
            o0 o02;
            o0 o03 = o02;
            o02 = new o0(this, f2);
            this.runOnUiThread(o03);
        }
    }

    public void setScreenBrightness(float f2) {
        f2 = Math.max(0.04f, f2);
        if (this.m_Window != null && this.getScreenBrightness() != f2) {
            p0 p02;
            p0 p03 = p02;
            p02 = new p0(this, f2);
            this.runOnUiThread(p03);
            return;
        }
    }

    public float getScreenBrightness() {
        float f2;
        Window window = this.m_Window;
        if (window == null) {
            return 1.0f;
        }
        float f3 = window.getAttributes().screenBrightness;
        if (f2 < 0.0f) {
            int n2 = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness", (int)255);
            if (PlatformSupport.PIE_SUPPORT) {
                double d2 = (Math.log(n2) * 19.811 - 9.411) / 100.0;
                d2 = Math.min(1.0, d2);
                return (float)Math.max(0.0, d2);
            }
            return (float)n2 / 255.0f;
        }
        return f3;
    }

    public static interface IHostPermission {
        public void requestPermission(String var1);
    }

    public static final class SynchronizationTimeout
    extends Enum {
        public static final /* enum */ SynchronizationTimeout Pause;
        public static final /* enum */ SynchronizationTimeout SurfaceDetach;
        public static final /* enum */ SynchronizationTimeout Destroy;
        private static final /* synthetic */ SynchronizationTimeout[] $VALUES;
        final int value;
        private int m_TimeoutMilliseconds;

        public static SynchronizationTimeout[] values() {
            return (SynchronizationTimeout[])$VALUES.clone();
        }

        public static SynchronizationTimeout valueOf(String string) {
            return Enum.valueOf(SynchronizationTimeout.class, string);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private SynchronizationTimeout() {
            void var3_2;
            void var2_-1;
            void var1_-1;
            this.value = var3_2;
            this.m_TimeoutMilliseconds = 2000;
        }

        public static void setTimeoutForAll(int n2) {
            SynchronizationTimeout[] synchronizationTimeoutArray = (SynchronizationTimeout[])SynchronizationTimeout.class.getEnumConstants();
            int n3 = synchronizationTimeoutArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                synchronizationTimeoutArray[i2].setTimeout(n2);
            }
        }

        static {
            SynchronizationTimeout synchronizationTimeout;
            SynchronizationTimeout synchronizationTimeout2;
            SynchronizationTimeout synchronizationTimeout3;
            SynchronizationTimeout synchronizationTimeout4 = synchronizationTimeout3;
            Pause = new SynchronizationTimeout("Pause", 0, 0);
            SynchronizationTimeout synchronizationTimeout5 = synchronizationTimeout2;
            SurfaceDetach = new SynchronizationTimeout("SurfaceDetach", 1, 1);
            SynchronizationTimeout synchronizationTimeout6 = synchronizationTimeout;
            Destroy = new SynchronizationTimeout("Destroy", 2, 2);
            $VALUES = new SynchronizationTimeout[]{synchronizationTimeout4, synchronizationTimeout5, synchronizationTimeout6};
        }

        public void setTimeout(int n2) {
            this.m_TimeoutMilliseconds = n2;
        }

        public int getTimeout() {
            return this.m_TimeoutMilliseconds;
        }
    }
}

