/*
 * Decompiled with CFR 0.152.
 */
package com.unity.purchasing.common;

import com.unity.purchasing.common.IStoreCallback;
import com.unity.purchasing.common.IUnityCallback;
import com.unity.purchasing.common.InitializationFailureReason;
import com.unity.purchasing.common.ProductDescription;
import com.unity.purchasing.common.ProductMetadata;
import com.unity.purchasing.common.PurchaseFailureDescription;
import com.unity.purchasing.common.SaneJSONObject;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class UnityPurchasing
implements IStoreCallback {
    private IUnityCallback bridge;

    public UnityPurchasing(IUnityCallback bridge) {
        this.bridge = bridge;
    }

    @Override
    public void OnSetupFailed(InitializationFailureReason i) {
        this.bridge.OnSetupFailed(i.toString());
    }

    @Override
    public void OnProductsRetrieved(List<ProductDescription> products) {
        this.bridge.OnProductsRetrieved(UnityPurchasing.SerialiseProducts(products));
    }

    @Override
    public void OnPurchaseSucceeded(String storeSpecificId, String receipt, String transactionIdentifier) {
        this.bridge.OnPurchaseSucceeded(storeSpecificId, receipt, transactionIdentifier);
    }

    @Override
    public void OnPurchaseFailed(PurchaseFailureDescription p) {
        this.bridge.OnPurchaseFailed(UnityPurchasing.SerialisePurchaseFailure(p));
    }

    public static String SerialisePurchaseFailure(PurchaseFailureDescription p) {
        SaneJSONObject result = new SaneJSONObject();
        result.put("message", p.message);
        result.put("productId", p.productId);
        result.put("reason", p.reason.toString());
        result.put("storeSpecificErrorCode", p.storeSpecificErrorCode);
        return result.toString();
    }

    public static String SerialiseProducts(List<ProductDescription> products) {
        JSONArray result = new JSONArray();
        for (ProductDescription product : products) {
            result.put((Object)UnityPurchasing.SerialiseProduct(product));
        }
        return result.toString();
    }

    private static JSONObject SerialiseProduct(ProductDescription product) {
        SaneJSONObject result = new SaneJSONObject();
        result.put("metadata", UnityPurchasing.SerialiseMetadata(product.metadata));
        result.put("receipt", product.receipt);
        result.put("storeSpecificId", product.storeSpecificId);
        result.put("transactionId", product.transactionId);
        return result;
    }

    private static JSONObject SerialiseMetadata(ProductMetadata metadata) {
        SaneJSONObject result = new SaneJSONObject();
        result.put("isoCurrencyCode", metadata.isoCurrencyCode);
        result.put("localizedDescription", metadata.localizedDescription);
        result.put("localizedPriceString", metadata.localizedPriceString);
        result.put("localizedPrice", metadata.localizedPrice == null ? 0.0 : metadata.localizedPrice.doubleValue());
        result.put("localizedTitle", metadata.localizedTitle);
        return result;
    }
}

