/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.misc.IJsonStorageReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

public class DeviceInfoReaderFilterProvider {
    private static final String UNIFIED_CONFIG_KEY = "unifiedconfig";
    private static final String FILTER_EXCLUDE_KEY = "exclude";
    private IJsonStorageReader _storage;

    public DeviceInfoReaderFilterProvider(IJsonStorageReader jsonStorageReader) {
        this._storage = jsonStorageReader;
    }

    public List<String> getFilterList() {
        Object filterExcludeData;
        Object unifiedConfigData;
        List<String> filterList = new ArrayList<String>();
        if (this._storage != null && this._storage.getData() != null && (unifiedConfigData = this._storage.getData().opt(UNIFIED_CONFIG_KEY)) != null && unifiedConfigData instanceof JSONObject && (filterExcludeData = ((JSONObject)unifiedConfigData).opt(FILTER_EXCLUDE_KEY)) instanceof String) {
            filterList = Arrays.asList(((String)filterExcludeData).split(","));
            filterList = this.trimWhiteSpaces(filterList);
        }
        return filterList;
    }

    private List<String> trimWhiteSpaces(List<String> original) {
        ArrayList<String> trimmedStrings = new ArrayList<String>();
        for (String originalString : original) {
            trimmedStrings.add(originalString.trim());
        }
        return trimmedStrings;
    }
}

