/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.cache;

import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import com.unity3d.services.core.cache.CacheThreadHandler;
import com.unity3d.services.core.log.DeviceLog;
import java.util.HashMap;
import java.util.List;

public class CacheThread
extends Thread {
    private static CacheThreadHandler _handler = null;
    private static boolean _ready = false;
    private static final Object _readyLock = new Object();
    public static final int MSG_DOWNLOAD = 1;
    private static int _connectTimeout = 30000;
    private static int _readTimeout = 30000;
    private static int _progressInterval = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        CacheThread thread = new CacheThread();
        thread.setName("UnityAdsCacheThread");
        thread.start();
        while (!_ready) {
            try {
                Object object = _readyLock;
                synchronized (object) {
                    _readyLock.wait();
                }
            }
            catch (InterruptedException e) {
                DeviceLog.debug("Couldn't synchronize thread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        _handler = new CacheThreadHandler();
        _ready = true;
        Object object = _readyLock;
        synchronized (object) {
            _readyLock.notify();
        }
        Looper.loop();
    }

    public static synchronized void download(String source, String target, HashMap<String, List<String>> headers, boolean append) {
        if (!_ready) {
            CacheThread.init();
        }
        Bundle params = new Bundle();
        params.putString("source", source);
        params.putString("target", target);
        params.putInt("connectTimeout", _connectTimeout);
        params.putInt("readTimeout", _readTimeout);
        params.putInt("progressInterval", _progressInterval);
        params.putBoolean("append", append);
        if (headers != null) {
            for (String s : headers.keySet()) {
                String[] h = new String[headers.get(s).size()];
                params.putStringArray(s, headers.get(s).toArray(h));
            }
        }
        Message msg = new Message();
        msg.what = 1;
        msg.setData(params);
        _handler.setCancelStatus(false);
        _handler.sendMessage(msg);
    }

    public static boolean isActive() {
        if (!_ready) {
            return false;
        }
        return _handler.isActive();
    }

    public static void cancel() {
        if (!_ready) {
            return;
        }
        _handler.removeMessages(1);
        _handler.setCancelStatus(true);
    }

    public static void setProgressInterval(int interval) {
        _progressInterval = interval;
    }

    public static int getProgressInterval() {
        return _progressInterval;
    }

    public static void setConnectTimeout(int connectTimeout) {
        _connectTimeout = connectTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        _readTimeout = readTimeout;
    }

    public static int getConnectTimeout() {
        return _connectTimeout;
    }

    public static int getReadTimeout() {
        return _readTimeout;
    }
}

