/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners.api;

import com.unity3d.services.banners.BannerViewCache;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.banners.bridge.BannerBridge;
import com.unity3d.services.banners.properties.BannerRefreshInfo;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class Banner {
    @WebViewExposed
    public static void load(String bannerViewTypeString, Integer width, Integer height, String bannerAdId, WebViewCallback callback) {
        BannerViewType bannerViewType = BannerViewType.fromString(bannerViewTypeString);
        switch (bannerViewType) {
            case WEB_PLAYER: {
                boolean successfullyLoaded = BannerViewCache.getInstance().loadWebPlayer(bannerAdId, new UnityBannerSize(width, height));
                if (!successfullyLoaded) break;
                BannerBridge.didLoad(bannerAdId);
                break;
            }
        }
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void setRefreshRate(String placementId, Integer refreshRate, WebViewCallback callback) {
        if (placementId != null && refreshRate != null) {
            BannerRefreshInfo.getInstance().setRefreshRate(placementId, refreshRate);
        }
        callback.invoke(new Object[0]);
    }

    private static enum BannerViewType {
        WEB_PLAYER,
        UNKNOWN;


        public static BannerViewType fromString(String type) {
            try {
                return BannerViewType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

