/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners;

import android.content.Context;
import android.content.res.Resources;
import com.unity3d.services.core.misc.ViewUtilities;

public class UnityBannerSize {
    private int width;
    private int height;

    public UnityBannerSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static UnityBannerSize getDynamicSize(Context context) {
        return new UnityBannerSize(BannerSize.BANNER_SIZE_DYNAMIC.getWidth(context), BannerSize.BANNER_SIZE_DYNAMIC.getHeight(context));
    }

    private static enum BannerSize {
        BANNER_SIZE_STANDARD,
        BANNER_SIZE_LEADERBOARD,
        BANNER_SIZE_IAB_STANDARD,
        BANNER_SIZE_DYNAMIC;

        private static final int LEADERBOARD_WIDTH = 728;
        private static final int LEADERBOARD_HEIGHT = 90;
        private static final int IAB_STANDARD_WIDTH = 468;
        private static final int IAB_STANDARD_HEIGHT = 60;
        private static final int STANDARD_WIDTH = 320;
        private static final int STANDARD_HEIGHT = 50;

        private BannerSize getNonDynamicSize(Context context) {
            if (this == BANNER_SIZE_DYNAMIC) {
                int screenWidth = Math.round(ViewUtilities.dpFromPx(context, Resources.getSystem().getDisplayMetrics().widthPixels));
                if (screenWidth >= 728) {
                    return BANNER_SIZE_LEADERBOARD;
                }
                if (screenWidth >= 468) {
                    return BANNER_SIZE_IAB_STANDARD;
                }
                return BANNER_SIZE_STANDARD;
            }
            return this;
        }

        private int getWidth(Context context) {
            BannerSize bannerSize = this.getNonDynamicSize(context);
            switch (bannerSize) {
                case BANNER_SIZE_STANDARD: {
                    return 320;
                }
                case BANNER_SIZE_LEADERBOARD: {
                    return 728;
                }
                case BANNER_SIZE_IAB_STANDARD: {
                    return 468;
                }
            }
            return 320;
        }

        private int getHeight(Context context) {
            BannerSize bannerSize = this.getNonDynamicSize(context);
            switch (bannerSize) {
                case BANNER_SIZE_STANDARD: {
                    return 50;
                }
                case BANNER_SIZE_LEADERBOARD: {
                    return 90;
                }
                case BANNER_SIZE_IAB_STANDARD: {
                    return 60;
                }
            }
            return 50;
        }
    }
}

