/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.show;

import android.os.ConditionVariable;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.show.IShowModule;
import com.unity3d.services.ads.operation.show.IShowOperation;
import com.unity3d.services.ads.operation.show.ShowModuleDecorator;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.request.metrics.AdOperationError;
import com.unity3d.services.core.request.metrics.AdOperationMetric;
import com.unity3d.services.core.timer.BaseTimer;
import com.unity3d.services.core.timer.ITimerListener;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ShowModuleDecoratorTimeout
extends ShowModuleDecorator {
    private static final String errorMsgTimeout = "[UnityAds] Timeout while trying to show ";
    private final ExecutorService _executorService = Executors.newSingleThreadExecutor();
    private final boolean _useNewTimer;

    public ShowModuleDecoratorTimeout(IShowModule showModule, ConfigurationReader configurationReader) {
        super(showModule);
        this._useNewTimer = configurationReader.getCurrentConfiguration().getExperiments().isNewLifecycleTimer();
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, ShowOperationState state) {
        this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdShowStart());
        state.start();
        this.startShowTimeout(state);
        super.executeAdOperation(webViewBridgeInvoker, state);
    }

    private void startShowTimeout(final ShowOperationState showOperationState) {
        if (this._useNewTimer) {
            if (showOperationState == null) {
                return;
            }
            showOperationState.timeoutTimer = new BaseTimer(showOperationState.configuration.getShowTimeout(), new ITimerListener(){

                @Override
                public void onTimerFinished() {
                    ShowModuleDecoratorTimeout.this.onOperationTimeout(showOperationState, UnityAds.UnityAdsShowError.TIMEOUT, ShowModuleDecoratorTimeout.errorMsgTimeout + showOperationState.placementId);
                }
            });
            showOperationState.timeoutTimer.start(Executors.newSingleThreadScheduledExecutor());
        } else {
            this._executorService.submit(new Runnable(){

                @Override
                public void run() {
                    if (!showOperationState.timeoutCV.block((long)showOperationState.configuration.getShowTimeout())) {
                        ShowModuleDecoratorTimeout.this.onOperationTimeout(showOperationState, UnityAds.UnityAdsShowError.TIMEOUT, ShowModuleDecoratorTimeout.errorMsgTimeout + showOperationState.placementId);
                    }
                }
            });
        }
    }

    @Override
    public void onUnityAdsShowConsent(String id) {
        this.releaseOperationTimeoutLock(id);
        super.onUnityAdsShowConsent(id);
    }

    @Override
    public void onUnityAdsShowFailure(String id, UnityAds.UnityAdsShowError error, String message) {
        this.releaseOperationTimeoutLock(id);
        super.onUnityAdsShowFailure(id, error, message);
    }

    @Override
    public void onUnityAdsShowStart(String id) {
        this.releaseOperationTimeoutLock(id);
        super.onUnityAdsShowStart(id);
    }

    private void releaseOperationTimeoutLock(String operationId) {
        IShowOperation showOperation = this.get(operationId);
        if (showOperation == null) {
            return;
        }
        ShowOperationState showOperationState = showOperation.getShowOperationState();
        if (showOperationState == null) {
            return;
        }
        if (this._useNewTimer) {
            BaseTimer timeoutTimer = showOperationState.timeoutTimer;
            if (timeoutTimer == null) {
                return;
            }
            timeoutTimer.kill();
        } else {
            ConditionVariable timeoutCV = showOperation.getShowOperationState().timeoutCV;
            if (timeoutCV == null) {
                return;
            }
            showOperation.getShowOperationState().timeoutCV.open();
        }
    }

    private void onOperationTimeout(ShowOperationState state, UnityAds.UnityAdsShowError error, String message) {
        if (state != null) {
            this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdShowFailure(AdOperationError.timeout, (Long)state.duration()));
            this.remove(state.id);
            state.onUnityAdsShowFailure(error, message);
        }
    }
}

