/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.util;

import android.content.Context;
import com.xsj.crasheye.log.Logger;

public final class PermissionUtils {
    public static boolean hasPermission(Context context, String permission2) {
        if (context == null || permission2 == null || permission2.trim().length() <= 0) {
            return false;
        }
        try {
            String[] requestedPermissions = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)4096).requestedPermissions;
            if (requestedPermissions == null) {
                return false;
            }
            for (String requestedPermission : requestedPermissions) {
                if (!permission2.equals(requestedPermission)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            Logger.logError("Can not get packageInfo requested permissions");
            return false;
        }
    }
}

