/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.util;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.util.MemInfoUtils;
import com.xsj.crasheye.util.SystemPropUtils;

public final class DeviceUtils {
    private static final String[] VIRUAL_CHECK_PROP_NAMES = new String[]{"ro.genymotion.version", "androVM.vbox_dpi", "qemu.sf.fake_camera"};
    public static double GB_BYTE = 1.073741824E9;

    public static String getIMEI(Context context) {
        return null;
    }

    public static String getIMSI(Context context) {
        return null;
    }

    public static String getAndroidId(Context context) {
        return null;
    }

    public static String getCpuArch(Context context) {
        if (context == null) {
            return null;
        }
        String cpuAbi = null;
        try {
            String[] tmp;
            String abiList = SystemPropUtils.getprop(context, "ro.product.cpu.abilist");
            if (abiList != null && abiList.length() > 0 && (tmp = abiList.split(",")) != null && tmp.length > 0) {
                cpuAbi = tmp[0];
            }
            if (cpuAbi == null) {
                cpuAbi = SystemPropUtils.getprop(context, "ro.product.cpu.abi");
            }
            if (cpuAbi == null) {
                cpuAbi = System.getProperty("os.arch");
            }
        }
        catch (Throwable e) {
            Logger.logError("[Device] Failed to get CPU ABI.");
        }
        return cpuAbi;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static String getOSROM(Context context) {
        String tmp = SystemPropUtils.getprop(context, "ro.miui.ui.version.name");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "XiaoMi/MIUI/" + tmp;
        }
        tmp = SystemPropUtils.getprop(context, "ro.build.version.emui");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "HuaWei/EMOTION/" + tmp;
        }
        tmp = SystemPropUtils.getprop(context, "ro.lenovo.series");
        if (!DeviceUtils.isEmpty(tmp)) {
            tmp = SystemPropUtils.getprop(context, "ro.build.version.incremental");
            return "Lenovo/VIBE/" + tmp;
        }
        tmp = SystemPropUtils.getprop(context, "ro.build.nubia.rom.name");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "Zte/NUBIA/" + tmp + "_" + SystemPropUtils.getprop(context, "ro.build.nubia.rom.code");
        }
        tmp = SystemPropUtils.getprop(context, "ro.meizu.product.model");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "Meizu/FLYME/" + SystemPropUtils.getprop(context, "ro.build.display.id");
        }
        tmp = SystemPropUtils.getprop(context, "ro.build.version.opporom");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "Oppo/COLOROS/" + tmp;
        }
        tmp = SystemPropUtils.getprop(context, "ro.vivo.os.build.display.id");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "vivo/FUNTOUCH/" + tmp;
        }
        tmp = SystemPropUtils.getprop(context, "ro.aa.romver");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "htc/" + tmp + "/" + SystemPropUtils.getprop(context, "ro.build.description");
        }
        tmp = SystemPropUtils.getprop(context, "ro.lewa.version");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "tcl/" + tmp + "/" + SystemPropUtils.getprop(context, "ro.build.display.id");
        }
        tmp = SystemPropUtils.getprop(context, "ro.gn.gnromvernumber");
        if (!DeviceUtils.isEmpty(tmp)) {
            return "amigo/" + tmp + "/" + SystemPropUtils.getprop(context, "ro.build.display.id");
        }
        tmp = SystemPropUtils.getprop(context, "ro.build.tyd.kbstyle_version");
        return !DeviceUtils.isEmpty(tmp) ? "dido/" + tmp : SystemPropUtils.getprop(context, "ro.build.fingerprint") + "/" + SystemPropUtils.getprop(context, "ro.build.rom.id");
    }

    public static String getVirtualCheck(Context context) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < VIRUAL_CHECK_PROP_NAMES.length; ++i) {
                String propName = VIRUAL_CHECK_PROP_NAMES[i];
                String prop1 = SystemPropUtils.getprop(context, propName);
                sb.append(propName);
                sb.append("=");
                sb.append(prop1 != null ? prop1 : "NA");
                if (i >= VIRUAL_CHECK_PROP_NAMES.length - 1) continue;
                sb.append(";");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static long[] getRAMStat() {
        MemInfoUtils.MemInfo memInfo = MemInfoUtils.getCurrentMemInfo();
        if (memInfo.memAvailable != 0L) {
            return new long[]{memInfo.memAvailable, memInfo.memTotal};
        }
        return new long[]{memInfo.memFree + memInfo.buffers + memInfo.cached, memInfo.memTotal};
    }

    public static long[] getROMStat() {
        return DeviceUtils.getDirectoryAvailableAndTotalSpace(Environment.getDataDirectory().getPath());
    }

    public static long[] getSDCardSpace() {
        if (DeviceUtils.isSDCardMounted()) {
            return DeviceUtils.getDirectoryAvailableAndTotalSpace(Environment.getExternalStorageDirectory().getPath());
        }
        return new long[]{0L, 0L};
    }

    public static boolean isSDCardMounted() {
        try {
            if (Environment.getExternalStorageState().equals("mounted")) {
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public static long[] getDirectoryAvailableAndTotalSpace(String directory) {
        long[] availableAndTotal = new long[2];
        try {
            StatFs statFs = new StatFs(directory);
            availableAndTotal[0] = (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
            availableAndTotal[1] = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return availableAndTotal;
    }
}

