/*
 * Decompiled with CFR 0.152.
 */
package com.xsj.crasheye.session;

import android.content.Context;
import com.xsj.crasheye.log.Logger;
import com.xsj.crasheye.session.MergeSession;
import com.xsj.crasheye.session.SessionManager;
import java.util.Calendar;

class SyncTask
implements Runnable {
    private Context mContext;

    public SyncTask(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.logInfo("[SyncTask] start sync.");
        Class<SyncTask> clazz = SyncTask.class;
        synchronized (SyncTask.class) {
            try {
                SessionManager sessionMgr = SessionManager.getInstance();
                MergeSession mergeSession = sessionMgr.findUnSendSessions(this.mContext);
                if (mergeSession != null && mergeSession.size() > 0) {
                    boolean success = sessionMgr.sendSessionBlocking(this.mContext, mergeSession);
                    if (success) {
                        Logger.logInfo("[SyncTask] sync success.");
                        sessionMgr.deleteSessions(this.mContext, mergeSession);
                    } else {
                        Logger.logError("[SyncTask] sync error.");
                    }
                } else {
                    Logger.logInfo("[SyncTask] nothing to sync.");
                }
                Calendar cal = Calendar.getInstance();
                cal.add(14, 1800000);
                Logger.logInfo("[SyncTask] Next Sync Task Schedule At " + cal.getTime().toString());
            }
            catch (Throwable e) {
                Logger.logError("[SyncTask] sync fail. ");
                e.printStackTrace();
            }
            return;
        }
    }
}

